/*
 * Decompiled with CFR 0.152.
 */
package win.oscene.paycore;

import com.alibaba.fastjson.JSON;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import win.oscene.paycore.AbstractRequest;
import win.oscene.paycore.CheckRequest;
import win.oscene.paycore.ResponseData;
import win.oscene.paycore.SignUtils;

@Service
public class HttpHelper {
    private final RestTemplate restTemplate;

    @Autowired
    public HttpHelper(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    private ResponseData toSign(String url, String requestUri, String json, String signKey) {
        String header = SignUtils.sign(requestUri, signKey);
        HttpHeaders headers = new HttpHeaders();
        headers.add("auth", header);
        headers.add("Content-Type", "application/json;charset=utf-8");
        HttpEntity httpEntity = new HttpEntity((Object)json, (MultiValueMap)headers);
        return (ResponseData)JSON.parseObject((String)((String)this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]).getBody()), ResponseData.class);
    }

    public ResponseData toPay(String url, AbstractRequest request, String signKey) {
        return this.toSign(url + "/data-center/api/v1/order/sign", "/data-center/api/v1/order/sign", JSON.toJSONString((Object)request), signKey);
    }

    public ResponseData check(String url, CheckRequest request, String signKey) {
        return this.toSign(url + "/data-center/api/v1/pay/check", "/data-center/api/v1/pay/check", JSON.toJSONString((Object)request), signKey);
    }
}

