/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.stax;

import com.ctc.wstx.util.ExceptionUtil;
import java.util.NoSuchElementException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.XMLEventAllocator;

public class WstxEventReader
implements XMLEventReader,
XMLStreamConstants {
    protected final int STATE_INITIAL = 1;
    protected final int STATE_EOD = 2;
    protected final int STATE_CONTENT = 3;
    private final XMLEventAllocator mAllocator;
    private final XMLStreamReader mReader;
    private XMLEvent mPeekedEvent = null;
    protected int mState = 1;

    public WstxEventReader(XMLEventAllocator a, XMLStreamReader r) {
        this.mAllocator = a;
        this.mReader = r;
    }

    public void close() {
        try {
            this.mReader.close();
        }
        catch (XMLStreamException sex) {
            this.throwFromSex(sex);
        }
    }

    public String getElementText() throws XMLStreamException {
        if (this.mPeekedEvent != null) {
            XMLEvent evt = this.mPeekedEvent;
            this.mPeekedEvent = null;
            if (evt.isCharacters()) {
                String str = evt.asCharacters().getData();
                return str;
            }
            throw new XMLStreamException("Expected a text token, got " + evt.getEventType() + ".");
        }
        return this.mReader.getElementText();
    }

    public Object getProperty(String name) {
        return null;
    }

    public boolean hasNext() {
        return this.mState != 2;
    }

    public XMLEvent nextEvent() throws XMLStreamException {
        if (this.mState == 2) {
            throw new NoSuchElementException();
        }
        if (this.mState == 1) {
            this.mState = 3;
            return this.createStartEvent();
        }
        if (this.mPeekedEvent != null) {
            XMLEvent evt = this.mPeekedEvent;
            this.mPeekedEvent = null;
            if (evt.isEndDocument()) {
                this.mState = 2;
            }
            return evt;
        }
        return this.createNextEvent(true, this.mReader.next());
    }

    public Object next() {
        try {
            return this.nextEvent();
        }
        catch (XMLStreamException sex) {
            this.throwFromSex(sex);
            return null;
        }
    }

    public XMLEvent nextTag() throws XMLStreamException {
        if (this.mPeekedEvent != null) {
            XMLEvent evt = this.mPeekedEvent;
            this.mPeekedEvent = null;
            switch (evt.getEventType()) {
                case 8: {
                    return null;
                }
                case 6: {
                    break;
                }
                case 4: 
                case 12: {
                    if (((Characters)this.mPeekedEvent).isWhiteSpace()) break;
                    this.throwParseError("Received non-all-whitespace CHARACTERS or CDATA event in nextTag().");
                }
                case 1: 
                case 2: {
                    return evt;
                }
                default: {
                    this.throwParseError("Received event " + this.mPeekedEvent.getEventType() + ", instead of START_ELEMENT or END_ELEMENT.");
                }
            }
        }
        block12: while (true) {
            int next = this.mReader.next();
            switch (next) {
                case 8: {
                    return null;
                }
                case 6: {
                    continue block12;
                }
                case 4: 
                case 12: {
                    if (this.mReader.isWhiteSpace()) continue block12;
                    this.throwParseError("Received non-all-whitespace CHARACTERS or CDATA event in nextTag().");
                }
                case 1: 
                case 2: {
                    return this.createNextEvent(false, next);
                }
            }
            this.throwParseError("Received event " + next + ", instead of START_ELEMENT or END_ELEMENT.");
        }
    }

    public XMLEvent peek() throws XMLStreamException {
        if (this.mPeekedEvent == null) {
            if (this.mState == 2) {
                this.throwEOD();
            }
            if (this.mState == 1) {
                this.mPeekedEvent = this.createStartEvent();
                this.mState = 3;
            } else {
                this.mPeekedEvent = this.createNextEvent(false, this.mReader.next());
            }
        }
        return this.mPeekedEvent;
    }

    public void remove() {
        throw new UnsupportedOperationException("Can not remove events from XMLEventReader.");
    }

    protected XMLEvent createNextEvent(boolean checkEOD, int type) throws XMLStreamException {
        XMLEvent evt = this.mAllocator.allocate(this.mReader);
        if (checkEOD && type == 8) {
            this.mState = 2;
        }
        return evt;
    }

    protected XMLEvent createStartEvent() throws XMLStreamException {
        XMLEvent start = this.mAllocator.allocate(this.mReader);
        return start;
    }

    private void throwEOD() {
        throw new NoSuchElementException();
    }

    protected void throwFromSex(XMLStreamException sex) {
        ExceptionUtil.throwRuntimeException(sex);
    }

    protected void throwParseError(String msg) throws XMLStreamException {
        throw new XMLStreamException(msg, this.mReader.getLocation());
    }
}

