/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.stax;

import com.ctc.wstx.stax.cfg.WriterConfig;
import com.ctc.wstx.stax.ns.EmptyNamespaceContext;
import com.ctc.wstx.stax.stream.BaseStreamWriter;
import com.ctc.wstx.util.StringVector;
import com.ctc.wstx.util.XMLQuoter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.TreeMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;

public class WstxNonNsStreamWriter
extends BaseStreamWriter {
    final StringVector mElements = new StringVector(32);
    TreeMap mAttrNames;

    public WstxNonNsStreamWriter(Writer w, WriterConfig cfg) {
        super(w, cfg);
    }

    public NamespaceContext getNamespaceContext() {
        return EmptyNamespaceContext.getInstance();
    }

    public String getPrefix(String uri) {
        return null;
    }

    public void setDefaultNamespace(String uri) throws XMLStreamException {
        throw new IllegalArgumentException("Can not set default namespace for non-namespace writer.");
    }

    public void setNamespaceContext(NamespaceContext context) {
        throw new IllegalArgumentException("Can not set NamespaceContext for non-namespace writer.");
    }

    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        throw new IllegalArgumentException("Can not set namespace prefix for non-namespace writer.");
    }

    public void writeAttribute(String localName, String value) throws XMLStreamException {
        if (!this.mStartElementOpen) {
            throw new XMLStreamException("Trying to write an attribute when there is no open start element.");
        }
        if (this.mCheckAttr) {
            if (this.mAttrNames == null) {
                this.mAttrNames = new TreeMap();
                this.mAttrNames.put(localName, value);
            } else {
                String old = this.mAttrNames.put(localName, value);
                if (old != null) {
                    throw new IllegalArgumentException("Trying to write attribute '" + localName + "' twice (first value '" + old + "'; second '" + value + "').");
                }
            }
        }
        try {
            this.mWriter.write(32);
            this.mWriter.write(localName);
            this.mWriter.write("=\"");
            XMLQuoter.outputDoubleQuotedAttr(this.mWriter, value);
            this.mWriter.write(34);
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    public void writeAttribute(String nsURI, String localName, String value) throws XMLStreamException {
        this.writeAttribute(localName, value);
    }

    public void writeAttribute(String prefix, String nsURI, String localName, String value) throws XMLStreamException {
        this.writeAttribute(localName, value);
    }

    public void writeDefaultNamespace(String nsURI) throws XMLStreamException {
        throw new IllegalArgumentException("Can not set write namespaces with non-namespace writer.");
    }

    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.doWriteStartElement(localName);
        this.mEmptyElement = true;
    }

    public void writeEmptyElement(String nsURI, String localName) throws XMLStreamException {
        this.writeEmptyElement(localName);
    }

    public void writeEmptyElement(String prefix, String localName, String nsURI) throws XMLStreamException {
        this.writeEmptyElement(localName);
    }

    public void writeEndElement() throws XMLStreamException {
        this.doWriteEndElement(null, this.mCfgOutputEmptyElems);
    }

    public void writeNamespace(String prefix, String nsURI) throws XMLStreamException {
        throw new IllegalArgumentException("Can not set write namespaces with non-namespace writer.");
    }

    public void writeStartElement(String localName) throws XMLStreamException {
        this.doWriteStartElement(localName);
        this.mEmptyElement = false;
    }

    public void writeStartElement(String nsURI, String localName) throws XMLStreamException {
        this.writeStartElement(localName);
    }

    public void writeStartElement(String prefix, String localName, String nsURI) throws XMLStreamException {
        this.writeStartElement(localName);
    }

    public void writeStartElement(StartElement elem) throws XMLStreamException {
        QName name = elem.getName();
        this.writeStartElement(name.getLocalPart());
        Iterator<Attribute> it = elem.getAttributes();
        while (it.hasNext()) {
            Attribute attr = it.next();
            name = attr.getName();
            this.writeAttribute(name.getLocalPart(), attr.getValue());
        }
    }

    public void writeEndElement(QName name) throws XMLStreamException {
        this.doWriteEndElement(this.mCheckStructure ? name.getLocalPart() : null, this.mCfgOutputEmptyElems);
    }

    public void closeStartElement(boolean emptyElem) throws XMLStreamException {
        this.mStartElementOpen = false;
        if (this.mAttrNames != null) {
            this.mAttrNames.clear();
        }
        try {
            if (emptyElem) {
                this.mWriter.write(" />");
            } else {
                this.mWriter.write(62);
            }
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
        if (emptyElem) {
            this.mElements.removeLast();
            if (this.mElements.isEmpty()) {
                this.mState = 3;
            }
        }
    }

    public String getTopElemName() {
        return this.mElements.getLastString();
    }

    private void doWriteStartElement(String localName) throws XMLStreamException {
        this.mAnyOutput = true;
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        }
        if (this.mCheckContent) {
            this.checkNameValidity(localName, true);
        }
        if (this.mState == 1) {
            this.mState = 2;
        } else if (this.mCheckStructure && this.mState == 3) {
            throw new IllegalStateException("Trying to output second root ('" + localName + "').");
        }
        this.mStartElementOpen = true;
        this.mElements.addString(localName);
        try {
            this.mWriter.write(60);
            this.mWriter.write(localName);
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    private void doWriteEndElement(String expName, boolean allowEmpty) throws XMLStreamException {
        if (this.mStartElementOpen && this.mEmptyElement) {
            this.mEmptyElement = false;
            this.closeStartElement(true);
        }
        if (this.mElements.isEmpty()) {
            throw new XMLStreamException("No open start element, when calling writeEndElement.");
        }
        String localName = this.mElements.removeLast();
        if (expName != null && !localName.equals(expName)) {
            throw new IllegalArgumentException("Mismatching close element name, '" + localName + "'; expected '" + expName + "'.");
        }
        if (this.mStartElementOpen) {
            this.mStartElementOpen = false;
            try {
                if (allowEmpty) {
                    this.mWriter.write(" />");
                    if (this.mElements.isEmpty()) {
                        this.mState = 3;
                    }
                    return;
                }
                this.mWriter.write(62);
            }
            catch (IOException ioe) {
                throw new XMLStreamException(ioe);
            }
        }
        try {
            this.mWriter.write("</");
            this.mWriter.write(localName);
            this.mWriter.write(62);
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
        if (this.mElements.isEmpty()) {
            this.mState = 3;
        }
    }
}

