/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.stax.cfg;

import com.ctc.wstx.compat.JdkFeatures;
import com.ctc.wstx.stax.cfg.InputConfigFlags;
import com.ctc.wstx.stax.dtd.DTDReaderProxy;
import com.ctc.wstx.stax.evt.WEntityDeclInt;
import com.ctc.wstx.stax.io.WstxInputResolver;
import com.ctc.wstx.stax.io.XMLResolverWrapper;
import com.ctc.wstx.util.ArgUtil;
import com.ctc.wstx.util.EmptyIterator;
import com.ctc.wstx.util.SymbolTable;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;

public final class ReaderConfig
implements InputConfigFlags {
    public static final int PROP_COALESCE_TEXT = 1;
    public static final int PROP_NAMESPACE_AWARE = 2;
    public static final int PROP_REPLACE_ENTITY_REFS = 3;
    public static final int PROP_SUPPORT_EXTERNAL_ENTITIES = 4;
    public static final int PROP_VALIDATE_AGAINST_DTD = 5;
    public static final int PROP_SUPPORT_DTD = 6;
    public static final int PROP_EVENT_ALLOCATOR = 7;
    public static final int PROP_WARNING_REPORTER = 8;
    public static final int PROP_XML_RESOLVER = 9;
    public static final int PROP_NORMALIZE_LFS = 20;
    public static final int PROP_NORMALIZE_ATTR_VALUES = 21;
    public static final int PROP_INTERN_NS_URIS = 22;
    public static final int PROP_REPORT_ALL_TEXT_AS_CHARACTERS = 23;
    public static final int PROP_REPORT_PROLOG_WS = 24;
    public static final int PROP_CACHE_DTDS = 25;
    public static final int PROP_LAZY_PARSING = 26;
    public static final int PROP_INPUT_BUFFER_LENGTH = 40;
    public static final int PROP_TEXT_BUFFER_LENGTH = 41;
    public static final int PROP_MIN_TEXT_SEGMENT = 42;
    public static final int PROP_CUSTOM_INTERNAL_ENTITIES = 43;
    public static final int PROP_DTD_RESOLVER = 44;
    public static final int PROP_ENTITY_RESOLVER = 45;
    public static final int PROP_BASE_URL = 46;
    static final int MIN_INPUT_BUFFER_LENGTH = 8;
    static final int MIN_TEXT_BUFFER_LENGTH = 32;
    static final int DTD_CACHE_SIZE_J2SE = 30;
    static final int DTD_CACHE_SIZE_J2ME = 10;
    public static final int DEFAULT_SHORTEST_TEXT_SEGMENT = 64;
    static final int DEFAULT_FLAGS_FULL = 50975;
    static final int DEFAULT_FLAGS_J2ME = 50975;
    static final HashMap sProperties = new HashMap(24);
    final boolean mIsJ2MESubset;
    final SymbolTable mSymbols;
    final DTDReaderProxy mDtdReader;
    int mConfigFlags;
    int mInputBufferLen;
    int mTextBufferLen;
    int mMinTextSegmentLen;
    Map mCustomEntities;
    XMLReporter mReporter;
    XMLResolver mXmlResolver = null;
    WstxInputResolver mDtdResolver = null;
    WstxInputResolver mEntityResolver = null;
    URL mBaseURL = null;

    private ReaderConfig(boolean j2meSubset, SymbolTable symbols, DTDReaderProxy dtdReader, int configFlags, int inputBufLen, int textBufLen, int minTextSegmentLen) {
        this.mIsJ2MESubset = j2meSubset;
        this.mSymbols = symbols;
        this.mDtdReader = dtdReader;
        this.mConfigFlags = configFlags;
        this.mInputBufferLen = inputBufLen;
        this.mTextBufferLen = textBufLen;
        this.mMinTextSegmentLen = minTextSegmentLen;
    }

    public static ReaderConfig createJ2MEDefaults(SymbolTable symbols, DTDReaderProxy dtdReader) {
        ReaderConfig rc = new ReaderConfig(true, symbols, dtdReader, 50975, 2000, 1000, 64);
        return rc;
    }

    public static ReaderConfig createFullDefaults(SymbolTable symbols, DTDReaderProxy dtdReader) {
        ReaderConfig rc = new ReaderConfig(false, symbols, dtdReader, 50975, 4000, 2000, 64);
        return rc;
    }

    public ReaderConfig createNonShared(SymbolTable sym) {
        ReaderConfig rc = new ReaderConfig(this.mIsJ2MESubset, sym, this.mDtdReader, this.mConfigFlags, this.mInputBufferLen, this.mTextBufferLen, this.mMinTextSegmentLen);
        rc.mCustomEntities = this.mCustomEntities;
        rc.mReporter = this.mReporter;
        rc.mBaseURL = this.mBaseURL;
        rc.mXmlResolver = this.mXmlResolver;
        rc.mDtdResolver = this.mDtdResolver;
        rc.mEntityResolver = this.mEntityResolver;
        return rc;
    }

    public int getPropertyId(String id) {
        Integer I = (Integer)sProperties.get(id);
        if (I == null) {
            throw new IllegalArgumentException("Unrecognized property '" + id + "'");
        }
        return I;
    }

    public boolean isPropertySupported(String name) {
        boolean b = sProperties.containsKey(name);
        return b;
    }

    public Object getProperty(int id) {
        switch (id) {
            case 1: {
                return this.willCoalesceText() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 2: {
                return this.willSupportNamespaces() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return this.willReplaceEntityRefs() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                return this.willSupportExternalEntities() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return this.willValidateWithDTD() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 6: {
                return this.willSupportDTDs() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 8: {
                return this.getXMLReporter();
            }
            case 9: {
                return this.getXMLResolver();
            }
            case 20: {
                return this.willNormalizeLFs() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 21: {
                return this.willNormalizeAttrValues() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 22: {
                return this.willInternNsURIs() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 23: {
                return this.willReportAllTextAsCharacters() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 24: {
                return this.willReportPrologWhitespace() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 25: {
                return this.willCacheDTDs() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 26: {
                return this.willParseLazily() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 40: {
                return new Integer(this.getInputBufferLength());
            }
            case 41: {
                return new Integer(this.getTextBufferLength());
            }
            case 42: {
                return new Integer(this.getShortestReportedTextSegment());
            }
            case 43: {
                return this.getCustomInternalEntities();
            }
            case 44: {
                return this.getDtdResolver();
            }
            case 45: {
                return this.getEntityResolver();
            }
            case 46: {
                return this.getBaseURL();
            }
        }
        throw new Error("Internal error: no handler for property with internal id " + id + ".");
    }

    public void setProperty(String propName, int id, Object value) {
        switch (id) {
            case 1: {
                this.doCoalesceText(ArgUtil.convertToBoolean(propName, value));
                break;
            }
            case 2: {
                this.doSupportNamespaces(ArgUtil.convertToBoolean(propName, value));
                break;
            }
            case 3: {
                this.doReplaceEntityRefs(ArgUtil.convertToBoolean(propName, value));
                break;
            }
            case 4: {
                this.doSupportExternalEntities(ArgUtil.convertToBoolean(propName, value));
                break;
            }
            case 6: {
                this.doSupportDTDs(ArgUtil.convertToBoolean(propName, value));
                break;
            }
            case 5: {
                this.doValidateWithDTD(ArgUtil.convertToBoolean(propName, value));
                break;
            }
            case 8: {
                this.setXMLReporter((XMLReporter)value);
                break;
            }
            case 9: {
                this.setXMLResolver((XMLResolver)value);
                break;
            }
            case 20: {
                this.doNormalizeLFs(ArgUtil.convertToBoolean(propName, value));
                break;
            }
            case 21: {
                this.doNormalizeAttrValues(ArgUtil.convertToBoolean(propName, value));
                break;
            }
            case 22: {
                this.doInternNsURIs(ArgUtil.convertToBoolean(propName, value));
                break;
            }
            case 24: {
                this.doReportPrologWhitespace(ArgUtil.convertToBoolean(propName, value));
                break;
            }
            case 25: {
                this.doCacheDTDs(ArgUtil.convertToBoolean(propName, value));
                break;
            }
            case 26: {
                this.doParseLazily(ArgUtil.convertToBoolean(propName, value));
                break;
            }
            case 23: {
                this.doReportAllTextAsCharacters(ArgUtil.convertToBoolean(propName, value));
                break;
            }
            case 40: {
                this.setInputBufferLength(ArgUtil.convertToInt(propName, value, 1));
                break;
            }
            case 41: {
                this.setTextBufferLength(ArgUtil.convertToInt(propName, value, 1));
                break;
            }
            case 42: {
                this.setShortestReportedTextSegment(ArgUtil.convertToInt(propName, value, 1));
                break;
            }
            case 43: {
                this.setCustomInternalEntities((Map)value);
                break;
            }
            case 44: {
                this.setDtdResolver((WstxInputResolver)value);
                break;
            }
            case 45: {
                this.setEntityResolver((WstxInputResolver)value);
                break;
            }
            case 46: {
                this.setBaseURL((URL)value);
                break;
            }
            default: {
                throw new Error("Internal error: no handler for property with internal id " + id + ".");
            }
        }
    }

    public SymbolTable getSymbols() {
        return this.mSymbols;
    }

    public DTDReaderProxy getDtdReader() {
        return this.mDtdReader;
    }

    public int getDtdCacheSize() {
        return this.mIsJ2MESubset ? 10 : 30;
    }

    public int getConfigFlags() {
        return this.mConfigFlags;
    }

    public boolean hasConfigFlags(int flags) {
        return (this.mConfigFlags & flags) == flags;
    }

    public boolean willCoalesceText() {
        return this.hasConfigFlags(2);
    }

    public boolean willSupportNamespaces() {
        return this.hasConfigFlags(1);
    }

    public boolean willReplaceEntityRefs() {
        return this.hasConfigFlags(4);
    }

    public boolean willSupportExternalEntities() {
        return this.hasConfigFlags(8);
    }

    public boolean willSupportDTDs() {
        return this.hasConfigFlags(16);
    }

    public boolean willValidateWithDTD() {
        return this.hasConfigFlags(32);
    }

    public boolean willNormalizeLFs() {
        return this.hasConfigFlags(256);
    }

    public boolean willNormalizeAttrValues() {
        return this.hasConfigFlags(512);
    }

    public boolean willInternNsURIs() {
        return this.hasConfigFlags(1024);
    }

    public boolean willReportAllTextAsCharacters() {
        return this.hasConfigFlags(2048);
    }

    public boolean willReportPrologWhitespace() {
        return this.hasConfigFlags(4096);
    }

    public boolean willCacheDTDs() {
        return this.hasConfigFlags(16384);
    }

    public boolean willParseLazily() {
        return this.hasConfigFlags(32768);
    }

    public int getInputBufferLength() {
        return this.mInputBufferLen;
    }

    public int getTextBufferLength() {
        return this.mTextBufferLen;
    }

    public int getShortestReportedTextSegment() {
        return this.mMinTextSegmentLen;
    }

    public Map getCustomInternalEntities() {
        if (this.mCustomEntities == null) {
            return JdkFeatures.getInstance().getEmptyMap();
        }
        int len = this.mCustomEntities.size();
        HashMap m = new HashMap(len + (len >> 2), 0.81f);
        Iterator it = m.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            m.put(me.getKey(), new String((char[])me.getValue()));
        }
        return m;
    }

    public XMLReporter getXMLReporter() {
        return this.mReporter;
    }

    public XMLResolver getXMLResolver() {
        return this.mXmlResolver;
    }

    public URL getBaseURL() {
        return this.mBaseURL;
    }

    public WstxInputResolver getDtdResolver() {
        return this.mDtdResolver;
    }

    public WstxInputResolver getEntityResolver() {
        return this.mEntityResolver;
    }

    private void setConfigFlag(int flag, boolean state) {
        this.mConfigFlags = state ? (this.mConfigFlags |= flag) : (this.mConfigFlags &= ~flag);
    }

    public void setConfigFlags(int flags) {
        this.mConfigFlags = flags;
    }

    public void setConfigFlag(int flag) {
        this.mConfigFlags |= flag;
    }

    public void clearConfigFlag(int flag) {
        this.mConfigFlags &= ~flag;
    }

    public void doCoalesceText(boolean state) {
        this.setConfigFlag(2, state);
    }

    public void doSupportNamespaces(boolean state) {
        this.setConfigFlag(1, state);
    }

    public void doReplaceEntityRefs(boolean state) {
        this.setConfigFlag(4, state);
    }

    public void doSupportExternalEntities(boolean state) {
        this.setConfigFlag(8, state);
    }

    public void doSupportDTDs(boolean state) {
        this.setConfigFlag(16, state);
    }

    public void doValidateWithDTD(boolean state) {
        this.setConfigFlag(32, state);
    }

    public void doNormalizeLFs(boolean state) {
        this.setConfigFlag(256, state);
    }

    public void doNormalizeAttrValues(boolean state) {
        this.setConfigFlag(512, state);
    }

    public void doInternNsURIs(boolean state) {
        this.setConfigFlag(1024, state);
    }

    public void doReportPrologWhitespace(boolean state) {
        this.setConfigFlag(4096, state);
    }

    public void doCacheDTDs(boolean state) {
        this.setConfigFlag(16384, state);
    }

    public void doParseLazily(boolean state) {
        this.setConfigFlag(32768, state);
    }

    public void doReportAllTextAsCharacters(boolean state) {
        this.setConfigFlag(2048, state);
    }

    public void setInputBufferLength(int value) {
        if (value < 8) {
            value = 8;
        }
        this.mInputBufferLen = value;
    }

    public void setTextBufferLength(int value) {
        if (value < 32) {
            value = 32;
        }
        this.mTextBufferLen = value;
    }

    public void setShortestReportedTextSegment(int value) {
        this.mMinTextSegmentLen = value;
    }

    public void setCustomInternalEntities(Map m) {
        HashMap<String, WEntityDeclInt> entMap;
        if (m == null || m.size() < 1) {
            entMap = JdkFeatures.getInstance().getEmptyMap();
        } else {
            int len = m.size();
            entMap = new HashMap<String, WEntityDeclInt>(len + (len >> 1), 0.75f);
            Iterator it = m.entrySet().iterator();
            while (it.hasNext()) {
                char[] ch;
                Map.Entry me = it.next();
                Object val = me.getValue();
                if (val == null) {
                    ch = EmptyIterator.getEmptyCharArray();
                } else if (val instanceof char[]) {
                    ch = (char[])val;
                } else {
                    String str = val.toString();
                    ch = str.toCharArray();
                }
                String name = (String)me.getKey();
                entMap.put(name, WEntityDeclInt.create(name, ch));
            }
        }
        this.mCustomEntities = entMap;
    }

    public void setXMLReporter(XMLReporter r) {
        this.mReporter = r;
    }

    public void setXMLResolver(XMLResolver r) {
        if (r == null) {
            this.mXmlResolver = null;
            this.mEntityResolver = null;
        } else {
            this.mXmlResolver = r;
            this.mEntityResolver = new XMLResolverWrapper(r);
        }
    }

    public void setDtdResolver(WstxInputResolver r) {
        this.mDtdResolver = r;
    }

    public void setEntityResolver(WstxInputResolver r) {
        this.mEntityResolver = r;
    }

    public void setBaseURL(URL baseURL) {
        this.mBaseURL = baseURL;
    }

    public void configureForMaxConformance() {
        this.doNormalizeLFs(true);
        this.doNormalizeAttrValues(true);
    }

    public void configureForMaxConvenience() {
        this.doCoalesceText(true);
        this.doReportAllTextAsCharacters(true);
        this.doReplaceEntityRefs(true);
        this.doReportPrologWhitespace(false);
        this.doParseLazily(false);
    }

    public void configureForMaxSpeed() {
        this.doCoalesceText(false);
        this.setShortestReportedTextSegment(8);
        this.setInputBufferLength(8000);
        this.setTextBufferLength(4000);
        this.doNormalizeLFs(false);
        this.doNormalizeAttrValues(false);
        this.doInternNsURIs(true);
        this.doCacheDTDs(true);
        this.doParseLazily(true);
    }

    public void configureForMinMemUsage() {
        this.doCoalesceText(false);
        this.setShortestReportedTextSegment(64);
        this.setInputBufferLength(512);
        this.setTextBufferLength(512);
        this.doCacheDTDs(false);
        this.doParseLazily(true);
    }

    public void configureForRoundTripping() {
        this.doReportPrologWhitespace(true);
        this.doNormalizeLFs(false);
        this.doNormalizeAttrValues(false);
        this.doCoalesceText(false);
        this.setShortestReportedTextSegment(Integer.MAX_VALUE);
        this.doReplaceEntityRefs(false);
        this.doReportAllTextAsCharacters(false);
    }

    static {
        sProperties.put("javax.xml.stream.isCoalescing", new Integer(1));
        sProperties.put("javax.xml.stream.isNamespaceAware", new Integer(2));
        sProperties.put("javax.xml.stream.isReplacingEntityReferences", new Integer(3));
        sProperties.put("javax.xml.stream.isSupportingExternalEntities", new Integer(4));
        sProperties.put("javax.xml.stream.isValidating", new Integer(5));
        sProperties.put("javax.xml.stream.supportDTD", new Integer(6));
        sProperties.put("javax.xml.stream.allocator", new Integer(7));
        sProperties.put("javax.xml.stream.reporter", new Integer(8));
        sProperties.put("javax.xml.stream.resolver", new Integer(9));
        sProperties.put("com.ctc.wstx.normalizeLFs", new Integer(20));
        sProperties.put("com.ctc.wstx.normalizeAttrValues", new Integer(21));
        sProperties.put("com.ctc.wstx.internURIs", new Integer(22));
        sProperties.put("com.ctc.wstx.reportAllTextAsCharacters", new Integer(23));
        sProperties.put("com.ctc.wstx.reportPrologWhitespace", new Integer(24));
        sProperties.put("com.ctc.wstx.cacheDTDs", new Integer(25));
        sProperties.put("com.ctc.wstx.lazyParsing", new Integer(26));
        sProperties.put("com.ctc.wstx.inputBufferLength", new Integer(40));
        sProperties.put("com.ctc.wstx.textBufferLength", new Integer(41));
        sProperties.put("com.ctc.wstx.minTextSegment", new Integer(42));
        sProperties.put("com.ctc.wstx.customInternalEntities", new Integer(43));
        sProperties.put("com.ctc.wstx.dtdResolver", new Integer(44));
        sProperties.put("com.ctc.wstx.entityResolver", new Integer(45));
        sProperties.put("com.ctc.wstx.baseURL", new Integer(46));
    }
}

