/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.stax.dtd;

import com.ctc.wstx.compat.JdkFeatures;
import com.ctc.wstx.stax.cfg.ErrorConsts;
import com.ctc.wstx.stax.cfg.ReaderConfig;
import com.ctc.wstx.stax.dtd.AttrDefaultValue;
import com.ctc.wstx.stax.dtd.ChoiceContentSpec;
import com.ctc.wstx.stax.dtd.ContentSpec;
import com.ctc.wstx.stax.dtd.DTDAttribute;
import com.ctc.wstx.stax.dtd.DTDElement;
import com.ctc.wstx.stax.dtd.DTDSubset;
import com.ctc.wstx.stax.dtd.DTDSubsetImpl;
import com.ctc.wstx.stax.dtd.DTDWriter;
import com.ctc.wstx.stax.dtd.MinimalDTDReader;
import com.ctc.wstx.stax.dtd.MixedContentSpec;
import com.ctc.wstx.stax.dtd.NameKey;
import com.ctc.wstx.stax.dtd.SeqContentSpec;
import com.ctc.wstx.stax.evt.WEntityDeclExt;
import com.ctc.wstx.stax.evt.WEntityDeclExtParsed;
import com.ctc.wstx.stax.evt.WEntityDeclExtUnparsed;
import com.ctc.wstx.stax.evt.WEntityDeclInt;
import com.ctc.wstx.stax.evt.WEntityDeclaration;
import com.ctc.wstx.stax.evt.WNotationDeclaration;
import com.ctc.wstx.stax.exc.WstxException;
import com.ctc.wstx.stax.io.WstxInputLocation;
import com.ctc.wstx.stax.io.WstxInputSource;
import com.ctc.wstx.stax.stream.StreamScanner;
import com.ctc.wstx.util.StringVector;
import com.ctc.wstx.util.SymbolTable;
import com.ctc.wstx.util.TextBuffer;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.Location;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamException;

public class FullDTDReader
extends MinimalDTDReader {
    static final int EXP_ENTITY_VALUE_LEN = 500;
    static final ContentSpec sContentSpecAny = MixedContentSpec.constructAny();
    static final ContentSpec sContentSpecEmpty = SeqContentSpec.construct(0, null);
    final int mConfigFlags;
    final boolean mCfgNormalizeLFs;
    final boolean mCfgNormAttrs;
    Map mPredefinedPEs;
    boolean mUsesPredefinedPEs = false;
    Map mParamEntities;
    Set mRefdParamEntities;
    Map mGeneralEntities;
    Map mNotations;
    Map mSharedNames = null;
    Map mElements;
    StringVector mElemVector;
    int mIncludeCount = 0;
    DTDWriter mFlattenWriter = null;
    final NameKey mAccessKey = new NameKey(null, null);

    private FullDTDReader(StreamScanner master, WstxInputSource input, ReaderConfig cfg) {
        this(input, cfg, master, false);
        this.mPredefinedPEs = null;
    }

    private FullDTDReader(StreamScanner master, WstxInputSource input, ReaderConfig cfg, DTDSubset intSubset) {
        this(input, cfg, master, true);
        Map pes = intSubset == null ? null : intSubset.getParameterEntityMap();
        this.mPredefinedPEs = pes == null || pes.isEmpty() ? null : pes;
        input.initInputLocation(this);
    }

    private FullDTDReader(WstxInputSource input, ReaderConfig cfg, StreamScanner master, boolean isExt) {
        super(input, cfg, master, isExt);
        int cfgFlags;
        this.mConfigFlags = cfgFlags = cfg.getConfigFlags();
        this.mCfgNormalizeLFs = (cfgFlags & 0x100) != 0;
        this.mCfgNormAttrs = (cfgFlags & 0x200) != 0;
        this.mUsesPredefinedPEs = false;
        this.mParamEntities = null;
        this.mRefdParamEntities = null;
        this.mGeneralEntities = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DTDSubset readInternalSubset(StreamScanner master, WstxInputSource input, ReaderConfig cfg) throws IOException, XMLStreamException {
        DTDSubset ss;
        FullDTDReader r = new FullDTDReader(master, input, cfg);
        r.copyBufferStateFrom(master);
        try {
            ss = r.parseDTD();
        }
        finally {
            master.copyBufferStateFrom(r);
        }
        return ss;
    }

    public static DTDSubset readExternalSubset(StreamScanner master, WstxInputSource src, ReaderConfig cfg, DTDSubset intSubset) throws IOException, XMLStreamException {
        FullDTDReader r = new FullDTDReader(master, src, cfg, intSubset);
        return r.parseDTD();
    }

    public static DTDSubset flattenExternalSubset(WstxInputSource src, Writer flattenWriter, boolean inclComments, boolean inclConditionals, boolean inclPEs) throws IOException, XMLStreamException {
        int configFlags = -1;
        ReaderConfig cfg = ReaderConfig.createFullDefaults(new SymbolTable(), null);
        cfg.clearConfigFlag(256);
        cfg.clearConfigFlag(512);
        FullDTDReader r = new FullDTDReader(null, src, cfg, null);
        r.setFlattenWriter(flattenWriter, inclComments, inclConditionals, inclPEs);
        DTDSubset ss = r.parseDTD();
        r.flushFlattenWriter();
        flattenWriter.flush();
        return ss;
    }

    public void setFlattenWriter(Writer w, boolean inclComments, boolean inclConditionals, boolean inclPEs) {
        this.mFlattenWriter = new DTDWriter(w, inclComments, inclConditionals, inclPEs);
    }

    private void flushFlattenWriter() throws IOException {
        this.mFlattenWriter.flush(this.mInputBuffer, this.mInputPtr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DTDSubset parseDTD() throws IOException, XMLStreamException {
        while (true) {
            int i;
            if ((i = this.getNextAfterWS()) < 0) {
                if (this.mIsExternal) break;
                this.throwUnexpectedEOF(" in internal DTD subset");
            }
            if (i == 37) {
                this.expandPE();
                continue;
            }
            this.mTokenInputTotal = this.mCurrInputProcessed + this.mInputPtr;
            this.mTokenInputRow = this.mCurrInputRow;
            this.mTokenInputCol = this.mInputPtr - this.mCurrInputRowStart;
            if (i == 60) {
                if (this.mFlattenWriter == null) {
                    this.parseDirective();
                    continue;
                }
                this.parseDirectiveFlattened();
                continue;
            }
            if (i == 93) {
                if (this.mIncludeCount > 0) {
                    boolean suppress;
                    boolean bl = suppress = this.mFlattenWriter != null && !this.mFlattenWriter.includeConditionals();
                    if (suppress) {
                        this.mFlattenWriter.flush(this.mInputBuffer, this.mInputPtr - 1);
                        this.mFlattenWriter.disableOutput();
                    }
                    try {
                        char c = this.getNextExpanded();
                        if (c != ']' || (c = this.getNextExpanded()) != '>') {
                            this.throwUnexpectedChar(c, "; expected ']]>' to close conditional include section.");
                        }
                    }
                    finally {
                        if (suppress) {
                            this.mFlattenWriter.enableOutput(this.mInputPtr);
                        }
                    }
                    --this.mIncludeCount;
                    continue;
                }
                if (!this.mIsExternal) break;
            }
            if (this.mIsExternal) {
                this.throwUnexpectedChar(i, " in external DTD subset; expected a '<' to start a directive.");
            }
            this.throwUnexpectedChar(i, " in internal DTD subset; expected a '<' to start a directive, or \"]>\" to end internal subset.");
        }
        DTDSubsetImpl ss = this.mIsExternal ? DTDSubsetImpl.constructInstance(!this.mUsesPredefinedPEs, this.mGeneralEntities, null, this.mRefdParamEntities, this.mNotations, this.mElements) : DTDSubsetImpl.constructInstance(false, this.mGeneralEntities, this.mParamEntities, null, this.mNotations, this.mElements);
        return ss;
    }

    protected void parseDirective() throws IOException, XMLStreamException {
        char c = this.getNextExpanded();
        if (c == '?') {
            this.skipPI();
            return;
        }
        if (c != '!') {
            this.throwUnexpectedChar(c, this.getErrorMsg() + "; expected '!' to start a directive");
        }
        if ((c = this.getNextExpanded()) == '-') {
            c = this.getNextExpanded();
            if (c != '-') {
                this.throwUnexpectedChar(c, this.getErrorMsg() + "; expected '-' for a comment.");
            }
            this.skipComment();
        } else if (c == '[') {
            this.checkInclusion();
        } else if (c >= 'A' && c <= 'Z') {
            this.handleDeclaration(c);
        } else {
            this.throwUnexpectedChar(c, this.getErrorMsg() + ErrorConsts.ERR_DTD_MAINLEVEL_KEYWORD);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseDirectiveFlattened() throws IOException, XMLStreamException {
        this.mFlattenWriter.flush(this.mInputBuffer, this.mInputPtr - 1);
        this.mFlattenWriter.disableOutput();
        char c = this.getNextExpanded();
        if (c == '?') {
            this.mFlattenWriter.enableOutput(this.mInputPtr);
            this.mFlattenWriter.output("<?");
            this.skipPI();
            return;
        }
        if (c != '!') {
            this.throwUnexpectedChar(c, this.getErrorMsg() + ErrorConsts.ERR_DTD_MAINLEVEL_KEYWORD);
        }
        if ((c = this.getNextExpanded()) == '-') {
            boolean comm;
            c = this.getNextExpanded();
            if (c != '-') {
                this.throwUnexpectedChar(c, this.getErrorMsg() + "; expected '-' for a comment.");
            }
            if (comm = this.mFlattenWriter.includeComments()) {
                this.mFlattenWriter.enableOutput(this.mInputPtr);
                this.mFlattenWriter.output("<!--");
            }
            try {
                this.skipComment();
            }
            finally {
                if (!comm) {
                    this.mFlattenWriter.enableOutput(this.mInputPtr);
                }
            }
        } else if (c == '[') {
            boolean cond = this.mFlattenWriter.includeConditionals();
            if (cond) {
                this.mFlattenWriter.enableOutput(this.mInputPtr);
                this.mFlattenWriter.output("<![");
            }
            try {
                this.checkInclusion();
            }
            finally {
                if (!cond) {
                    this.mFlattenWriter.enableOutput(this.mInputPtr);
                }
            }
        } else {
            boolean filterPEs;
            boolean bl = filterPEs = c == 'E' && !this.mFlattenWriter.includeParamEntities();
            if (filterPEs) {
                this.handleSuppressedDeclaration();
            } else if (c >= 'A' && c <= 'Z') {
                this.mFlattenWriter.enableOutput(this.mInputPtr);
                this.mFlattenWriter.output("<!");
                this.mFlattenWriter.output(c);
                this.handleDeclaration(c);
            } else {
                this.throwUnexpectedChar(c, this.getErrorMsg() + ErrorConsts.ERR_DTD_MAINLEVEL_KEYWORD);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initInputSource(WstxInputSource newInput, boolean isExt) throws IOException, XMLStreamException {
        if (this.mFlattenWriter != null) {
            this.mFlattenWriter.flush(this.mInputBuffer, this.mInputPtr);
            this.mFlattenWriter.disableOutput();
            try {
                super.initInputSource(newInput, isExt);
            }
            finally {
                this.mFlattenWriter.enableOutput(this.mInputPtr);
            }
        } else {
            super.initInputSource(newInput, isExt);
        }
    }

    protected boolean loadMore() throws IOException, WstxException {
        WstxInputSource input = this.mInput;
        if (this.mFlattenWriter != null) {
            this.mFlattenWriter.flush(this.mInputBuffer, this.mInputLen);
        }
        do {
            this.mCurrInputProcessed += this.mInputLen;
            this.mCurrInputRowStart -= this.mInputLen;
            int count = input.readInto(this);
            if (count > 0) {
                if (this.mFlattenWriter != null) {
                    this.mFlattenWriter.setFlattenStart(0);
                }
                return true;
            }
            input.close();
            if (input == this.mRootInput) {
                return false;
            }
            WstxInputSource parent = input.getParent();
            if (parent == null) {
                throw new Error("Internal error: null parent for input source '" + input + "'; should never occur (should have stopped at root input '" + this.mRootInput + "'.");
            }
            this.mInput = input = parent;
            input.restoreContext(this);
            if (this.mFlattenWriter == null) continue;
            this.mFlattenWriter.setFlattenStart(this.mInputPtr);
        } while (this.mInputPtr >= this.mInputLen);
        return true;
    }

    protected boolean ensureInput(int minAmount) throws IOException {
        int currAmount = this.mInputLen - this.mInputPtr;
        if (currAmount >= minAmount) {
            return true;
        }
        if (this.mFlattenWriter != null) {
            this.mFlattenWriter.flush(this.mInputBuffer, this.mInputLen);
        }
        if (this.mInput.readMore(this, minAmount)) {
            if (this.mFlattenWriter != null) {
                this.mFlattenWriter.setFlattenStart(currAmount);
            }
            return true;
        }
        return false;
    }

    private char getNextExpanded() throws IOException, XMLStreamException {
        while (true) {
            char c;
            char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
            if (c != '%') {
                return c;
            }
            this.expandPE();
        }
    }

    private char getNextExpandedInDecl() throws IOException, XMLStreamException {
        while (true) {
            char c;
            char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
            if (c == '-') {
                char d;
                char c3 = d = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
                if (d == '-') {
                    this.skipCommentContent();
                    continue;
                }
                --this.mInputPtr;
                return c;
            }
            if (c != '%') {
                return c;
            }
            this.expandPE();
        }
    }

    private char skipDtdWs(boolean allowComments) throws IOException, XMLStreamException {
        while (true) {
            char c;
            char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
            if (c == '%') {
                this.expandPE();
                continue;
            }
            if (c > ' ') {
                if (c == '-' && allowComments) {
                    char c3 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
                    if (c == '-') {
                        this.skipCommentContent();
                        continue;
                    }
                    --this.mInputPtr;
                }
                return c;
            }
            if (c != '\n' && c != '\r') continue;
            this.skipCRLF(c);
        }
    }

    private char skipObligatoryDtdWs(boolean allowComments) throws IOException, XMLStreamException {
        char c = '\u0000';
        int count = 0;
        while (true) {
            char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
            if (c == '%') {
                this.expandPE();
                continue;
            }
            if (c > ' ') {
                if (c != '-' || !allowComments) break;
                char c3 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
                if (c == '-') {
                    this.skipCommentContent();
                    continue;
                }
                --this.mInputPtr;
                break;
            }
            ++count;
            if (c != '\n' && c != '\r') continue;
            this.skipCRLF(c);
        }
        if (count == 0) {
            this.throwUnexpectedChar(c, this.getErrorMsg() + "; expected a separating white space.");
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandPE() throws IOException, XMLStreamException {
        char c;
        String id;
        if (this.mFlattenWriter != null) {
            this.mFlattenWriter.flush(this.mInputBuffer, this.mInputPtr - 1);
            this.mFlattenWriter.disableOutput();
            id = this.readDTDName();
            try {
                c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
            }
            finally {
                this.mFlattenWriter.enableOutput(this.mInputPtr);
            }
        } else {
            id = this.readDTDName();
            char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
        }
        if (c != ';') {
            this.throwUnexpectedChar(c, this.getErrorMsg() + "; expected ';' to end parameter entity name.");
        }
        if (this.mIsExternal) {
            int setId = this.expandEntity(id, this.mParamEntities, null, true);
            if (setId == 1) {
                this.mUsesPredefinedPEs = true;
                this.mRefdParamEntities = null;
            } else if (!this.mUsesPredefinedPEs) {
                HashSet<String> used = this.mRefdParamEntities;
                if (used == null) {
                    this.mRefdParamEntities = used = new HashSet<String>();
                }
                used.add(id);
            }
        } else {
            this.expandEntity(id, this.mParamEntities, null, true);
        }
    }

    protected String checkDTDKeyword(String exp) throws IOException, XMLStreamException {
        char c;
        int i;
        int len = exp.length();
        for (i = 0; i < len; ++i) {
            while (true) {
                char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
                if (c != '%') break;
                this.expandPE();
            }
            if (c != exp.charAt(i)) break;
        }
        if (i == len) {
            c = this.getNextExpanded();
            --this.mInputPtr;
            if (!FullDTDReader.isNameChar(c)) {
                return null;
            }
        }
        StringBuffer sb = new StringBuffer(exp.substring(0, i));
        while (true) {
            char c3;
            if (!FullDTDReader.isNameChar(c3 = this.getNextExpanded()) && c3 != ':') {
                --this.mInputPtr;
                break;
            }
            sb.append(c3);
        }
        return sb.toString();
    }

    protected void checkDTDKeyword(String exp, char firstChar, String extraError) throws IOException, XMLStreamException {
        char c;
        int i;
        if (firstChar != exp.charAt(0) && !FullDTDReader.isNameStartChar(firstChar)) {
            this.throwUnexpectedChar(firstChar, this.getErrorMsg() + extraError);
        }
        int len = exp.length();
        for (i = 1; i < len; ++i) {
            while (true) {
                char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
                if (c != '%') break;
                this.expandPE();
            }
            if (c != exp.charAt(i)) break;
        }
        if (i == len) {
            c = this.getNextExpanded();
            --this.mInputPtr;
            if (!FullDTDReader.isNameChar(c)) {
                return;
            }
        }
        StringBuffer sb = new StringBuffer(exp.substring(0, i));
        while (true) {
            char c3;
            if (!FullDTDReader.isNameChar(c3 = this.getNextExpanded()) && c3 != ':') {
                --this.mInputPtr;
                break;
            }
            sb.append(c3);
        }
        this.throwParseError(this.getErrorMsg() + extraError);
    }

    protected String readDTDKeyword(String prefix) throws IOException, XMLStreamException {
        char c;
        StringBuffer sb;
        boolean gotPrefix = prefix != null && prefix.length() > 0;
        StringBuffer stringBuffer = sb = gotPrefix ? new StringBuffer(prefix) : new StringBuffer();
        if (!gotPrefix) {
            c = this.getNextExpanded();
            if (!FullDTDReader.isNameStartChar(c)) {
                --this.mInputPtr;
                return "";
            }
            sb.append(c);
        }
        while (true) {
            if (!FullDTDReader.isNameChar(c = this.getNextExpanded()) && c != ':') {
                --this.mInputPtr;
                break;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private boolean checkPublicSystemKeyword(char c) throws IOException, XMLStreamException {
        String errId;
        if (c == 'P') {
            errId = this.checkDTDKeyword("UBLIC");
            if (errId == null) {
                return true;
            }
            errId = "P" + errId;
        } else if (c == 'S') {
            errId = this.checkDTDKeyword("YSTEM");
            if (errId == null) {
                return false;
            }
            errId = "S" + errId;
        } else {
            if (!FullDTDReader.isNameStartChar(c)) {
                this.throwUnexpectedChar(c, "; expected 'PUBLIC' or 'SYSTEM' keyword.");
            }
            --this.mInputPtr;
            errId = this.readDTDKeyword(null);
        }
        this.throwParseError("Unrecognized keyword '" + errId + "'; expected 'PUBLIC' or 'SYSTEM'");
        return false;
    }

    private String readDTDName() throws IOException, XMLStreamException {
        return this.readDTDName(this.getNextChar(this.getErrorMsg()));
    }

    private String readDTDName(char c) throws IOException, XMLStreamException {
        return this.parseFullName(c);
    }

    private String readDTDNmtoken(char c) throws IOException, XMLStreamException {
        char[] outBuf = this.getNameBuffer(64);
        int outLen = outBuf.length;
        int outPtr = 0;
        while (true) {
            if (!FullDTDReader.isNameChar(c)) {
                if (outPtr == 0) {
                    this.throwUnexpectedChar(c, this.getErrorMsg() + "; expected a NMTOKEN character to start a NMTOKEN");
                }
                --this.mInputPtr;
                break;
            }
            if (outPtr >= outLen) {
                outBuf = this.expandBy50Pct(outBuf);
                outLen = outBuf.length;
            }
            outBuf[outPtr++] = c;
            c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(" in name token");
        }
        return new String(outBuf, 0, outPtr);
    }

    private NameKey readDTDQName(char firstChar) throws IOException, XMLStreamException {
        String localName;
        String prefix;
        if (!this.mCfgNsEnabled) {
            prefix = null;
            localName = this.parseFullName(firstChar);
        } else {
            char c;
            localName = this.parseLocalName(firstChar);
            char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
            if (c == ':') {
                prefix = localName;
                c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
                localName = this.parseLocalName(c);
            } else {
                --this.mInputPtr;
                prefix = null;
            }
        }
        return this.findSharedName(prefix, localName);
    }

    private int readArity() throws IOException, XMLStreamException {
        char c;
        char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
        if (c == '?') {
            return 2;
        }
        if (c == '*') {
            return 3;
        }
        if (c == '+') {
            return 4;
        }
        --this.mInputPtr;
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private TextBuffer parseEntityValue(String id, Location loc, char quoteChar) throws IOException, XMLStreamException {
        char c;
        WstxInputSource currScope = this.mInput;
        boolean allowPEs = this.mIsExternal || this.mInput != this.mRootInput;
        TextBuffer tb = new TextBuffer(500);
        tb.resetInitialized();
        char[] outBuf = tb.getCurrentSegment();
        int outPtr = tb.getCurrentSegmentSize();
        while (true) {
            block21: {
                if (this.mInputPtr >= this.mInputLen) {
                    boolean check = this.mInput == currScope;
                    this.loadMore(this.getErrorMsg());
                    if (check && this.mInput != currScope) {
                        this.throwParseError("Unterminated entity value for entity '" + id + "' (definition started at " + loc + ")");
                    }
                }
                if ((c = this.mInputBuffer[this.mInputPtr++]) < '?') {
                    if (c == quoteChar) {
                        if (this.mInput == currScope) {
                            tb.setCurrentLength(outPtr);
                            c = this.skipDtdWs(true);
                            if (c == '>') return tb;
                            break;
                        }
                    } else if (c == '&') {
                        char d = this.resolveCharOnlyEntity(false);
                        if (d != '\u0000') {
                            c = d;
                        }
                    } else {
                        if (c == '%') {
                            if (!allowPEs) {
                                this.throwParseError("Can not have parameter entities in entity value defined at the main level of internal subset (XML 1.1, #2.8).");
                            }
                            this.expandPE();
                            continue;
                        }
                        if (c == '\n') {
                            this.markLF();
                        } else if (c == '\r') {
                            if (this.skipCRLF(c)) {
                                if (this.mCfgNormalizeLFs) {
                                    c = '\n';
                                    break block21;
                                } else {
                                    outBuf[outPtr++] = c;
                                    if (outPtr >= outBuf.length) {
                                        outBuf = tb.finishCurrentSegment();
                                        outPtr = 0;
                                    }
                                    outBuf[outPtr++] = 10;
                                    if (outPtr < outBuf.length) continue;
                                    outBuf = tb.finishCurrentSegment();
                                    outPtr = 0;
                                    continue;
                                }
                            }
                            if (this.mCfgNormalizeLFs) {
                                c = '\n';
                            }
                        }
                    }
                }
            }
            outBuf[outPtr++] = c;
            if (outPtr < outBuf.length) continue;
            outBuf = tb.finishCurrentSegment();
            outPtr = 0;
        }
        this.throwDTDUnexpectedChar(c, "; expected closing '>' after ENTITY declaration.");
        return tb;
    }

    private AttrDefaultValue parseAttrDefaultValue(char quoteChar, NameKey attrName) throws IOException, XMLStreamException {
        if (quoteChar != '\"' && quoteChar != '\'') {
            this.throwDTDUnexpectedChar(quoteChar, "; expected a single or double quote to enclose the default value (for attribute '" + attrName + "')");
        }
        ArrayList<String> ents = null;
        TextBuffer tb = new TextBuffer(200);
        tb.resetInitialized();
        int outPtr = 0;
        char[] outBuf = tb.getCurrentSegment();
        int outLen = outBuf.length;
        while (true) {
            char c;
            block21: {
                block22: {
                    block24: {
                        block23: {
                            block20: {
                                char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(" in attribute default value");
                                if (c > ' ') break block20;
                                if (c == '\n') {
                                    this.markLF();
                                } else if (c == '\r') {
                                    c = this.getNextChar(" in attribute default value");
                                    if (c != '\n') {
                                        --this.mInputPtr;
                                        c = this.mCfgNormalizeLFs ? (char)'\n' : '\r';
                                    } else if (!this.mCfgNormalizeLFs && !this.mCfgNormAttrs) {
                                        if (outPtr >= outLen) {
                                            outBuf = this.mTextBuffer.finishCurrentSegment();
                                            outPtr = 0;
                                            outLen = outBuf.length;
                                        }
                                        outBuf[outPtr++] = 13;
                                    }
                                    this.markLF();
                                } else if (c == '\u0000') {
                                    this.throwNullChar();
                                }
                                if (this.mCfgNormAttrs) {
                                    c = ' ';
                                }
                                break block21;
                            }
                            if (c == quoteChar) break;
                            if (c != '&') break block22;
                            if (this.inputInBuffer() < 3) break block23;
                            char c3 = this.resolveSimpleEntity(true);
                            c = c3;
                            if (c3 == '\u0000') break block24;
                            break block21;
                        }
                        char c4 = this.resolveCharOnlyEntity(true);
                        c = c4;
                        if (c4 != '\u0000') break block21;
                    }
                    String id = this.parseEntityName(this.getNextChar(" in attribute default value"));
                    if (ents == null) {
                        ents = new ArrayList<String>();
                    }
                    ents.add(id);
                    tb.setCurrentLength(outPtr);
                    ents.add((String)((Object)new Integer(tb.size())));
                    continue;
                }
                if (c == '<') {
                    this.throwParseError("Unexpected '<'  in attribute default value");
                }
            }
            if (outPtr >= outLen) {
                outBuf = this.mTextBuffer.finishCurrentSegment();
                outPtr = 0;
                outLen = outBuf.length;
            }
            outBuf[outPtr++] = c;
        }
        tb.setCurrentLength(outPtr);
        String coreVal = tb.contentsAsString();
        if (ents == null) {
            return new AttrDefaultValue(coreVal, null, null);
        }
        int len = ents.size() >> 1;
        int[] offsets = new int[len];
        String[] ids = new String[len];
        len = ents.size();
        int j = 0;
        for (int i = 0; i < len; i += 2) {
            ids[j] = (String)ents.get(i);
            offsets[j] = (Integer)ents.get(i + 1);
            ++j;
        }
        return new AttrDefaultValue(coreVal, offsets, ids);
    }

    private void checkInclusion() throws IOException, XMLStreamException {
        String keyword;
        if (!this.mIsExternal && this.mInput == this.mRootInput) {
            this.throwParseError("Internal DTD subset can not use (INCLUDE/IGNORE) directives (except via external entities).");
        }
        if (this.skipDtdWs(false) != 'I') {
            keyword = this.readDTDKeyword("I");
        } else {
            char c = this.getNextExpanded();
            if (c == 'G') {
                keyword = this.checkDTDKeyword("NORE");
                if (keyword == null) {
                    this.handleIgnored();
                    return;
                }
                keyword = "IG" + keyword;
            } else if (c == 'N') {
                keyword = this.checkDTDKeyword("CLUDE");
                if (keyword == null) {
                    this.handleIncluded();
                    return;
                }
                keyword = "IN" + keyword;
            } else {
                --this.mInputPtr;
                keyword = this.readDTDKeyword("I");
            }
        }
        this.throwParseError("Unrecognized directive '" + keyword + "'; expected either 'IGNORE' or 'INCLUDE'.");
    }

    private void handleIncluded() throws IOException, XMLStreamException {
        char c = this.skipDtdWs(false);
        if (c != '[') {
            this.throwUnexpectedChar(c, this.getErrorMsg() + "; expected '[' to follow 'INCLUDE' directive.");
        }
        ++this.mIncludeCount;
    }

    private void handleIgnored() throws IOException, XMLStreamException {
        char c = this.skipDtdWs(false);
        int count = 1;
        if (c != '[') {
            this.throwUnexpectedChar(c, "; expected '[' to follow 'IGNORE' directive.");
        }
        String errorMsg = this.getErrorMsg();
        while (true) {
            char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(errorMsg);
            if (c == '\n' || c == '\r') {
                this.skipCRLF(c);
                continue;
            }
            if (c == ']') {
                if (this.getNextChar(errorMsg) == ']' && this.getNextChar(errorMsg) == '>') {
                    if (--count >= 1) continue;
                    return;
                }
                --this.mInputPtr;
                continue;
            }
            if (c != '<') continue;
            if (this.getNextChar(errorMsg) == '!' && this.getNextChar(errorMsg) == '[') {
                ++count;
                continue;
            }
            --this.mInputPtr;
        }
    }

    private void reportBadDirective(String dir) throws WstxException {
        this.throwParseError("Unrecognized DTD directive '<!" + dir + " >'; expected ATTLIST, ELEMENT, ENTITY or NOTATION");
    }

    private void throwDTDUnexpectedChar(char c, String extraMsg) throws WstxException {
        if (extraMsg == null) {
            this.throwUnexpectedChar(c, this.getErrorMsg());
        }
        this.throwUnexpectedChar(c, this.getErrorMsg() + extraMsg);
    }

    private void handleDeclaration(char c) throws IOException, XMLStreamException {
        String keyw = null;
        if (c == 'A') {
            keyw = this.checkDTDKeyword("TTLIST");
            if (keyw == null) {
                this.handleAttlistDecl();
                return;
            }
            keyw = "A" + keyw;
        } else if (c == 'E') {
            c = this.getNextExpanded();
            if (c == 'N') {
                keyw = this.checkDTDKeyword("TITY");
                if (keyw == null) {
                    this.handleEntityDecl(false);
                    return;
                }
                keyw = "EN" + keyw;
            } else if (c == 'L') {
                keyw = this.checkDTDKeyword("EMENT");
                if (keyw == null) {
                    this.handleElementDecl();
                    return;
                }
                keyw = "EL" + keyw;
            } else {
                keyw = this.readDTDKeyword("E");
            }
        } else if (c == 'N') {
            keyw = this.checkDTDKeyword("OTATION");
            if (keyw == null) {
                this.handleNotationDecl();
                return;
            }
            keyw = "N" + keyw;
        } else {
            --this.mInputPtr;
            keyw = this.readDTDKeyword(null);
        }
        this.reportBadDirective(keyw);
    }

    private void handleSuppressedDeclaration() throws IOException, XMLStreamException {
        String keyw;
        char c = this.getNextExpanded();
        if (c == 'N') {
            keyw = this.checkDTDKeyword("TITY");
            if (keyw == null) {
                this.handleEntityDecl(true);
                return;
            }
            keyw = "EN" + keyw;
            this.mFlattenWriter.enableOutput(this.mInputPtr);
        } else {
            this.mFlattenWriter.enableOutput(this.mInputPtr);
            this.mFlattenWriter.output("<!E");
            this.mFlattenWriter.output(c);
            if (c == 'L') {
                keyw = this.checkDTDKeyword("EMENT");
                if (keyw == null) {
                    this.handleElementDecl();
                    return;
                }
                keyw = "EL" + keyw;
            } else {
                keyw = this.readDTDKeyword("E");
            }
        }
        this.reportBadDirective(keyw);
    }

    private void handleAttlistDecl() throws IOException, XMLStreamException {
        char c = this.skipObligatoryDtdWs(true);
        NameKey elemName = this.readDTDQName(c);
        Location loc = this.getLocation();
        Map m = this.getElementMap();
        DTDElement elem = (DTDElement)m.get(elemName);
        if (elem == null) {
            elem = new DTDElement(loc, elemName, null);
            m.put(elemName, elem);
        }
        int index = 0;
        while (true) {
            if (FullDTDReader.isSpaceChar(c = this.getNextExpanded())) {
                --this.mInputPtr;
                c = this.skipDtdWs(true);
            } else if (c != '>') {
                this.throwDTDUnexpectedChar(c, "; excepted either '>' closing ATTLIST declaration, or a white space character separating individual attribute declarations");
            }
            if (c == '>') break;
            this.handleAttrDecl(elem, c, index);
            ++index;
        }
    }

    private void handleElementDecl() throws IOException, XMLStreamException {
        Map m;
        DTDElement oldElem;
        ContentSpec spec;
        Location loc;
        NameKey elemName;
        char c;
        block7: {
            block8: {
                String keyw;
                block11: {
                    block12: {
                        block13: {
                            block9: {
                                block10: {
                                    block6: {
                                        c = this.skipObligatoryDtdWs(true);
                                        elemName = this.readDTDQName(c);
                                        loc = this.getLocation();
                                        c = this.skipObligatoryDtdWs(true);
                                        spec = null;
                                        if (c != '(') break block6;
                                        c = this.skipDtdWs(true);
                                        if (c == '#') {
                                            spec = this.readMixedSpec(elemName);
                                        } else {
                                            --this.mInputPtr;
                                            spec = this.readContentSpec(elemName);
                                        }
                                        break block7;
                                    }
                                    if (!FullDTDReader.isNameStartChar(c)) break block8;
                                    keyw = null;
                                    if (c != 'A') break block9;
                                    keyw = this.checkDTDKeyword("NY");
                                    if (keyw != null) break block10;
                                    spec = sContentSpecAny;
                                    break block7;
                                }
                                keyw = "A" + keyw;
                                break block11;
                            }
                            if (c != 'E') break block12;
                            keyw = this.checkDTDKeyword("MPTY");
                            if (keyw != null) break block13;
                            spec = sContentSpecEmpty;
                            break block7;
                        }
                        keyw = "E" + keyw;
                        break block11;
                    }
                    --this.mInputPtr;
                    keyw = this.readDTDKeyword(null);
                }
                this.throwParseError("Unrecognized DTD content spec keyword '" + keyw + "'; expected ANY or EMPTY");
                break block7;
            }
            this.throwUnexpectedChar(c, this.getErrorMsg() + ": excepted '(' to start content specification");
        }
        c = this.skipDtdWs(true);
        if (c != '>') {
            this.throwUnexpectedChar(c, this.getErrorMsg() + "; expected '>' to finish the ENTITY declaration");
        }
        if ((oldElem = (DTDElement)(m = this.getElementMap()).get(elemName)) != null) {
            if (oldElem.isDefined()) {
                DTDSubsetImpl.throwElementException(oldElem, loc);
            }
            oldElem.setContentSpec(spec);
            oldElem.setLocation(loc);
        } else {
            oldElem = new DTDElement(loc, elemName, spec);
            m.put(elemName, oldElem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEntityDecl(boolean suppressPEDecl) throws IOException, XMLStreamException {
        Object old;
        Map<String, WEntityDeclExt> m;
        WEntityDeclaration ent;
        boolean isParam;
        String emsg = this.getErrorMsg();
        char c = this.getNextCharAfterWS(emsg);
        boolean bl = isParam = c == '%';
        if (suppressPEDecl && !isParam) {
            this.mFlattenWriter.enableOutput(this.mInputPtr);
            this.mFlattenWriter.output("<!ENTITY ");
            this.mFlattenWriter.output(c);
        }
        if (isParam) {
            c = this.skipObligatoryDtdWs(true);
        }
        String id = this.readDTDName(c);
        Location evtLoc = this.getLocation();
        try {
            c = this.skipDtdWs(true);
            if (c == '\'' || c == '\"') {
                char foo = this.getNextChar(emsg);
                WstxInputLocation contentLoc = this.getLastCharLocation();
                --this.mInputPtr;
                TextBuffer contents = this.parseEntityValue(id, contentLoc, c);
                ent = new WEntityDeclInt(evtLoc, id, this.getSource(), contents.contentsAsArray(), contentLoc);
            } else {
                if (!FullDTDReader.isNameStartChar(c)) {
                    this.throwUnexpectedChar(c, this.getErrorMsg() + "; expected either quoted value, or keyword 'PUBLIC' or 'SYSTEM'.");
                }
                ent = this.handleExternalEntityDecl(isParam, id, c, evtLoc);
            }
            Object var12_12 = null;
            if (suppressPEDecl && isParam) {
                this.mFlattenWriter.enableOutput(this.mInputPtr);
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (suppressPEDecl && isParam) {
                this.mFlattenWriter.enableOutput(this.mInputPtr);
            }
            throw throwable;
        }
        if (isParam) {
            m = this.mParamEntities;
            if (m == null) {
                this.mParamEntities = m = new HashMap<String, WEntityDeclExt>();
            }
        } else {
            m = this.mGeneralEntities;
            if (m == null) {
                m = JdkFeatures.getInstance().getInsertOrderedMap();
                this.mGeneralEntities = m;
            }
        }
        if (m.size() > 0 && (old = m.get(id)) != null) {
            XMLReporter rep = this.mConfig.getXMLReporter();
            if (rep != null) {
                WEntityDeclaration oldED = (WEntityDeclaration)old;
                String str = " entity '" + id + "' defined more than once: first declaration at " + oldED.getLocation();
                str = isParam ? "Parameter" + str : "General" + str;
                try {
                    rep.report(str, ErrorConsts.WT_ENT_DECL, oldED, evtLoc);
                }
                catch (XMLStreamException strex) {
                    this.throwFromStrE(strex);
                }
            }
        } else {
            m.put(id, (WEntityDeclExt)ent);
        }
    }

    private void handleNotationDecl() throws IOException, XMLStreamException {
        String sysId;
        String pubId;
        char c = this.skipObligatoryDtdWs(true);
        String id = this.readDTDName(c);
        c = this.skipObligatoryDtdWs(true);
        boolean isPublic = this.checkPublicSystemKeyword(c);
        c = this.skipObligatoryDtdWs(true);
        if (isPublic) {
            if (c != '\"' && c != '\'') {
                this.throwUnexpectedChar(c, this.getErrorMsg() + "; expected a quote to start the public identifier.");
            }
            pubId = this.parsePublicId(c, this.mCfgNormalizeLFs, this.getErrorMsg());
            c = this.skipDtdWs(true);
        } else {
            pubId = null;
        }
        if (c == '\"' || c == '\'') {
            sysId = this.parseSystemId(c, this.mCfgNormalizeLFs, this.getErrorMsg());
            c = this.skipDtdWs(true);
        } else {
            if (!isPublic) {
                this.throwUnexpectedChar(c, this.getErrorMsg() + "; expected a quote to start the system identifier.");
            }
            sysId = null;
        }
        if (c != '>') {
            this.throwUnexpectedChar(c, "; expected closing '>' after NOTATION declaration.");
        }
        Location evtLoc = this.getLocation();
        WNotationDeclaration nd = new WNotationDeclaration(evtLoc, id, pubId, sysId);
        Map m = this.mNotations;
        if (m == null) {
            this.mNotations = m = JdkFeatures.getInstance().getInsertOrderedMap();
        } else {
            WNotationDeclaration oldDecl = (WNotationDeclaration)m.get(id);
            if (oldDecl != null) {
                DTDSubsetImpl.throwNotationException(oldDecl, nd);
            }
        }
        m.put(id, nd);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleAttrDecl(DTDElement elem, char c, int index) throws IOException, XMLStreamException {
        AttrDefaultValue defVal;
        int defType;
        int type;
        NameKey attrName;
        block22: {
            block24: {
                String defTypeStr;
                block25: {
                    block21: {
                        block23: {
                            attrName = this.readDTDQName(c);
                            c = this.skipObligatoryDtdWs(true);
                            type = 0;
                            if (c != '(') break block23;
                            List l = this.parseEnumerated(false);
                            type = 2;
                            break block21;
                        }
                        String typeStr = this.readDTDName(c);
                        switch (typeStr.charAt(0)) {
                            case 'C': {
                                if (typeStr != "CDATA") break;
                                type = 1;
                                break block21;
                            }
                            case 'I': {
                                if (typeStr == "ID") {
                                    type = 3;
                                    break block21;
                                } else if (typeStr == "IDREF") {
                                    type = 4;
                                    break block21;
                                } else {
                                    if (typeStr != "IDREFS") break;
                                    type = 5;
                                }
                                break block21;
                            }
                            case 'E': {
                                if (typeStr == "ENTITY") {
                                    type = 6;
                                    break block21;
                                } else {
                                    if (typeStr != "ENTITIES") break;
                                    type = 7;
                                }
                                break block21;
                            }
                            case 'N': {
                                if (typeStr == "NOTATION") {
                                    type = 8;
                                    c = this.skipObligatoryDtdWs(true);
                                    if (c != '(') {
                                        this.throwDTDUnexpectedChar(c, "Excepted '(' to start the list of NOTATION ids");
                                    }
                                    List l = this.parseEnumerated(true);
                                } else if (typeStr == "NMTOKEN") {
                                    type = 9;
                                } else {
                                    if (typeStr != "NMTOKENS") break;
                                    type = 10;
                                }
                                break block21;
                            }
                        }
                        this.throwParseError("Unrecognized attribute type '" + typeStr + "'" + ErrorConsts.ERR_DTD_ATTR_TYPE);
                    }
                    defType = 1;
                    defVal = null;
                    c = this.skipDtdWs(true);
                    if (c != '#') break block24;
                    defTypeStr = this.readDTDName();
                    if (defTypeStr != "REQUIRED") break block25;
                    defType = 3;
                    break block22;
                }
                if (defTypeStr == "IMPLIED") {
                    defType = 2;
                    break block22;
                } else if (defTypeStr == "FIXED") {
                    defType = 4;
                    c = this.skipObligatoryDtdWs(true);
                    defVal = this.parseAttrDefaultValue(c, attrName);
                    break block22;
                } else {
                    this.throwParseError("Unrecognized attribute default value directive #" + defTypeStr + ErrorConsts.ERR_DTD_DEFAULT_TYPE);
                }
                break block22;
            }
            defVal = this.parseAttrDefaultValue(c, attrName);
        }
        DTDAttribute attr = new DTDAttribute(attrName, index, type, defType, defVal);
        elem.addAttribute(attr);
    }

    private List parseEnumerated(boolean isNotation) throws IOException, XMLStreamException {
        char c = this.skipDtdWs(true);
        if (c == ')') {
            this.throwDTDUnexpectedChar(c, " (empty list; missing identifier(s))?");
        }
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.readDTDNmtoken(c));
        while ((c = this.skipDtdWs(true)) != ')') {
            if (c != '|') {
                this.throwDTDUnexpectedChar(c, "; missing '|' separator?");
            }
            c = this.skipDtdWs(true);
            l.add(this.readDTDNmtoken(c));
        }
        return l;
    }

    private ContentSpec readMixedSpec(NameKey elemName) throws IOException, XMLStreamException {
        char c;
        String keyw = this.checkDTDKeyword("PCDATA");
        if (keyw != null) {
            this.throwParseError("Unrecognized directive #" + keyw + "'; expected #PCDATA (or element name)");
        }
        boolean count = false;
        StringVector elems = this.mElemVector;
        if (elems == null) {
            this.mElemVector = elems = new StringVector(120);
        } else {
            elems.clear(false);
        }
        while ((c = this.skipDtdWs(true)) != ')') {
            if (c == '|') {
                c = this.skipDtdWs(true);
            } else if (c == ',') {
                this.throwUnexpectedChar(c, " (sequences not allowed with mixed content)");
            }
            NameKey n = this.readDTDQName(c);
            elems.addStrings(n.getPrefix(), n.getLocalName());
        }
        char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
        if (c != '*') {
            if (elems.size() > 0) {
                this.throwParseError("Missing trailing '*' after a non-empty mixed content specification");
            }
            --this.mInputPtr;
        }
        return MixedContentSpec.construct(elems);
    }

    private ContentSpec readContentSpec(NameKey elemName) throws IOException, XMLStreamException {
        ArrayList<Object> subSpecs = new ArrayList<Object>();
        boolean isChoice = false;
        boolean choiceSet = false;
        while (true) {
            char c;
            if ((c = this.skipDtdWs(true)) == ')') {
                if (!subSpecs.isEmpty()) break;
                this.throwParseError("Empty content specification for '" + elemName + "' (need at least one entry)");
                break;
            }
            if (c == '|' || c == ',') {
                boolean newChoice;
                boolean bl = newChoice = c == '|';
                if (!choiceSet) {
                    isChoice = newChoice;
                    choiceSet = true;
                } else if (isChoice != newChoice) {
                    this.throwParseError("Can not mix content spec separators ('|' and ','); need to use parenthesis groups");
                }
                c = this.skipDtdWs(true);
            } else if (!subSpecs.isEmpty()) {
                this.throwDTDUnexpectedChar(c, " (missing separator '|' or ','?)");
            }
            if (c == '(') {
                subSpecs.add(this.readContentSpec(elemName));
                continue;
            }
            if (c == '|' || c == ',') {
                this.throwDTDUnexpectedChar(c, " (missing element name?)");
            }
            NameKey thisName = this.readDTDQName(c);
            int arity = this.readArity();
            if (arity == 1) {
                subSpecs.add(thisName);
                continue;
            }
            subSpecs.add(thisName);
        }
        int arity = this.readArity();
        if (isChoice) {
            return ChoiceContentSpec.construct(arity, subSpecs);
        }
        return SeqContentSpec.construct(arity, subSpecs);
    }

    private WEntityDeclExt handleExternalEntityDecl(boolean isParam, String id, char c, Location evtLoc) throws IOException, XMLStreamException {
        Object errId = null;
        boolean isPublic = this.checkPublicSystemKeyword(c);
        String pubId = null;
        if (isPublic) {
            c = this.skipObligatoryDtdWs(true);
            if (c != '\"' && c != '\'') {
                this.throwUnexpectedChar(c, this.getErrorMsg() + "; expected a quote to start the public identifier.");
            }
            pubId = this.parsePublicId(c, this.mCfgNormalizeLFs, this.getErrorMsg());
        }
        if ((c = this.skipObligatoryDtdWs(true)) != '\"' && c != '\'') {
            this.throwUnexpectedChar(c, this.getErrorMsg() + "; expected a quote to start the system identifier.");
        }
        String sysId = this.parseSystemId(c, this.mCfgNormalizeLFs, this.getErrorMsg());
        String notationId = null;
        c = this.skipDtdWs(true);
        if (c != '>') {
            this.checkDTDKeyword("NDATA", c, "; expected either NDATA keyword, or closing '>'.");
            c = this.skipObligatoryDtdWs(true);
            notationId = this.readDTDName(c);
            c = this.skipDtdWs(true);
        }
        if (c != '>') {
            this.throwUnexpectedChar(c, this.getErrorMsg() + "; expected closing '>'.");
        }
        if (notationId == null) {
            return new WEntityDeclExtParsed(evtLoc, id, this.getSource(), pubId, sysId);
        }
        return new WEntityDeclExtUnparsed(evtLoc, id, this.getSource(), pubId, sysId, notationId);
    }

    private Map getElementMap() {
        Map m = this.mElements;
        if (m == null) {
            this.mElements = m = JdkFeatures.getInstance().getInsertOrderedMap();
        }
        return m;
    }

    private NameKey findSharedName(String prefix, String localName) {
        HashMap<NameKey, NameKey> m = this.mSharedNames;
        if (this.mSharedNames == null) {
            this.mSharedNames = m = new HashMap<NameKey, NameKey>();
        } else {
            NameKey key = this.mAccessKey;
            key.reset(prefix, localName);
            key = (NameKey)m.get(key);
            if (key != null) {
                return key;
            }
        }
        NameKey result = new NameKey(prefix, localName);
        m.put(result, result);
        return result;
    }
}

