/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.stax.io;

import com.ctc.wstx.stax.cfg.ErrorConsts;
import com.ctc.wstx.stax.exc.WstxEOFException;
import com.ctc.wstx.stax.exc.WstxException;
import com.ctc.wstx.stax.io.InputBootstrapper;
import com.ctc.wstx.stax.io.MergedReader;
import com.ctc.wstx.stax.io.WstxInputLocation;
import java.io.IOException;
import java.io.Reader;
import java.text.MessageFormat;
import javax.xml.stream.Location;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamException;

public final class ReaderBootstrapper
extends InputBootstrapper {
    final Reader mIn;
    final String mAppEncoding;
    final char[] mCharBuffer;
    private int mInputPtr;
    private int mInputLen;

    private ReaderBootstrapper(Reader r, String pubId, String sysId, int bufSize, String appEncoding) {
        super(pubId, sysId);
        this.mIn = r;
        bufSize = 128;
        this.mCharBuffer = new char[bufSize];
        this.mAppEncoding = appEncoding;
    }

    public static ReaderBootstrapper getInstance(Reader r, String pubId, String sysId, int bufSize, String appEncoding) {
        return new ReaderBootstrapper(r, pubId, sysId, bufSize, appEncoding);
    }

    public Reader bootstrapInput(boolean mainDoc, XMLReporter rep) throws IOException, WstxException {
        this.initialLoad(this.mCharBuffer.length);
        if (this.mInputLen >= 6 && this.mCharBuffer[0] == '<' && this.mCharBuffer[1] == '?' && this.mCharBuffer[2] == 'x' && this.mCharBuffer[3] == 'm' && this.mCharBuffer[4] == 'l' && (this.mCharBuffer[5] & 0xFF) <= 32) {
            this.mInputPtr = 6;
            this.readXmlDecl(mainDoc);
            if (this.mFoundEncoding != null && this.mAppEncoding != null) {
                this.verifyXmlEncoding(rep);
            }
        }
        if (this.mInputPtr < this.mInputLen) {
            return new MergedReader(this.mIn, this.mCharBuffer, this.mInputPtr, this.mInputLen);
        }
        return this.mIn;
    }

    public String getAppEncoding() {
        return this.mAppEncoding;
    }

    public int getInputTotal() {
        return this.mInputProcessed + this.mInputPtr;
    }

    public int getInputColumn() {
        return this.mInputPtr - this.mInputRowStart;
    }

    protected void verifyXmlEncoding(XMLReporter rep) throws WstxException {
        String appEnc = this.mAppEncoding;
        if (appEnc.equalsIgnoreCase(this.mFoundEncoding)) {
            return;
        }
        if ((appEnc = appEnc.toUpperCase()).equals("UTF8") && this.mFoundEncoding.equals("UTF-8")) {
            return;
        }
        Location loc = this.getLocation();
        try {
            rep.report(MessageFormat.format(ErrorConsts.W_MIXED_ENCODINGS, this.mFoundEncoding, this.mAppEncoding), ErrorConsts.WT_XML_DECL, this, loc);
        }
        catch (XMLStreamException ex) {
            throw new WstxException(ex.toString(), loc);
        }
    }

    protected boolean initialLoad(int minimum) throws IOException {
        this.mInputPtr = 0;
        this.mInputLen = 0;
        while (this.mInputLen < minimum) {
            int count = this.mIn.read(this.mCharBuffer, this.mInputLen, this.mCharBuffer.length - this.mInputLen);
            if (count < 1) {
                return false;
            }
            this.mInputLen += count;
        }
        return true;
    }

    protected void loadMore() throws IOException, WstxException {
        this.mInputProcessed += this.mInputLen;
        this.mInputRowStart -= this.mInputLen;
        this.mInputPtr = 0;
        this.mInputLen = this.mIn.read(this.mCharBuffer, 0, this.mCharBuffer.length);
        if (this.mInputLen < 1) {
            throw new WstxEOFException(" in xml declaration", this.getLocation());
        }
    }

    protected void pushback() {
        --this.mInputPtr;
    }

    protected int getNext() throws IOException, WstxException {
        return this.mInputPtr < this.mInputLen ? this.mCharBuffer[this.mInputPtr++] : this.nextChar();
    }

    protected int getNextAfterWs(boolean reqWs) throws IOException, WstxException {
        int count = 0;
        while (true) {
            char c;
            char c2 = c = this.mInputPtr < this.mInputLen ? this.mCharBuffer[this.mInputPtr++] : this.nextChar();
            if (c > ' ') {
                if (reqWs && count == 0) {
                    this.reportUnexpectedChar(c, "; expected a white space");
                }
                return c;
            }
            if (c == '\r' || c == '\n') {
                this.skipCRLF(c);
            } else if (c == '\u0000') {
                this.reportNull();
            }
            ++count;
        }
    }

    protected int checkKeyword(String exp) throws IOException, WstxException {
        int len = exp.length();
        for (int ptr = 1; ptr < len; ++ptr) {
            char c;
            char c2 = c = this.mInputPtr < this.mInputLen ? this.mCharBuffer[this.mInputPtr++] : this.nextChar();
            if (c != exp.charAt(ptr)) {
                return c;
            }
            if (c != '\u0000') continue;
            this.reportNull();
        }
        return 0;
    }

    protected int readQuotedValue(char[] kw, int quoteChar, boolean norm) throws IOException, WstxException {
        int i = 0;
        int len = kw.length;
        while (i < len) {
            int c;
            int n = c = this.mInputPtr < this.mInputLen ? this.mCharBuffer[this.mInputPtr++] : this.nextChar();
            if (c == 0) {
                this.reportNull();
            }
            if (c == quoteChar) {
                return i;
            }
            if (norm) {
                c = c <= 32 || c == 95 ? 45 : Character.toUpperCase((char)c);
            }
            kw[i++] = c;
        }
        return -1;
    }

    protected Location getLocation() {
        return new WstxInputLocation(null, this.mPublicId, this.mSystemId, this.mInputProcessed + this.mInputPtr - 1, this.mInputRow, this.mInputPtr - this.mInputRowStart);
    }

    protected char nextChar() throws IOException, WstxException {
        if (this.mInputPtr >= this.mInputLen) {
            this.loadMore();
        }
        return this.mCharBuffer[this.mInputPtr++];
    }

    protected void skipCRLF(char lf) throws IOException, WstxException {
        if (lf == '\r') {
            char c;
            char c2 = c = this.mInputPtr < this.mInputLen ? this.mCharBuffer[this.mInputPtr++] : this.nextChar();
            if (c != '\n') {
                --this.mInputPtr;
            }
        }
        ++this.mInputRow;
        this.mInputRowStart = this.mInputPtr;
    }
}

