/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.stax.io;

import com.ctc.wstx.compat.JdkFeatures;
import com.ctc.wstx.stax.io.InputSourceFactory;
import com.ctc.wstx.stax.io.ReaderSource;
import com.ctc.wstx.stax.io.StreamBootstrapper;
import com.ctc.wstx.stax.io.WstxInputResolver;
import com.ctc.wstx.stax.io.WstxInputSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;

public final class XMLResolverWrapper
implements WstxInputResolver {
    static final int DEFAULT_BUFFER_SIZE = 1000;
    static final String DEFAULT_ENCODING = "UTF-8";
    final XMLResolver mResolver;

    public XMLResolverWrapper(XMLResolver r) {
        this.mResolver = r;
    }

    public WstxInputSource resolveReference(WstxInputSource refCtxt, String entityId, String publicId, String systemId, URL assumedLoc) throws IOException {
        try {
            Object src = this.mResolver.resolveEntity(publicId, systemId, assumedLoc.toString(), entityId);
            if (src == null) {
                return null;
            }
            if (!(src instanceof InputStream)) {
                throw new IOException("Unimplemented type of input source: " + src.getClass() + ".");
            }
            int bufLen = refCtxt == null ? 1000 : refCtxt.getInputBufferLength();
            StreamBootstrapper bs = StreamBootstrapper.getInstance((InputStream)src, publicId, systemId, bufLen);
            Reader r = bs.bootstrapInput(false, null);
            ReaderSource rsrc = InputSourceFactory.constructReaderSource(refCtxt, entityId, bs, publicId, systemId, assumedLoc, r, true, bufLen);
            return rsrc;
        }
        catch (XMLStreamException wex) {
            IOException ioe = new IOException(wex.toString());
            JdkFeatures.getInstance().setInitCause(ioe, wex);
            throw ioe;
        }
    }
}

