/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.stax.ns;

import com.ctc.wstx.stax.ns.AttributeCollector;
import com.ctc.wstx.stax.ns.BaseNsContext;
import com.ctc.wstx.stax.ns.CompactNsContext;
import com.ctc.wstx.stax.ns.InputElementStack;
import com.ctc.wstx.stax.ns.NsAttributeCollector;
import com.ctc.wstx.stax.stream.StreamScanner;
import com.ctc.wstx.util.SingletonIterator;
import com.ctc.wstx.util.StringVector;
import com.ctc.wstx.util.TextBuilder;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;

public class NsInputElementStack
extends InputElementStack {
    static final String DEFAULT_NAMESPACE_URI = "";
    static final int IX_PREFIX = 0;
    static final int IX_LOCALNAME = 1;
    static final int IX_URI = 2;
    static final int IX_DEFAULT_NS = 3;
    static final int ENTRY_SIZE = 4;
    protected final String mPrefixXml;
    protected final String mPrefixXmlns;
    protected final NsAttributeCollector mAttrCollector;
    protected final StringVector mNamespaces = new StringVector(64);
    protected String[] mElements;
    protected int mSize;
    protected int[] mNsCounts;

    public NsInputElementStack(int initialSize, String prefixXml, String prefixXmlns) {
        this.mPrefixXml = prefixXml;
        this.mPrefixXmlns = prefixXmlns;
        this.mSize = 0;
        if (initialSize < 4) {
            initialSize = 4;
        }
        this.mElements = new String[initialSize << 2];
        this.mNsCounts = new int[initialSize];
        this.mAttrCollector = new NsAttributeCollector(prefixXml, prefixXmlns);
    }

    public final void push(String prefix, String localName) {
        Object[] old;
        int index = this.mSize;
        if (index == this.mElements.length) {
            old = this.mElements;
            this.mElements = new String[old.length + 64];
            System.arraycopy(old, 0, this.mElements, 0, old.length);
        }
        this.mElements[index] = prefix;
        this.mElements[index + 1] = localName;
        if (index == 0) {
            this.mElements[3] = DEFAULT_NAMESPACE_URI;
        } else {
            this.mElements[index + 3] = this.mElements[index - 1];
        }
        this.mSize = index + 4;
        if ((index >>= 2) == this.mNsCounts.length) {
            old = this.mNsCounts;
            this.mNsCounts = new int[old.length + 16];
            System.arraycopy(old, 0, this.mNsCounts, 0, old.length);
        }
        this.mNsCounts[index] = this.mNamespaces.size();
        this.mAttrCollector.reset();
    }

    public final void push(String fullName) {
        throw new Error("Internal error: push(fullName) shouldn't be called for namespace aware element stack.");
    }

    public int pop() {
        int index = this.mSize;
        if (index == 0) {
            throw new IllegalStateException("Popping from empty stack.");
        }
        this.mSize = index -= 4;
        this.mElements[index] = null;
        this.mElements[index + 1] = null;
        this.mElements[index + 2] = null;
        this.mElements[index + 3] = null;
        int nsCount = this.mNamespaces.size() - this.mNsCounts[index >>= 2];
        if (nsCount > 0) {
            this.mNamespaces.removeLast(nsCount);
        }
        return 3;
    }

    public int resolveElem(StreamScanner sc, boolean internNsURIs) throws XMLStreamException {
        String prefix;
        if (this.mSize == 0) {
            throw new IllegalStateException("Calling validate() on empty stack.");
        }
        NsAttributeCollector ac = this.mAttrCollector;
        int nsCount = ac.getNsCount();
        if (nsCount > 0) {
            String[] nsPrefixes = ac.getNsPrefixes();
            TextBuilder nsURIs = ac.getNsURIs();
            for (int i = 0; i < nsCount; ++i) {
                String prefix2;
                String nsUri = nsURIs.getEntry(i);
                if (internNsURIs && nsUri.length() > 0) {
                    nsUri = nsUri.intern();
                }
                if ((prefix2 = nsPrefixes[i]) == null) {
                    this.mElements[this.mSize - 1] = nsUri;
                } else if (prefix2 == this.mPrefixXml) {
                    if (!nsUri.equals("http://www.w3.org/XML/1998/namespace")) {
                        sc.throwParseError("Trying to redeclare prefix '" + prefix2 + "' from its default URI '" + "http://www.w3.org/XML/1998/namespace" + "' to '" + nsUri + ".");
                    }
                } else if (prefix2 == this.mPrefixXmlns && !nsUri.equals("http://www.w3.org/2000/xmlns/")) {
                    sc.throwParseError("Trying to redeclare prefix '" + prefix2 + "' from its default URI '" + "http://www.w3.org/2000/xmlns/" + "' to '" + nsUri + ".");
                }
                this.mNamespaces.addStrings(prefix2, nsUri);
            }
        }
        if ((prefix = this.mElements[this.mSize - 4]) == null || prefix.length() == 0) {
            this.mElements[this.mSize - 2] = this.mElements[this.mSize - 1];
        } else {
            String ns = this.mNamespaces.findLastFromMap(prefix);
            if (ns == null) {
                sc.throwParseError("Undeclared namespace prefix '" + prefix + "'.");
            }
            this.mElements[this.mSize - 2] = ns;
        }
        ac.resolveNamespaces(sc, this.mNamespaces);
        return 3;
    }

    public final int getDepth() {
        return this.mSize >> 2;
    }

    public final AttributeCollector getAttrCollector() {
        return this.mAttrCollector;
    }

    public final BaseNsContext createNonTransientNsContext(Location loc) {
        int localCount = this.getCurrentNsCount() << 1;
        return new CompactNsContext(loc, this.getDefaultNsURI(), this.mNamespaces.asArray(), this.mNamespaces.size() - localCount);
    }

    public final String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Illegal to pass null as argument.");
        }
        if (prefix.length() == 0) {
            if (this.mSize == 0) {
                return null;
            }
            return this.mElements[this.mSize - 1];
        }
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (prefix.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        return this.mNamespaces.findLastNonInterned(prefix);
    }

    public final String getPrefix(String nsURI) {
        if (nsURI == null || nsURI.length() == 0) {
            throw new IllegalArgumentException("Illegal to pass null/empty prefix as argument.");
        }
        if (nsURI.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (nsURI.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        return this.mNamespaces.findLastByValueNonInterned(nsURI);
    }

    public final Iterator getPrefixes(String nsURI) {
        if (nsURI == null || nsURI.length() == 0) {
            throw new IllegalArgumentException("Illegal to pass null/empty prefix as argument.");
        }
        if (nsURI.equals("http://www.w3.org/XML/1998/namespace")) {
            return new SingletonIterator("xml");
        }
        if (nsURI.equals("http://www.w3.org/2000/xmlns/")) {
            return new SingletonIterator("xmlns");
        }
        return this.mNamespaces.findAllByValueNonInterned(nsURI);
    }

    public final boolean isEmpty() {
        return this.mSize == 0;
    }

    public final String getDefaultNsURI() {
        if (this.mSize == 0) {
            throw new IllegalStateException("Illegal access, empty stack.");
        }
        return this.mElements[this.mSize - 1];
    }

    public final String getNsURI() {
        if (this.mSize == 0) {
            throw new IllegalStateException("Illegal access, empty stack.");
        }
        return this.mElements[this.mSize - 2];
    }

    public final String getPrefix() {
        if (this.mSize == 0) {
            throw new IllegalStateException("Illegal access, empty stack.");
        }
        return this.mElements[this.mSize - 4];
    }

    public final String getLocalName() {
        if (this.mSize == 0) {
            throw new IllegalStateException("Illegal access, empty stack.");
        }
        return this.mElements[this.mSize - 3];
    }

    public final QName getQName() {
        if (this.mSize == 0) {
            throw new IllegalStateException("Illegal access, empty stack.");
        }
        String prefix = this.mElements[this.mSize - 4];
        if (prefix == null) {
            prefix = DEFAULT_NAMESPACE_URI;
        }
        return new QName(this.mElements[this.mSize - 2], this.mElements[this.mSize - 3], prefix);
    }

    public final boolean matches(String prefix, String localName) {
        if (this.mSize == 0) {
            throw new IllegalStateException("Illegal access, empty stack.");
        }
        String thisPrefix = this.mElements[this.mSize - 4];
        if (prefix == null || prefix.length() == 0 ? thisPrefix != null && thisPrefix.length() > 0 : thisPrefix != prefix && !thisPrefix.equals(prefix)) {
            return false;
        }
        String thisName = this.mElements[this.mSize - 3];
        return thisName == localName || thisName.equals(localName);
    }

    public final String getTopElementDesc() {
        if (this.mSize == 0) {
            throw new IllegalStateException("Illegal access, empty stack.");
        }
        String name = this.mElements[this.mSize - 3];
        String prefix = this.mElements[this.mSize - 4];
        if (prefix == null || prefix.length() == 0) {
            return name;
        }
        return prefix + ":" + name;
    }

    public final int getTotalNsCount() {
        return this.mNamespaces.size() >> 1;
    }

    public final int getCurrentNsCount() {
        return this.mNamespaces.size() - this.mNsCounts[this.mSize - 1 >> 2] >> 1;
    }

    public final String getLocalNsPrefix(int index) {
        int offset = this.mNsCounts[this.mSize - 1 >> 2];
        int localCount = this.mNamespaces.size() - offset;
        if ((index <<= 1) < 0 || index >= localCount) {
            throw new IllegalArgumentException("Illegal namespace index " + (index >> 1) + "; current scope only has " + (localCount >> 1) + " namespace declarations.");
        }
        return this.mNamespaces.getString(offset + index);
    }

    public final String getLocalNsURI(int index) {
        int offset = this.mNsCounts[this.mSize - 1 >> 2];
        int localCount = this.mNamespaces.size() - offset;
        if ((index <<= 1) < 0 || index >= localCount) {
            throw new IllegalArgumentException("Illegal namespace index " + (index >> 1) + "; current scope only has " + (localCount >> 1) + " namespace declarations.");
        }
        return this.mNamespaces.getString(offset + index + 1);
    }
}

