/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.util;

import com.ctc.wstx.util.EmptyIterator;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;

public final class TextBuffer {
    static final int DEF_INITIAL_BUFFER_SIZE = 4000;
    private char[] mInputBuffer;
    private int mInputStart;
    private int mInputLen;
    private final int mInitialBufSize;
    private ArrayList mSegments;
    private int mSegmentSize;
    private char[] mCurrentSegment;
    private int mCurrentSize;
    private String mResultString;
    private char[] mResultArray;

    public TextBuffer() {
        this(4000);
    }

    public TextBuffer(int initialSize) {
        this.mInitialBufSize = initialSize;
    }

    public void clear() {
        this.mResultString = null;
        this.mResultArray = null;
        this.mInputBuffer = null;
        this.mInputStart = -1;
        this.mInputLen = 0;
        this.mSegments = null;
        this.mSegmentSize = 0;
        this.mCurrentSegment = null;
        this.mCurrentSize = 0;
    }

    public void resetWithEmpty() {
        this.mInputBuffer = null;
        this.mInputStart = -1;
        this.mInputLen = 0;
        this.mResultString = null;
        this.mResultArray = null;
        if (this.mSegments != null && this.mSegments.size() > 0) {
            this.mCurrentSegment = (char[])this.mSegments.get(this.mSegments.size() - 1);
            this.mSegments.clear();
            this.mSegmentSize = 0;
        }
        this.mCurrentSize = 0;
    }

    public void resetWithShared(char[] buf, int start, int len) {
        this.mInputBuffer = buf;
        this.mInputStart = start;
        this.mInputLen = len;
        this.mResultString = null;
        this.mResultArray = null;
        if (this.mSegments != null && this.mSegments.size() > 0) {
            this.mCurrentSegment = (char[])this.mSegments.get(this.mSegments.size() - 1);
            this.mSegments.clear();
            this.mSegmentSize = 0;
            this.mCurrentSize = 0;
        }
    }

    public void resetWithCopy(char[] buf, int start, int len) {
        this.mInputBuffer = null;
        this.mInputStart = -1;
        this.mInputLen = 0;
        this.mResultString = null;
        this.mResultArray = null;
        if (this.mSegments != null && this.mSegments.size() > 0) {
            this.mCurrentSegment = (char[])this.mSegments.get(this.mSegments.size() - 1);
            this.mSegments.clear();
        } else if (this.mCurrentSegment == null) {
            this.mCurrentSegment = new char[this.mInitialBufSize];
        }
        this.mSegmentSize = 0;
        this.mCurrentSize = 0;
        this.append(buf, start, len);
    }

    public void resetInitialized() {
        this.resetWithEmpty();
        if (this.mCurrentSegment == null) {
            this.mCurrentSegment = new char[this.mInitialBufSize];
        }
    }

    public int size() {
        if (this.mInputStart >= 0) {
            return this.mInputLen;
        }
        return this.mSegmentSize + this.mCurrentSize;
    }

    public int getTextStart() {
        return this.mInputStart >= 0 ? this.mInputStart : 0;
    }

    public char[] getTextBuffer() {
        if (this.mInputStart >= 0) {
            return this.mInputBuffer;
        }
        if (this.mSegments == null || this.mSegments.size() == 0) {
            return this.mCurrentSegment;
        }
        return this.contentsAsArray();
    }

    public String contentsAsString() {
        if (this.mResultString == null) {
            if (this.mResultArray != null) {
                this.mResultString = new String(this.mResultArray);
            } else if (this.mInputStart >= 0) {
                if (this.mInputLen < 1) {
                    this.mResultString = "";
                    return "";
                }
                this.mResultString = new String(this.mInputBuffer, this.mInputStart, this.mInputLen);
            } else {
                int size = this.size();
                if (size < 1) {
                    this.mResultString = "";
                    return "";
                }
                StringBuffer sb = new StringBuffer(size);
                if (this.mSegments != null) {
                    int len = this.mSegments.size();
                    for (int i = 0; i < len; ++i) {
                        char[] curr = (char[])this.mSegments.get(i);
                        sb.append(curr, 0, curr.length);
                    }
                }
                sb.append(this.mCurrentSegment, 0, this.mCurrentSize);
                this.mResultString = sb.toString();
            }
        }
        return this.mResultString;
    }

    public char[] contentsAsArray() {
        char[] result = this.mResultArray;
        if (result == null) {
            this.mResultArray = result = this.buildResultArray();
        }
        return result;
    }

    public int contentsToArray(int srcStart, char[] dst, int dstStart, int len) {
        if (this.mInputStart >= 0) {
            int amount = this.mInputLen - srcStart;
            if (amount > len) {
                amount = len;
            } else if (amount < 0) {
                amount = 0;
            }
            if (amount > 0) {
                System.arraycopy(this.mInputBuffer, this.mInputStart + srcStart, dst, dstStart, amount);
            }
            return amount;
        }
        int totalAmount = 0;
        if (this.mSegments != null) {
            int segc = this.mSegments.size();
            for (int i = 0; i < segc; ++i) {
                char[] segment = (char[])this.mSegments.get(i);
                int segLen = segment.length;
                int amount = segLen - srcStart;
                if (amount < 1) {
                    srcStart -= segLen;
                    continue;
                }
                if (amount >= len) {
                    System.arraycopy(segment, srcStart, dst, dstStart, len);
                    return totalAmount + len;
                }
                System.arraycopy(segment, srcStart, dst, dstStart, amount);
                totalAmount += amount;
                dstStart += amount;
                len -= amount;
                srcStart = 0;
            }
        }
        if (len > 0) {
            int amount = this.mSegmentSize - srcStart;
            if (len > amount) {
                len = amount;
            }
            if (amount > 0) {
                System.arraycopy(this.mCurrentSegment, srcStart, dst, dstStart, amount);
                totalAmount += amount;
            }
        }
        return totalAmount;
    }

    public void rawContentsTo(Writer w) throws IOException {
        if (this.mResultArray != null) {
            w.write(this.mResultArray);
            return;
        }
        if (this.mResultString != null) {
            w.write(this.mResultString);
            return;
        }
        if (this.mInputStart >= 0) {
            if (this.mInputLen > 0) {
                w.write(this.mInputBuffer, this.mInputStart, this.mInputLen);
            }
            return;
        }
        if (this.mSegments != null) {
            int len = this.mSegments.size();
            for (int i = 0; i < len; ++i) {
                w.write((char[])this.mSegments.get(i));
            }
        }
        if (this.mCurrentSize > 0) {
            w.write(this.mCurrentSegment, 0, this.mCurrentSize);
        }
    }

    public boolean isAllWhitespace() {
        if (this.mInputStart >= 0) {
            int i;
            char[] buf = this.mInputBuffer;
            int last = i + this.mInputLen;
            for (i = this.mInputStart; i < last; ++i) {
                if (buf[i] <= ' ') continue;
                return false;
            }
            return true;
        }
        if (this.mSegments != null) {
            int len = this.mSegments.size();
            for (int i = 0; i < len; ++i) {
                char[] buf = (char[])this.mSegments.get(i);
                int len2 = buf.length;
                for (int j = 0; j < len2; ++j) {
                    if (buf[j] <= ' ') continue;
                    return false;
                }
            }
        }
        char[] buf = this.mCurrentSegment;
        int len = this.mCurrentSize;
        for (int i = 0; i < len; ++i) {
            if (buf[i] <= ' ') continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(String str) {
        if (this.mInputStart >= 0) {
            this.unshare(16);
        }
        int segIndex = this.mSegments == null ? 0 : this.mSegments.size();
        int inIndex = str.length() - 1;
        char[] buf = this.mCurrentSegment;
        int bufIndex = this.mCurrentSize - 1;
        while (inIndex >= 0) {
            if (str.charAt(inIndex) != buf[bufIndex]) {
                return false;
            }
            if (--inIndex == 0) break;
            if (--bufIndex >= 0) continue;
            if (--segIndex < 0) {
                return false;
            }
            buf = (char[])this.mSegments.get(segIndex);
            bufIndex = buf.length - 1;
        }
        return true;
    }

    public void ensureNotShared() {
        if (this.mInputStart >= 0) {
            this.unshare(16);
        }
    }

    public void append(char c) {
        if (this.mInputStart >= 0) {
            this.unshare(16);
        }
        this.mResultString = null;
        this.mResultArray = null;
        char[] curr = this.mCurrentSegment;
        if (this.mCurrentSize >= curr.length) {
            this.expand(1);
        }
        curr[this.mCurrentSize++] = c;
    }

    public void append(char[] c, int start, int len) {
        if (this.mInputStart >= 0) {
            this.unshare(len);
        }
        this.mResultString = null;
        this.mResultArray = null;
        char[] curr = this.mCurrentSegment;
        int max = curr.length - this.mCurrentSize;
        if (max >= len) {
            System.arraycopy(c, start, curr, this.mCurrentSize, len);
            this.mCurrentSize += len;
        } else {
            if (max > 0) {
                System.arraycopy(c, start, curr, this.mCurrentSize, max);
                start += max;
                len -= max;
            }
            this.expand(len);
            System.arraycopy(c, start, this.mCurrentSegment, 0, len);
            this.mCurrentSize = len;
        }
    }

    public void append(String str) {
        int len = str.length();
        if (this.mInputStart >= 0) {
            this.unshare(len);
        }
        this.mResultString = null;
        this.mResultArray = null;
        char[] curr = this.mCurrentSegment;
        int max = curr.length - this.mCurrentSize;
        if (max >= len) {
            str.getChars(0, len, curr, this.mCurrentSize);
            this.mCurrentSize += len;
        } else {
            if (max > 0) {
                str.getChars(0, max, curr, this.mCurrentSize);
                len -= max;
            }
            this.expand(len);
            str.getChars(max, len, this.mCurrentSegment, 0);
            this.mCurrentSize = len;
        }
    }

    public char[] getCurrentSegment() {
        if (this.mInputStart >= 0) {
            this.unshare(1);
        } else if (this.mCurrentSize >= this.mCurrentSegment.length) {
            this.expand(1);
        }
        return this.mCurrentSegment;
    }

    public int getCurrentSegmentSize() {
        return this.mCurrentSize;
    }

    public void setCurrentLength(int len) {
        this.mCurrentSize = len;
    }

    public char[] finishCurrentSegment() {
        if (this.mSegments == null) {
            this.mSegments = new ArrayList();
        }
        this.mSegments.add(this.mCurrentSegment);
        int oldLen = this.mCurrentSegment.length;
        this.mSegmentSize += oldLen;
        char[] curr = new char[oldLen + (oldLen >> 1)];
        this.mCurrentSize = 0;
        this.mCurrentSegment = curr;
        return curr;
    }

    public String toString() {
        return this.contentsAsString();
    }

    public void unshare(int needExtra) {
        int len = this.mInputLen;
        this.mInputLen = 0;
        char[] inputBuf = this.mInputBuffer;
        this.mInputBuffer = null;
        int start = this.mInputStart;
        this.mInputStart = -1;
        int needed = len + needExtra;
        if (this.mCurrentSegment == null || needed > this.mCurrentSegment.length) {
            this.mCurrentSegment = needed > this.mInitialBufSize ? new char[needed] : new char[this.mInitialBufSize];
        }
        if (len > 0) {
            System.arraycopy(inputBuf, start, this.mCurrentSegment, 0, len);
        }
        this.mSegmentSize = 0;
        this.mCurrentSize = len;
    }

    private void expand(int minNewSegmentSize) {
        if (this.mSegments == null) {
            this.mSegments = new ArrayList();
        }
        char[] curr = this.mCurrentSegment;
        this.mSegments.add(curr);
        this.mSegmentSize += curr.length;
        int oldLen = curr.length;
        int sizeAddition = oldLen >> 1;
        if (sizeAddition < minNewSegmentSize) {
            sizeAddition = minNewSegmentSize;
        }
        curr = new char[oldLen + sizeAddition];
        this.mCurrentSize = 0;
        this.mCurrentSegment = curr;
    }

    private char[] buildResultArray() {
        char[] result;
        if (this.mResultString != null) {
            return this.mResultString.toCharArray();
        }
        if (this.mInputStart >= 0) {
            if (this.mInputLen < 1) {
                return EmptyIterator.getEmptyCharArray();
            }
            result = new char[this.mInputLen];
            System.arraycopy(this.mInputBuffer, this.mInputStart, result, 0, this.mInputLen);
        } else {
            int size = this.size();
            if (size < 1) {
                return EmptyIterator.getEmptyCharArray();
            }
            int offset = 0;
            result = new char[size];
            if (this.mSegments != null) {
                int len = this.mSegments.size();
                for (int i = 0; i < len; ++i) {
                    char[] curr = (char[])this.mSegments.get(i);
                    int currLen = curr.length;
                    System.arraycopy(curr, 0, result, offset, currLen);
                    offset += currLen;
                }
            }
            System.arraycopy(this.mCurrentSegment, 0, result, offset, this.mCurrentSize);
        }
        return result;
    }
}

