/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dtd;

import com.ctc.wstx.dtd.ElementValidator;
import com.ctc.wstx.dtd.NameKey;
import com.ctc.wstx.ent.EntityDecl;
import com.ctc.wstx.exc.WstxException;
import com.ctc.wstx.sr.AttributeCollector;
import com.ctc.wstx.sr.InputProblemReporter;
import com.ctc.wstx.sr.StreamScanner;
import com.ctc.wstx.util.SymbolTable;
import java.util.Map;

public class DTDAttribute {
    public static final int TYPE_CDATA = 0;
    public static final int TYPE_ENUMERATED = 1;
    public static final int TYPE_ID = 2;
    public static final int TYPE_IDREF = 3;
    public static final int TYPE_IDREFS = 4;
    public static final int TYPE_ENTITY = 5;
    public static final int TYPE_ENTITIES = 6;
    public static final int TYPE_NOTATION = 7;
    public static final int TYPE_NMTOKEN = 8;
    public static final int TYPE_NMTOKENS = 9;
    public static final int DEF_DEFAULT = 1;
    public static final int DEF_IMPLIED = 2;
    public static final int DEF_REQUIRED = 3;
    public static final int DEF_FIXED = 4;
    static final String[] sTypes = new String[]{"CDATA", "ENUMERATED", "ID", "IDREF", "IDREFS", "ENTITY", "ENTITIES", "NOTATION", "NMTOKEN", "NMTOKENS"};
    protected final NameKey mName;
    protected final int mSpecialIndex;
    protected final int mDefValueType;
    protected String mDefValue;

    public DTDAttribute(NameKey name, int defValueType, String defValue, int specIndex) {
        this.mName = name;
        this.mDefValueType = defValueType;
        this.mDefValue = defValue;
        this.mSpecialIndex = specIndex;
    }

    public DTDAttribute cloneWith(int specIndex) {
        return new DTDAttribute(this.mName, this.mDefValueType, this.mDefValue, specIndex);
    }

    public final NameKey getName() {
        return this.mName;
    }

    public final String toString() {
        return this.mName.toString();
    }

    public final int getDefaultType() {
        return this.mDefValueType;
    }

    public final String getDefaultValue() {
        return this.mDefValue;
    }

    public final boolean isSpecial() {
        return DTDAttribute.isSpecial(this.mDefValueType);
    }

    public static boolean isSpecial(int defValueType) {
        return defValueType == 1 || defValueType == 3;
    }

    public final boolean isRequired() {
        return this.mDefValueType == 3;
    }

    public final boolean isFixed() {
        return this.mDefValueType == 4;
    }

    public final int getSpecialIndex() {
        return this.mSpecialIndex;
    }

    public final boolean needsValidation() {
        return this.getValueType() != 0;
    }

    public int getValueType() {
        return 0;
    }

    public String getValueTypeString() {
        return sTypes[this.getValueType()];
    }

    public boolean typeIsId() {
        return false;
    }

    public boolean typeIsNotation() {
        return false;
    }

    public void validate(ElementValidator v, boolean normalize, AttributeCollector ac, int index) throws WstxException {
    }

    public void validateDefault(InputProblemReporter rep, boolean normalize) throws WstxException {
    }

    protected String validateDefaultName(InputProblemReporter rep, boolean normalize) throws WstxException {
        char c;
        String defValue = this.mDefValue.trim();
        if (defValue.length() == 0) {
            this.reportParseError(rep, "Invalid default value '" + defValue + "'; empty String is not a valid name");
        }
        if (!StreamScanner.isNameChar(c = defValue.charAt(0)) && c != ':') {
            this.reportParseError(rep, "Invalid default value '" + defValue + "'; character " + StreamScanner.getCharDesc(c) + ") not valid first character of a name");
        }
        int len = defValue.length();
        for (int i = 1; i < len; ++i) {
            if (StreamScanner.isNameChar(defValue.charAt(i))) continue;
            this.reportParseError(rep, "Invalid default value '" + defValue + "'; character #" + i + " (" + StreamScanner.getCharDesc(defValue.charAt(i)) + ") not valid name character");
        }
        return normalize ? defValue : this.mDefValue;
    }

    protected String validateDefaultNames(InputProblemReporter rep, boolean normalize) throws WstxException {
        String defValue = this.mDefValue;
        int len = defValue.length();
        StringBuffer sb = null;
        int count = 0;
        int start = 0;
        block0: while (start < len) {
            int i;
            char c = defValue.charAt(start);
            while (StreamScanner.isSpaceChar(c)) {
                if (++start >= len) break block0;
                c = defValue.charAt(start);
            }
            if (!StreamScanner.isNameStartChar(c) && c != ':') {
                this.reportParseError(rep, "Invalid default value '" + defValue + "'; character " + StreamScanner.getCharDesc(c) + ") not valid first character of a name token");
            }
            for (i = start + 1; i < len && !StreamScanner.isSpaceChar(c = defValue.charAt(i)); ++i) {
                if (StreamScanner.isNameChar(c)) continue;
                this.reportParseError(rep, "Invalid default value '" + defValue + "'; character " + StreamScanner.getCharDesc(c) + ") not a valid name character");
            }
            ++count;
            if (normalize) {
                if (sb == null) {
                    sb = new StringBuffer(i - start + 32);
                } else {
                    sb.append(' ');
                }
                sb.append(defValue.substring(start, i));
            }
            start = i + 1;
        }
        if (count == 0) {
            this.reportParseError(rep, "Invalid default value '" + defValue + "'; empty String is not a valid name value");
        }
        return normalize ? sb.toString() : this.mDefValue;
    }

    protected String validateDefaultNmToken(InputProblemReporter rep, boolean normalize) throws WstxException {
        String defValue = this.mDefValue.trim();
        if (defValue.length() == 0) {
            this.reportParseError(rep, "Invalid default value '" + defValue + "'; empty String is not a valid NMTOKEN");
        }
        int len = defValue.length();
        for (int i = 0; i < len; ++i) {
            if (StreamScanner.isNameChar(defValue.charAt(i))) continue;
            this.reportParseError(rep, "Invalid default value '" + defValue + "'; character #" + i + " (" + StreamScanner.getCharDesc(defValue.charAt(i)) + ") not valid NMTOKEN character");
        }
        return normalize ? defValue : this.mDefValue;
    }

    protected EntityDecl findEntityDecl(ElementValidator v, char[] ch, int start, int len, int hash) throws WstxException {
        EntityDecl ent;
        SymbolTable st = v.getSymbolTable();
        Map entMap = v.getEntityMap();
        String id = st.findSymbolIfExists(ch, start, len, hash);
        if (id != null) {
            ent = (EntityDecl)entMap.get(id);
        } else {
            id = new String(ch, start, len);
            ent = (EntityDecl)entMap.get(id);
            if (ent != null) {
                id = st.findSymbol(id);
            }
        }
        if (ent == null) {
            this.reportParseError(v, "Referenced entity '" + id + "' not defined");
        }
        if (ent.isParsed()) {
            this.reportParseError(v, "Referenced entity '" + id + "' is not an unparsed entity");
        }
        return ent;
    }

    protected void checkEntity(InputProblemReporter rep, String id, EntityDecl ent) throws WstxException {
        if (ent == null) {
            rep.throwParseError("Referenced entity '" + id + "' not defined");
        }
        if (ent.isParsed()) {
            rep.throwParseError("Referenced entity '" + id + "' is not an unparsed entity");
        }
    }

    protected void reportInvalidChar(ElementValidator v, char c, String msg) throws WstxException {
        this.reportParseError(v, "Invalid character " + StreamScanner.getCharDesc(c) + ": " + msg);
    }

    protected void reportParseError(ElementValidator v, String msg) throws WstxException {
        v.throwParseError("Attribute '" + this.mName + "': " + msg);
    }

    protected void reportParseError(InputProblemReporter rep, String msg) throws WstxException {
        rep.throwParseError("Attribute '" + this.mName + "': " + msg);
    }
}

