/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dtd;

import com.ctc.wstx.cfg.ErrorConsts;
import com.ctc.wstx.dtd.DTDAttribute;
import com.ctc.wstx.dtd.ElementId;
import com.ctc.wstx.dtd.ElementIdMap;
import com.ctc.wstx.dtd.ElementValidator;
import com.ctc.wstx.dtd.NameKey;
import com.ctc.wstx.exc.WstxException;
import com.ctc.wstx.sr.AttributeCollector;
import com.ctc.wstx.sr.InputProblemReporter;
import com.ctc.wstx.sr.StreamScanner;
import com.ctc.wstx.util.TextBuilder;
import javax.xml.stream.Location;

public final class DTDIdAttr
extends DTDAttribute {
    public DTDIdAttr(NameKey name, int defValueType, int specIndex) {
        super(name, defValueType, null, specIndex);
    }

    public DTDAttribute cloneWith(int specIndex) {
        return new DTDIdAttr(this.mName, this.mDefValueType, specIndex);
    }

    public int getValueType() {
        return 2;
    }

    public boolean typeIsId() {
        return true;
    }

    public void validate(ElementValidator v, boolean normalize, AttributeCollector ac, int index) throws WstxException {
        int start;
        TextBuilder tb = ac.getAttrBuilder();
        char[] ch = tb.getCharBuffer();
        int last = tb.getOffset(index + 1) - 1;
        for (start = tb.getOffset(index); start <= last && StreamScanner.isSpaceChar(ch[start]); ++start) {
        }
        if (start > last) {
            this.reportParseError(v, "Empty ID value");
        }
        while (last > start && StreamScanner.isSpaceChar(ch[last])) {
            --last;
        }
        int c = ch[start];
        if (!StreamScanner.isNameStartChar((char)c) && c != 58) {
            this.reportInvalidChar(v, (char)c, "not valid as the first ID character");
        }
        int hash = c;
        for (int i = start + 1; i <= last; ++i) {
            c = ch[i];
            if (!StreamScanner.isNameChar((char)c)) {
                this.reportInvalidChar(v, (char)c, "not valid as an ID character");
            }
            hash = hash * 31 + c;
        }
        ElementIdMap m = v.getIdMap();
        NameKey elemName = v.getElemName();
        Location loc = v.getLocation();
        ElementId id = m.addDefined(ch, start, last - start + 1, hash, loc, elemName, this.mName);
        if (id.getLocation() != loc) {
            this.reportParseError(v, "Duplicate id '" + id.getId() + "', first declared at " + id.getLocation());
        }
        if (normalize) {
            ac.setNormalizedValue(index, id.getId());
        }
    }

    public void validateDefault(InputProblemReporter rep, boolean normalize) throws WstxException {
        throw new Error(ErrorConsts.ERR_INTERNAL);
    }
}

