/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dtd;

import com.ctc.wstx.dtd.DTDAttribute;
import com.ctc.wstx.dtd.ElementId;
import com.ctc.wstx.dtd.ElementIdMap;
import com.ctc.wstx.dtd.ElementValidator;
import com.ctc.wstx.dtd.NameKey;
import com.ctc.wstx.exc.WstxException;
import com.ctc.wstx.sr.AttributeCollector;
import com.ctc.wstx.sr.InputProblemReporter;
import com.ctc.wstx.sr.StreamScanner;
import com.ctc.wstx.util.TextBuilder;
import javax.xml.stream.Location;

public final class DTDIdRefAttr
extends DTDAttribute {
    public DTDIdRefAttr(NameKey name, int defValueType, String defValue, int specIndex) {
        super(name, defValueType, defValue, specIndex);
    }

    public DTDAttribute cloneWith(int specIndex) {
        return new DTDIdRefAttr(this.mName, this.mDefValueType, this.mDefValue, specIndex);
    }

    public int getValueType() {
        return 3;
    }

    public void validate(ElementValidator v, boolean normalize, AttributeCollector ac, int index) throws WstxException {
        int start;
        TextBuilder tb = ac.getAttrBuilder();
        char[] ch = tb.getCharBuffer();
        int last = tb.getOffset(index + 1) - 1;
        for (start = tb.getOffset(index); start <= last && StreamScanner.isSpaceChar(ch[start]); ++start) {
        }
        if (start > last) {
            this.reportParseError(v, "Empty IDREF value");
        }
        while (last > start && StreamScanner.isSpaceChar(ch[last])) {
            --last;
        }
        int c = ch[start];
        if (!StreamScanner.isNameStartChar((char)c) && c != 58) {
            this.reportInvalidChar(v, (char)c, "not valid as the first IDREF character");
        }
        int hash = c;
        for (int i = start + 1; i <= last; ++i) {
            c = ch[i];
            if (!StreamScanner.isNameChar((char)c)) {
                this.reportInvalidChar(v, (char)c, "not valid as an IDREF character");
            }
            hash = hash * 31 + c;
        }
        ElementIdMap m = v.getIdMap();
        Location loc = v.getLocation();
        ElementId id = m.addReferenced(ch, start, last - start + 1, hash, loc, v.getElemName(), this.mName);
        if (normalize) {
            ac.setNormalizedValue(index, id.getId());
        }
    }

    public void validateDefault(InputProblemReporter rep, boolean normalize) throws WstxException {
        this.mDefValue = this.validateDefaultName(rep, normalize);
    }
}

