/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dtd;

import com.ctc.wstx.dtd.DTDAttribute;
import com.ctc.wstx.dtd.ElementId;
import com.ctc.wstx.dtd.ElementIdMap;
import com.ctc.wstx.dtd.ElementValidator;
import com.ctc.wstx.dtd.NameKey;
import com.ctc.wstx.exc.WstxException;
import com.ctc.wstx.sr.AttributeCollector;
import com.ctc.wstx.sr.InputProblemReporter;
import com.ctc.wstx.sr.StreamScanner;
import com.ctc.wstx.util.TextBuilder;
import javax.xml.stream.Location;

public final class DTDIdRefsAttr
extends DTDAttribute {
    public DTDIdRefsAttr(NameKey name, int defValueType, String defValue, int specIndex) {
        super(name, defValueType, defValue, specIndex);
    }

    public DTDAttribute cloneWith(int specIndex) {
        return new DTDIdRefsAttr(this.mName, this.mDefValueType, this.mDefValue, specIndex);
    }

    public int getValueType() {
        return 4;
    }

    public void validate(ElementValidator v, boolean normalize, AttributeCollector ac, int index) throws WstxException {
        int start;
        TextBuilder tb = ac.getAttrBuilder();
        char[] ch = tb.getCharBuffer();
        int last = tb.getOffset(index + 1) - 1;
        for (start = tb.getOffset(index); start <= last && StreamScanner.isSpaceChar(ch[start]); ++start) {
        }
        if (start > last) {
            this.reportParseError(v, "Empty IDREFS value");
        }
        while (last > start && StreamScanner.isSpaceChar(ch[last])) {
            --last;
        }
        ElementIdMap m = v.getIdMap();
        Location loc = v.getLocation();
        String idStr = null;
        StringBuffer sb = null;
        while (start <= last) {
            int i;
            int c = ch[start];
            if (!StreamScanner.isNameStartChar((char)c) && c != 58) {
                this.reportInvalidChar(v, (char)c, "not valid as the first IDREFS character");
            }
            int hash = c;
            for (i = start + 1; i <= last && !StreamScanner.isSpaceChar((char)(c = ch[i])); ++i) {
                if (!StreamScanner.isNameChar((char)c)) {
                    this.reportInvalidChar(v, (char)c, "not valid as an IDREFS character");
                }
                hash = hash * 31 + c;
            }
            ElementId id = m.addReferenced(ch, start, i - start, hash, loc, v.getElemName(), this.mName);
            start = i + 1;
            if (normalize) {
                if (idStr == null) {
                    idStr = id.getId();
                } else {
                    if (sb == null) {
                        sb = new StringBuffer(idStr);
                    }
                    idStr = id.getId();
                    sb.append(' ');
                    sb.append(idStr);
                }
            }
            while (start <= last && StreamScanner.isSpaceChar(ch[start])) {
                ++start;
            }
        }
        if (normalize) {
            if (sb != null) {
                idStr = sb.toString();
            }
            ac.setNormalizedValue(index, idStr);
        }
    }

    public void validateDefault(InputProblemReporter rep, boolean normalize) throws WstxException {
        this.mDefValue = this.validateDefaultNames(rep, normalize);
    }
}

