/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dtd;

import com.ctc.wstx.api.ReaderConfig;
import com.ctc.wstx.cfg.ErrorConsts;
import com.ctc.wstx.compat.JdkFeatures;
import com.ctc.wstx.dtd.ChoiceContentSpec;
import com.ctc.wstx.dtd.ContentSpec;
import com.ctc.wstx.dtd.DFAState;
import com.ctc.wstx.dtd.DFAValidator;
import com.ctc.wstx.dtd.DTDAttribute;
import com.ctc.wstx.dtd.DTDElement;
import com.ctc.wstx.dtd.DTDSubset;
import com.ctc.wstx.dtd.DTDSubsetImpl;
import com.ctc.wstx.dtd.DTDWriter;
import com.ctc.wstx.dtd.EmptyValidator;
import com.ctc.wstx.dtd.MinimalDTDReader;
import com.ctc.wstx.dtd.NameKey;
import com.ctc.wstx.dtd.SeqContentSpec;
import com.ctc.wstx.dtd.StructValidator;
import com.ctc.wstx.dtd.TokenContentSpec;
import com.ctc.wstx.ent.EntityDecl;
import com.ctc.wstx.ent.IntEntity;
import com.ctc.wstx.ent.NotationDecl;
import com.ctc.wstx.ent.ParsedExtEntity;
import com.ctc.wstx.ent.UnparsedExtEntity;
import com.ctc.wstx.exc.WstxException;
import com.ctc.wstx.io.WstxInputLocation;
import com.ctc.wstx.io.WstxInputSource;
import com.ctc.wstx.sr.StreamScanner;
import com.ctc.wstx.util.InternCache;
import com.ctc.wstx.util.SymbolTable;
import com.ctc.wstx.util.TextBuffer;
import com.ctc.wstx.util.WordResolver;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.stream.Location;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamException;

public class FullDTDReader
extends MinimalDTDReader {
    static final boolean INTERN_SHARED_NAMES = false;
    static final int EXP_ENTITY_VALUE_LEN = 500;
    final int mConfigFlags;
    final XMLReporter mReporter;
    final boolean mCfgNormalizeLFs;
    final boolean mCfgNormAttrs;
    final boolean mCfgValidate;
    final boolean mCfgSupportDTDPP;
    HashMap mParamEntities;
    final HashMap mPredefdPEs;
    Set mRefdPEs;
    HashMap mGeneralEntities;
    final HashMap mPredefdGEs;
    Set mRefdGEs;
    boolean mUsesPredefdEntities = false;
    HashMap mNotations;
    final HashMap mPredefdNotations;
    boolean mUsesPredefdNotations = false;
    HashMap mSharedNames = null;
    HashMap mElements;
    HashMap mSharedEnumValues = null;
    int mIncludeCount = 0;
    boolean mAnyDTDppFeatures = false;
    String mDefaultNsURI = "";
    HashMap mNamespaces = null;
    DTDWriter mFlattenWriter = null;
    private int mTokenIndex = 1;
    final NameKey mAccessKey = new NameKey(null, null);

    private FullDTDReader(StreamScanner master, WstxInputSource input, ReaderConfig cfg) {
        this(input, cfg, master, false, null);
    }

    private FullDTDReader(StreamScanner master, WstxInputSource input, ReaderConfig cfg, DTDSubset intSubset) {
        this(input, cfg, master, true, intSubset);
        input.initInputLocation(this);
    }

    private FullDTDReader(WstxInputSource input, ReaderConfig cfg, StreamScanner master, boolean isExt, DTDSubset intSubset) {
        super(input, cfg, master, isExt);
        int cfgFlags;
        this.mReporter = cfg.getXMLReporter();
        this.mConfigFlags = cfgFlags = cfg.getConfigFlags();
        this.mCfgNormalizeLFs = (cfgFlags & 0x100) != 0;
        this.mCfgNormAttrs = (cfgFlags & 0x200) != 0;
        this.mCfgValidate = (cfgFlags & 0x20) != 0;
        this.mCfgSupportDTDPP = (cfgFlags & 0x20000) != 0;
        this.mUsesPredefdEntities = false;
        this.mParamEntities = null;
        this.mRefdPEs = null;
        this.mRefdGEs = null;
        this.mGeneralEntities = null;
        HashMap pes = intSubset == null ? null : intSubset.getParameterEntityMap();
        this.mPredefdPEs = pes == null || pes.isEmpty() ? null : pes;
        HashMap ges = intSubset == null ? null : intSubset.getGeneralEntityMap();
        this.mPredefdGEs = ges == null || ges.isEmpty() ? null : ges;
        HashMap not = intSubset == null ? null : intSubset.getNotationMap();
        this.mPredefdNotations = not == null || ges.isEmpty() ? null : not;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DTDSubset readInternalSubset(StreamScanner master, WstxInputSource input, ReaderConfig cfg) throws IOException, XMLStreamException {
        DTDSubset ss;
        FullDTDReader r = new FullDTDReader(master, input, cfg);
        r.copyBufferStateFrom(master);
        try {
            ss = r.parseDTD();
        }
        finally {
            master.copyBufferStateFrom(r);
        }
        return ss;
    }

    public static DTDSubset readExternalSubset(StreamScanner master, WstxInputSource src, ReaderConfig cfg, DTDSubset intSubset) throws IOException, XMLStreamException {
        FullDTDReader r = new FullDTDReader(master, src, cfg, intSubset);
        return r.parseDTD();
    }

    public static DTDSubset flattenExternalSubset(WstxInputSource src, Writer flattenWriter, boolean inclComments, boolean inclConditionals, boolean inclPEs) throws IOException, XMLStreamException {
        int configFlags = -1;
        ReaderConfig cfg = ReaderConfig.createFullDefaults(new SymbolTable(), null);
        cfg.clearConfigFlag(256);
        cfg.clearConfigFlag(512);
        FullDTDReader r = new FullDTDReader(null, src, cfg, null);
        r.setFlattenWriter(flattenWriter, inclComments, inclConditionals, inclPEs);
        DTDSubset ss = r.parseDTD();
        r.flushFlattenWriter();
        flattenWriter.flush();
        return ss;
    }

    public void setFlattenWriter(Writer w, boolean inclComments, boolean inclConditionals, boolean inclPEs) {
        this.mFlattenWriter = new DTDWriter(w, inclComments, inclConditionals, inclPEs);
    }

    private void flushFlattenWriter() throws IOException {
        this.mFlattenWriter.flush(this.mInputBuffer, this.mInputPtr);
    }

    public EntityDecl findEntity(String entName) {
        EntityDecl decl;
        if (this.mPredefdGEs != null && (decl = (EntityDecl)this.mPredefdGEs.get(entName)) != null) {
            return decl;
        }
        return (EntityDecl)this.mGeneralEntities.get(entName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DTDSubset parseDTD() throws IOException, XMLStreamException {
        DTDSubsetImpl ss;
        while (true) {
            int i;
            if ((i = this.getNextAfterWS()) < 0) {
                if (this.mIsExternal) break;
                this.throwUnexpectedEOF(" in internal DTD subset");
            }
            if (i == 37) {
                this.expandPE();
                continue;
            }
            this.mTokenInputTotal = this.mCurrInputProcessed + this.mInputPtr;
            this.mTokenInputRow = this.mCurrInputRow;
            this.mTokenInputCol = this.mInputPtr - this.mCurrInputRowStart;
            if (i == 60) {
                if (this.mFlattenWriter == null) {
                    this.parseDirective();
                    continue;
                }
                this.parseDirectiveFlattened();
                continue;
            }
            if (i == 93) {
                if (this.mIncludeCount > 0) {
                    boolean suppress;
                    boolean bl = suppress = this.mFlattenWriter != null && !this.mFlattenWriter.includeConditionals();
                    if (suppress) {
                        this.mFlattenWriter.flush(this.mInputBuffer, this.mInputPtr - 1);
                        this.mFlattenWriter.disableOutput();
                    }
                    try {
                        char c = this.getNextExpanded();
                        if (c != ']' || (c = this.getNextExpanded()) != '>') {
                            this.throwDTDUnexpectedChar(c, "; expected ']]>' to close conditional include section.");
                        }
                    }
                    finally {
                        if (suppress) {
                            this.mFlattenWriter.enableOutput(this.mInputPtr);
                        }
                    }
                    --this.mIncludeCount;
                    continue;
                }
                if (!this.mIsExternal) break;
            }
            if (this.mIsExternal) {
                this.throwDTDUnexpectedChar(i, " in external DTD subset; expected a '<' to start a directive.");
            }
            this.throwDTDUnexpectedChar(i, " in internal DTD subset; expected a '<' to start a directive, or \"]>\" to end internal subset.");
        }
        if (this.mIsExternal) {
            boolean cachable = !this.mUsesPredefdEntities && !this.mUsesPredefdNotations;
            ss = DTDSubsetImpl.constructInstance(cachable, this.mGeneralEntities, this.mRefdGEs, null, this.mRefdPEs, this.mNotations, this.mElements);
        } else {
            ss = DTDSubsetImpl.constructInstance(false, this.mGeneralEntities, null, this.mParamEntities, null, this.mNotations, this.mElements);
        }
        return ss;
    }

    protected void parseDirective() throws IOException, XMLStreamException {
        char c = this.getNextExpanded();
        if (c == '?') {
            this.skipPI();
            return;
        }
        if (c != '!') {
            this.throwDTDUnexpectedChar(c, this.getErrorMsg() + "; expected '!' to start a directive");
        }
        if ((c = this.getNextExpanded()) == '-') {
            c = this.getNextExpanded();
            if (c != '-') {
                this.throwDTDUnexpectedChar(c, this.getErrorMsg() + "; expected '-' for a comment.");
            }
            this.skipComment();
        } else if (c == '[') {
            this.checkInclusion();
        } else if (c >= 'A' && c <= 'Z') {
            this.handleDeclaration(c);
        } else {
            this.throwDTDUnexpectedChar(c, this.getErrorMsg() + ErrorConsts.ERR_DTD_MAINLEVEL_KEYWORD);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseDirectiveFlattened() throws IOException, XMLStreamException {
        this.mFlattenWriter.flush(this.mInputBuffer, this.mInputPtr - 1);
        this.mFlattenWriter.disableOutput();
        char c = this.getNextExpanded();
        if (c == '?') {
            this.mFlattenWriter.enableOutput(this.mInputPtr);
            this.mFlattenWriter.output("<?");
            this.skipPI();
            return;
        }
        if (c != '!') {
            this.throwDTDUnexpectedChar(c, this.getErrorMsg() + ErrorConsts.ERR_DTD_MAINLEVEL_KEYWORD);
        }
        if ((c = this.getNextExpanded()) == '-') {
            boolean comm;
            c = this.getNextExpanded();
            if (c != '-') {
                this.throwDTDUnexpectedChar(c, this.getErrorMsg() + "; expected '-' for a comment.");
            }
            if (comm = this.mFlattenWriter.includeComments()) {
                this.mFlattenWriter.enableOutput(this.mInputPtr);
                this.mFlattenWriter.output("<!--");
            }
            try {
                this.skipComment();
            }
            finally {
                if (!comm) {
                    this.mFlattenWriter.enableOutput(this.mInputPtr);
                }
            }
        } else if (c == '[') {
            boolean cond = this.mFlattenWriter.includeConditionals();
            if (cond) {
                this.mFlattenWriter.enableOutput(this.mInputPtr);
                this.mFlattenWriter.output("<![");
            }
            try {
                this.checkInclusion();
            }
            finally {
                if (!cond) {
                    this.mFlattenWriter.enableOutput(this.mInputPtr);
                }
            }
        } else {
            boolean filterPEs;
            boolean bl = filterPEs = c == 'E' && !this.mFlattenWriter.includeParamEntities();
            if (filterPEs) {
                this.handleSuppressedDeclaration();
            } else if (c >= 'A' && c <= 'Z') {
                this.mFlattenWriter.enableOutput(this.mInputPtr);
                this.mFlattenWriter.output("<!");
                this.mFlattenWriter.output(c);
                this.handleDeclaration(c);
            } else {
                this.throwDTDUnexpectedChar(c, this.getErrorMsg() + ErrorConsts.ERR_DTD_MAINLEVEL_KEYWORD);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initInputSource(WstxInputSource newInput, boolean isExt) throws IOException, XMLStreamException {
        if (this.mFlattenWriter != null) {
            this.mFlattenWriter.flush(this.mInputBuffer, this.mInputPtr);
            this.mFlattenWriter.disableOutput();
            try {
                super.initInputSource(newInput, isExt);
            }
            finally {
                this.mFlattenWriter.enableOutput(this.mInputPtr);
            }
        } else {
            super.initInputSource(newInput, isExt);
        }
    }

    protected boolean loadMore() throws IOException, WstxException {
        WstxInputSource input = this.mInput;
        if (this.mFlattenWriter != null) {
            this.mFlattenWriter.flush(this.mInputBuffer, this.mInputLen);
        }
        do {
            this.mCurrInputProcessed += this.mInputLen;
            this.mCurrInputRowStart -= this.mInputLen;
            int count = input.readInto(this);
            if (count > 0) {
                if (this.mFlattenWriter != null) {
                    this.mFlattenWriter.setFlattenStart(this.mInputPtr);
                }
                return true;
            }
            input.close();
            if (input == this.mRootInput) {
                return false;
            }
            WstxInputSource parent = input.getParent();
            if (parent == null) {
                throw new Error("Internal error: null parent for input source '" + input + "'; should never occur (should have stopped at root input '" + this.mRootInput + "'.");
            }
            this.mInput = input = parent;
            input.restoreContext(this);
            if (this.mFlattenWriter == null) continue;
            this.mFlattenWriter.setFlattenStart(this.mInputPtr);
        } while (this.mInputPtr >= this.mInputLen);
        return true;
    }

    protected boolean loadMoreFromCurrent() throws IOException, WstxException {
        if (this.mFlattenWriter != null) {
            this.mFlattenWriter.flush(this.mInputBuffer, this.mInputLen);
        }
        this.mCurrInputProcessed += this.mInputLen;
        this.mCurrInputRowStart -= this.mInputLen;
        int count = this.mInput.readInto(this);
        if (count > 0) {
            if (this.mFlattenWriter != null) {
                this.mFlattenWriter.setFlattenStart(this.mInputPtr);
            }
            return true;
        }
        return false;
    }

    protected boolean ensureInput(int minAmount) throws IOException {
        int currAmount = this.mInputLen - this.mInputPtr;
        if (currAmount >= minAmount) {
            return true;
        }
        if (this.mFlattenWriter != null) {
            this.mFlattenWriter.flush(this.mInputBuffer, this.mInputLen);
        }
        if (this.mInput.readMore(this, minAmount)) {
            if (this.mFlattenWriter != null) {
                this.mFlattenWriter.setFlattenStart(currAmount);
            }
            return true;
        }
        return false;
    }

    private char getNextExpanded() throws IOException, XMLStreamException {
        while (true) {
            char c;
            char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
            if (c != '%') {
                return c;
            }
            this.expandPE();
        }
    }

    private char getNextExpandedInDecl() throws IOException, XMLStreamException {
        while (true) {
            char c;
            char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
            if (c == '-') {
                char d;
                char c3 = d = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
                if (d == '-') {
                    this.skipCommentContent();
                    continue;
                }
                --this.mInputPtr;
                return c;
            }
            if (c != '%') {
                return c;
            }
            this.expandPE();
        }
    }

    private char skipDtdWs(boolean allowComments) throws IOException, XMLStreamException {
        while (true) {
            char c;
            char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
            if (c == '%') {
                this.expandPE();
                continue;
            }
            if (c > ' ') {
                if (c == '-' && allowComments) {
                    char c3 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
                    if (c == '-') {
                        this.skipCommentContent();
                        continue;
                    }
                    --this.mInputPtr;
                }
                return c;
            }
            if (c != '\n' && c != '\r') continue;
            this.skipCRLF(c);
        }
    }

    private char skipObligatoryDtdWs(boolean allowComments) throws IOException, XMLStreamException {
        char c = '\u0000';
        int count = 0;
        while (true) {
            char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
            if (c == '%') {
                this.expandPE();
                continue;
            }
            if (c > ' ') {
                if (c != '-' || !allowComments) break;
                char c3 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
                if (c == '-') {
                    this.skipCommentContent();
                    continue;
                }
                --this.mInputPtr;
                break;
            }
            ++count;
            if (c != '\n' && c != '\r') continue;
            this.skipCRLF(c);
        }
        if (count == 0) {
            this.throwDTDUnexpectedChar(c, this.getErrorMsg() + "; expected a separating white space.");
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandPE() throws IOException, XMLStreamException {
        char c;
        String id;
        if (this.mFlattenWriter != null) {
            this.mFlattenWriter.flush(this.mInputBuffer, this.mInputPtr - 1);
            this.mFlattenWriter.disableOutput();
            id = this.readDTDName();
            try {
                c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
            }
            finally {
                this.mFlattenWriter.enableOutput(this.mInputPtr);
            }
        } else {
            id = this.readDTDName();
            char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
        }
        if (c != ';') {
            this.throwDTDUnexpectedChar(c, this.getErrorMsg() + "; expected ';' to end parameter entity name.");
        }
        if (this.mIsExternal) {
            int setId = this.expandEntity(id, this.mPredefdPEs, this.mParamEntities, true);
            if (setId == 1) {
                this.mUsesPredefdEntities = true;
                this.mRefdPEs = null;
            } else if (!this.mUsesPredefdEntities) {
                HashSet<String> used = this.mRefdPEs;
                if (used == null) {
                    this.mRefdPEs = used = new HashSet<String>();
                }
                used.add(id);
            }
        } else {
            this.expandEntity(id, this.mParamEntities, null, true);
        }
    }

    protected String checkDTDKeyword(String exp) throws IOException, XMLStreamException {
        int i;
        int len = exp.length();
        char c = ' ';
        for (i = 0; i < len; ++i) {
            while ((c = (char)(this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg()))) == '%') {
                this.expandPE();
            }
            if (c != exp.charAt(i)) break;
        }
        if (i == len) {
            c = this.getNextExpanded();
            --this.mInputPtr;
            if (!FullDTDReader.isNameChar(c)) {
                return null;
            }
        }
        StringBuffer sb = new StringBuffer(exp.substring(0, i));
        sb.append(c);
        while (true) {
            if (!FullDTDReader.isNameChar(c = this.getNextExpanded()) && c != ':') {
                --this.mInputPtr;
                break;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected void checkDTDKeyword(String exp, char firstChar, String extraError) throws IOException, XMLStreamException {
        char c;
        int i;
        if (firstChar != exp.charAt(0) && !FullDTDReader.isNameStartChar(firstChar)) {
            this.throwDTDUnexpectedChar(firstChar, this.getErrorMsg() + extraError);
        }
        int len = exp.length();
        for (i = 1; i < len; ++i) {
            while (true) {
                char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
                if (c != '%') break;
                this.expandPE();
            }
            if (c != exp.charAt(i)) break;
        }
        if (i == len) {
            c = this.getNextExpanded();
            --this.mInputPtr;
            if (!FullDTDReader.isNameChar(c)) {
                return;
            }
        }
        StringBuffer sb = new StringBuffer(exp.substring(0, i));
        while (true) {
            char c3;
            if (!FullDTDReader.isNameChar(c3 = this.getNextExpanded()) && c3 != ':') {
                --this.mInputPtr;
                break;
            }
            sb.append(c3);
        }
        this.throwParseError(this.getErrorMsg() + extraError);
    }

    protected String readDTDKeyword(String prefix) throws IOException, XMLStreamException {
        char c;
        StringBuffer sb;
        boolean gotPrefix = prefix != null && prefix.length() > 0;
        StringBuffer stringBuffer = sb = gotPrefix ? new StringBuffer(prefix) : new StringBuffer();
        if (!gotPrefix) {
            c = this.getNextExpanded();
            if (!FullDTDReader.isNameStartChar(c)) {
                --this.mInputPtr;
                return "";
            }
            sb.append(c);
        }
        while (true) {
            if (!FullDTDReader.isNameChar(c = this.getNextExpanded()) && c != ':') {
                --this.mInputPtr;
                break;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private boolean checkPublicSystemKeyword(char c) throws IOException, XMLStreamException {
        String errId;
        if (c == 'P') {
            errId = this.checkDTDKeyword("UBLIC");
            if (errId == null) {
                return true;
            }
            errId = "P" + errId;
        } else if (c == 'S') {
            errId = this.checkDTDKeyword("YSTEM");
            if (errId == null) {
                return false;
            }
            errId = "S" + errId;
        } else {
            if (!FullDTDReader.isNameStartChar(c)) {
                this.throwDTDUnexpectedChar(c, "; expected 'PUBLIC' or 'SYSTEM' keyword.");
            }
            --this.mInputPtr;
            errId = this.readDTDKeyword(null);
        }
        this.throwParseError("Unrecognized keyword '" + errId + "'; expected 'PUBLIC' or 'SYSTEM'");
        return false;
    }

    private String readDTDName() throws IOException, WstxException {
        return this.readDTDName(this.getNextChar(this.getErrorMsg()));
    }

    private String readDTDName(char c) throws IOException, WstxException {
        if (!FullDTDReader.isNameStartChar(c)) {
            this.throwDTDUnexpectedChar(c, this.getErrorMsg() + "; expected an identifier");
        }
        return this.parseFullName(c);
    }

    private String readDTDLocalName(char c, boolean checkChar) throws IOException, WstxException {
        if (checkChar && !FullDTDReader.isNameStartChar(c)) {
            this.throwDTDUnexpectedChar(c, this.getErrorMsg() + "; expected an identifier");
        }
        return this.parseLocalName(c);
    }

    private String readDTDNmtoken(char c) throws IOException, WstxException {
        char[] outBuf = this.getNameBuffer(64);
        int outLen = outBuf.length;
        int outPtr = 0;
        while (true) {
            if (!FullDTDReader.isNameChar(c)) {
                if (outPtr == 0) {
                    this.throwDTDUnexpectedChar(c, this.getErrorMsg() + "; expected a NMTOKEN character to start a NMTOKEN");
                }
                --this.mInputPtr;
                break;
            }
            if (outPtr >= outLen) {
                outBuf = this.expandBy50Pct(outBuf);
                outLen = outBuf.length;
            }
            outBuf[outPtr++] = c;
            c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(" in name token");
        }
        return new String(outBuf, 0, outPtr);
    }

    private NameKey readDTDQName(char firstChar) throws IOException, XMLStreamException {
        String localName;
        String prefix;
        if (!this.mCfgNsEnabled) {
            prefix = null;
            localName = this.parseFullName(firstChar);
        } else {
            char c;
            localName = this.parseLocalName(firstChar);
            char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
            if (c == ':') {
                prefix = localName;
                c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
                localName = this.parseLocalName(c);
            } else {
                --this.mInputPtr;
                prefix = null;
            }
        }
        return this.findSharedName(prefix, localName);
    }

    private char readArity() throws IOException, XMLStreamException {
        char c;
        char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
        if (c == '?' || c == '*' || c == '+') {
            return c;
        }
        --this.mInputPtr;
        return ' ';
    }

    /*
     * Enabled aggressive block sorting
     */
    private TextBuffer parseEntityValue(String id, Location loc, char quoteChar) throws IOException, XMLStreamException {
        char c;
        WstxInputSource currScope = this.mInput;
        boolean allowPEs = this.mIsExternal || this.mInput != this.mRootInput;
        TextBuffer tb = new TextBuffer(500);
        tb.resetInitialized();
        char[] outBuf = tb.getCurrentSegment();
        int outPtr = tb.getCurrentSegmentSize();
        while (true) {
            block21: {
                if (this.mInputPtr >= this.mInputLen) {
                    boolean check = this.mInput == currScope;
                    this.loadMore(this.getErrorMsg());
                    if (check && this.mInput != currScope) {
                        this.throwParseError("Unterminated entity value for entity '" + id + "' (definition started at " + loc + ")");
                    }
                }
                if ((c = this.mInputBuffer[this.mInputPtr++]) < '?') {
                    if (c == quoteChar) {
                        if (this.mInput == currScope) {
                            tb.setCurrentLength(outPtr);
                            c = this.skipDtdWs(true);
                            if (c == '>') return tb;
                            break;
                        }
                    } else if (c == '&') {
                        char d = this.resolveCharOnlyEntity(false);
                        if (d != '\u0000') {
                            c = d;
                        }
                    } else {
                        if (c == '%') {
                            if (!allowPEs) {
                                this.throwParseError("Can not have parameter entities in entity value defined at the main level of internal subset (XML 1.1, #2.8).");
                            }
                            this.expandPE();
                            continue;
                        }
                        if (c == '\n') {
                            this.markLF();
                        } else if (c == '\r') {
                            if (this.skipCRLF(c)) {
                                if (this.mCfgNormalizeLFs) {
                                    c = '\n';
                                    break block21;
                                } else {
                                    outBuf[outPtr++] = c;
                                    if (outPtr >= outBuf.length) {
                                        outBuf = tb.finishCurrentSegment();
                                        outPtr = 0;
                                    }
                                    outBuf[outPtr++] = 10;
                                    if (outPtr < outBuf.length) continue;
                                    outBuf = tb.finishCurrentSegment();
                                    outPtr = 0;
                                    continue;
                                }
                            }
                            if (this.mCfgNormalizeLFs) {
                                c = '\n';
                            }
                        }
                    }
                }
            }
            outBuf[outPtr++] = c;
            if (outPtr < outBuf.length) continue;
            outBuf = tb.finishCurrentSegment();
            outPtr = 0;
        }
        this.throwDTDUnexpectedChar(c, "; expected closing '>' after ENTITY declaration.");
        return tb;
    }

    private String parseAttrDefaultValue(char quoteChar, NameKey attrName, Location loc, boolean gotFixed) throws IOException, XMLStreamException {
        if (quoteChar != '\"' && quoteChar != '\'') {
            String msg = "; expected a single or double quote to enclose the default value";
            if (!gotFixed) {
                msg = msg + ", or one of keywords (#REQUIRED, #IMPLIED, #FIXED)";
            }
            msg = msg + " (for attribute '" + attrName + "')";
            this.throwDTDUnexpectedChar(quoteChar, msg);
        }
        WstxInputSource currScope = this.mInput;
        TextBuffer tb = new TextBuffer(200);
        tb.resetInitialized();
        int outPtr = 0;
        char[] outBuf = tb.getCurrentSegment();
        int outLen = outBuf.length;
        while (true) {
            char c;
            if (this.mInputPtr >= this.mInputLen) {
                boolean check = this.mInput == currScope;
                this.loadMore(this.getErrorMsg());
                if (check && this.mInput != currScope) {
                    this.throwParseError("Unterminated attribute default value for attribute '" + attrName + "' (definition started at " + loc + ")");
                }
            }
            if ((c = this.mInputBuffer[this.mInputPtr++]) < '?') {
                if (c <= ' ') {
                    if (c == '\n') {
                        this.markLF();
                    } else if (c == '\r') {
                        c = this.getNextChar(" in attribute default value");
                        if (c != '\n') {
                            --this.mInputPtr;
                            c = this.mCfgNormalizeLFs ? (char)'\n' : '\r';
                        } else if (!this.mCfgNormalizeLFs && !this.mCfgNormAttrs) {
                            if (outPtr >= outLen) {
                                outBuf = this.mTextBuffer.finishCurrentSegment();
                                outPtr = 0;
                                outLen = outBuf.length;
                            }
                            outBuf[outPtr++] = 13;
                        }
                        this.markLF();
                    } else if (c == '\u0000') {
                        this.throwNullChar();
                    }
                    if (this.mCfgNormAttrs) {
                        c = ' ';
                    }
                } else if (c == quoteChar) {
                    if (this.mInput == currScope) {
                        break;
                    }
                } else if (c == '&') {
                    c = this.inputInBuffer() >= 3 ? (char)this.resolveSimpleEntity(true) : (char)this.resolveCharOnlyEntity(true);
                    if (c == '\u0000') {
                        c = this.getNextChar(" in entity reference");
                        String id = this.parseEntityName(c);
                        if (this.mIsExternal) {
                            int setId = this.expandEntity(id, this.mPredefdGEs, this.mGeneralEntities, false);
                            if (setId == 1) {
                                this.mUsesPredefdEntities = true;
                                this.mRefdGEs = null;
                                continue;
                            }
                            if (this.mUsesPredefdEntities) continue;
                            if (this.mRefdGEs == null) {
                                this.mRefdGEs = new HashSet();
                            }
                            this.mRefdGEs.add(id);
                            continue;
                        }
                        this.expandEntity(id, null, this.mGeneralEntities, false);
                        continue;
                    }
                } else if (c == '<') {
                    this.throwParseError("Unexpected '<'  in attribute default value");
                }
            }
            if (outPtr >= outLen) {
                outBuf = this.mTextBuffer.finishCurrentSegment();
                outPtr = 0;
                outLen = outBuf.length;
            }
            outBuf[outPtr++] = c;
        }
        tb.setCurrentLength(outPtr);
        return tb.contentsAsString();
    }

    private void checkInclusion() throws IOException, XMLStreamException {
        String keyword;
        if (!this.mIsExternal && this.mInput == this.mRootInput) {
            this.throwParseError("Internal DTD subset can not use (INCLUDE/IGNORE) directives (except via external entities).");
        }
        if (this.skipDtdWs(false) != 'I') {
            keyword = this.readDTDKeyword("I");
        } else {
            char c = this.getNextExpanded();
            if (c == 'G') {
                keyword = this.checkDTDKeyword("NORE");
                if (keyword == null) {
                    this.handleIgnored();
                    return;
                }
                keyword = "IG" + keyword;
            } else if (c == 'N') {
                keyword = this.checkDTDKeyword("CLUDE");
                if (keyword == null) {
                    this.handleIncluded();
                    return;
                }
                keyword = "IN" + keyword;
            } else {
                --this.mInputPtr;
                keyword = this.readDTDKeyword("I");
            }
        }
        this.throwParseError("Unrecognized directive '" + keyword + "'; expected either 'IGNORE' or 'INCLUDE'.");
    }

    private void handleIncluded() throws IOException, XMLStreamException {
        char c = this.skipDtdWs(false);
        if (c != '[') {
            this.throwDTDUnexpectedChar(c, this.getErrorMsg() + "; expected '[' to follow 'INCLUDE' directive.");
        }
        ++this.mIncludeCount;
    }

    private void handleIgnored() throws IOException, XMLStreamException {
        char c = this.skipDtdWs(false);
        int count = 1;
        if (c != '[') {
            this.throwDTDUnexpectedChar(c, "; expected '[' to follow 'IGNORE' directive.");
        }
        String errorMsg = this.getErrorMsg();
        while (true) {
            char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(errorMsg);
            if (c == '\n' || c == '\r') {
                this.skipCRLF(c);
                continue;
            }
            if (c == ']') {
                if (this.getNextChar(errorMsg) == ']' && this.getNextChar(errorMsg) == '>') {
                    if (--count >= 1) continue;
                    return;
                }
                --this.mInputPtr;
                continue;
            }
            if (c != '<') continue;
            if (this.getNextChar(errorMsg) == '!' && this.getNextChar(errorMsg) == '[') {
                ++count;
                continue;
            }
            --this.mInputPtr;
        }
    }

    private void reportBadDirective(String dir) throws WstxException {
        String msg = "Unrecognized DTD directive '<!" + dir + " >'; expected ATTLIST, ELEMENT, ENTITY or NOTATION";
        if (this.mCfgSupportDTDPP) {
            msg = msg + " (or, for DTD++, TARGETNS)";
        }
        this.throwDTDError(msg);
    }

    private void throwDTDError(String msg) throws WstxException {
        this.throwParseError(msg);
    }

    private void throwDTDElemError(String msg, Object elem) throws WstxException {
        this.throwDTDError(this.elemDesc(elem) + ": " + msg);
    }

    private void throwDTDAttrError(String msg, DTDElement elem, NameKey attrName) throws WstxException {
        this.throwDTDError(this.attrDesc(elem, attrName) + ": " + msg);
    }

    private void throwDTDUnexpectedChar(int i, String extraMsg) throws WstxException {
        if (extraMsg == null) {
            this.throwUnexpectedChar(i, this.getErrorMsg());
        }
        this.throwUnexpectedChar(i, this.getErrorMsg() + extraMsg);
    }

    private String elemDesc(Object elem) {
        return "Element <" + elem + ">)";
    }

    private String attrDesc(Object elem, NameKey attrName) {
        return "Attribute '" + attrName + "' (of element <" + elem + ">)";
    }

    private void handleDeclaration(char c) throws IOException, XMLStreamException {
        String keyw = null;
        if (c == 'A') {
            keyw = this.checkDTDKeyword("TTLIST");
            if (keyw == null) {
                this.handleAttlistDecl();
                return;
            }
            keyw = "A" + keyw;
        } else if (c == 'E') {
            c = this.getNextExpanded();
            if (c == 'N') {
                keyw = this.checkDTDKeyword("TITY");
                if (keyw == null) {
                    this.handleEntityDecl(false);
                    return;
                }
                keyw = "EN" + keyw;
            } else if (c == 'L') {
                keyw = this.checkDTDKeyword("EMENT");
                if (keyw == null) {
                    this.handleElementDecl();
                    return;
                }
                keyw = "EL" + keyw;
            } else {
                keyw = this.readDTDKeyword("E");
            }
        } else if (c == 'N') {
            keyw = this.checkDTDKeyword("OTATION");
            if (keyw == null) {
                this.handleNotationDecl();
                return;
            }
            keyw = "N" + keyw;
        } else if (c == 'T' && this.mCfgSupportDTDPP) {
            keyw = this.checkDTDKeyword("ARGETNS");
            if (keyw == null) {
                this.handleTargetNsDecl();
                return;
            }
            keyw = "T" + keyw;
        } else {
            --this.mInputPtr;
            keyw = this.readDTDKeyword(null);
        }
        this.reportBadDirective(keyw);
    }

    private void handleSuppressedDeclaration() throws IOException, XMLStreamException {
        String keyw;
        char c = this.getNextExpanded();
        if (c == 'N') {
            keyw = this.checkDTDKeyword("TITY");
            if (keyw == null) {
                this.handleEntityDecl(true);
                return;
            }
            keyw = "EN" + keyw;
            this.mFlattenWriter.enableOutput(this.mInputPtr);
        } else {
            this.mFlattenWriter.enableOutput(this.mInputPtr);
            this.mFlattenWriter.output("<!E");
            this.mFlattenWriter.output(c);
            if (c == 'L') {
                keyw = this.checkDTDKeyword("EMENT");
                if (keyw == null) {
                    this.handleElementDecl();
                    return;
                }
                keyw = "EL" + keyw;
            } else {
                keyw = this.readDTDKeyword("E");
            }
        }
        this.reportBadDirective(keyw);
    }

    private void handleAttlistDecl() throws IOException, XMLStreamException {
        char c = this.skipObligatoryDtdWs(true);
        NameKey elemName = this.readDTDQName(c);
        Location loc = this.getLocation();
        HashMap m = this.getElementMap();
        DTDElement elem = (DTDElement)m.get(elemName);
        if (elem == null) {
            elem = DTDElement.createPlaceholder(loc, elemName);
            m.put(elemName, elem);
        }
        int index = 0;
        while (true) {
            if (FullDTDReader.isSpaceChar(c = this.getNextExpanded())) {
                --this.mInputPtr;
                c = this.skipDtdWs(true);
            } else if (c != '>') {
                this.throwDTDUnexpectedChar(c, "; excepted either '>' closing ATTLIST declaration, or a white space character separating individual attribute declarations");
            }
            if (c == '>') break;
            this.handleAttrDecl(elem, c, index, loc);
            ++index;
        }
    }

    private void handleElementDecl() throws IOException, XMLStreamException {
        HashMap m;
        DTDElement oldElem;
        int vldContent;
        StructValidator val;
        Location loc;
        NameKey elemName;
        char c;
        block8: {
            block9: {
                String keyw;
                block12: {
                    block13: {
                        block14: {
                            block10: {
                                block11: {
                                    block7: {
                                        c = this.skipObligatoryDtdWs(true);
                                        elemName = this.readDTDQName(c);
                                        loc = this.getLocation();
                                        c = this.skipObligatoryDtdWs(true);
                                        val = null;
                                        vldContent = 3;
                                        if (c != '(') break block7;
                                        c = this.skipDtdWs(true);
                                        if (c == '#') {
                                            val = this.readMixedSpec(elemName, this.mCfgValidate);
                                            vldContent = 3;
                                        } else {
                                            --this.mInputPtr;
                                            ContentSpec spec = this.readContentSpec(elemName, true, this.mCfgValidate);
                                            val = spec.getValidator();
                                            if (val == null) {
                                                val = new DFAValidator(DFAState.constructDFA(spec));
                                            }
                                            vldContent = 1;
                                        }
                                        break block8;
                                    }
                                    if (!FullDTDReader.isNameStartChar(c)) break block9;
                                    keyw = null;
                                    if (c != 'A') break block10;
                                    keyw = this.checkDTDKeyword("NY");
                                    if (keyw != null) break block11;
                                    val = null;
                                    vldContent = 2;
                                    break block8;
                                }
                                keyw = "A" + keyw;
                                break block12;
                            }
                            if (c != 'E') break block13;
                            keyw = this.checkDTDKeyword("MPTY");
                            if (keyw != null) break block14;
                            val = null;
                            vldContent = 0;
                            break block8;
                        }
                        keyw = "E" + keyw;
                        break block12;
                    }
                    --this.mInputPtr;
                    keyw = this.readDTDKeyword(null);
                }
                this.throwParseError("Unrecognized DTD content spec keyword '" + keyw + "'; expected ANY or EMPTY");
                break block8;
            }
            this.throwDTDUnexpectedChar(c, this.getErrorMsg() + ": excepted '(' to start content specification");
        }
        c = this.skipDtdWs(true);
        if (c != '>') {
            this.throwDTDUnexpectedChar(c, this.getErrorMsg() + "; expected '>' to finish the ENTITY declaration");
        }
        if ((oldElem = (DTDElement)(m = this.getElementMap()).get(elemName)) != null) {
            if (oldElem.isDefined()) {
                DTDSubsetImpl.throwElementException(oldElem, loc);
            }
            oldElem = oldElem.define(loc, val, vldContent);
        } else {
            oldElem = DTDElement.createDefined(loc, elemName, val, vldContent);
        }
        m.put(elemName, oldElem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEntityDecl(boolean suppressPEDecl) throws IOException, XMLStreamException {
        Object old;
        HashMap m;
        EntityDecl ent;
        boolean isParam;
        String emsg = this.getErrorMsg();
        char c = this.getNextCharAfterWS(emsg);
        boolean bl = isParam = c == '%';
        if (suppressPEDecl && !isParam) {
            this.mFlattenWriter.enableOutput(this.mInputPtr);
            this.mFlattenWriter.output("<!ENTITY ");
            this.mFlattenWriter.output(c);
        }
        if (isParam) {
            c = this.skipObligatoryDtdWs(true);
        }
        String id = this.readDTDName(c);
        Location evtLoc = this.getLocation();
        try {
            c = this.skipDtdWs(true);
            if (c == '\'' || c == '\"') {
                char foo = this.getNextChar(emsg);
                WstxInputLocation contentLoc = this.getLastCharLocation();
                --this.mInputPtr;
                TextBuffer contents = this.parseEntityValue(id, contentLoc, c);
                ent = new IntEntity(evtLoc, id, this.getSource(), contents.contentsAsArray(), contentLoc);
            } else {
                if (!FullDTDReader.isNameStartChar(c)) {
                    this.throwDTDUnexpectedChar(c, this.getErrorMsg() + "; expected either quoted value, or keyword 'PUBLIC' or 'SYSTEM'.");
                }
                ent = this.handleExternalEntityDecl(isParam, id, c, evtLoc);
            }
            Object var12_12 = null;
            if (suppressPEDecl && isParam) {
                this.mFlattenWriter.enableOutput(this.mInputPtr);
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (suppressPEDecl && isParam) {
                this.mFlattenWriter.enableOutput(this.mInputPtr);
            }
            throw throwable;
        }
        if (isParam) {
            m = this.mParamEntities;
            if (m == null) {
                this.mParamEntities = m = new HashMap();
            }
        } else {
            m = this.mGeneralEntities;
            if (m == null) {
                m = JdkFeatures.getInstance().getInsertOrderedMap();
                this.mGeneralEntities = m;
            }
        }
        if (m.size() > 0 && (old = m.get(id)) != null) {
            if (this.mReporter != null) {
                EntityDecl oldED = (EntityDecl)old;
                String str = " entity '" + id + "' defined more than once: first declaration at " + oldED.getLocation();
                str = isParam ? "Parameter" + str : "General" + str;
                try {
                    this.mReporter.report(str, ErrorConsts.WT_ENT_DECL, oldED, evtLoc);
                }
                catch (XMLStreamException strex) {
                    this.throwFromStrE(strex);
                }
            }
        } else {
            m.put(id, ent);
        }
    }

    private void handleNotationDecl() throws IOException, XMLStreamException {
        HashMap m;
        NotationDecl oldDecl;
        String sysId;
        String pubId;
        char c = this.skipObligatoryDtdWs(true);
        String id = this.readDTDName(c);
        c = this.skipObligatoryDtdWs(true);
        boolean isPublic = this.checkPublicSystemKeyword(c);
        c = this.skipObligatoryDtdWs(true);
        if (isPublic) {
            if (c != '\"' && c != '\'') {
                this.throwDTDUnexpectedChar(c, this.getErrorMsg() + "; expected a quote to start the public identifier.");
            }
            pubId = this.parsePublicId(c, this.mCfgNormalizeLFs, this.getErrorMsg());
            c = this.skipDtdWs(true);
        } else {
            pubId = null;
        }
        if (c == '\"' || c == '\'') {
            sysId = this.parseSystemId(c, this.mCfgNormalizeLFs, this.getErrorMsg());
            c = this.skipDtdWs(true);
        } else {
            if (!isPublic) {
                this.throwDTDUnexpectedChar(c, this.getErrorMsg() + "; expected a quote to start the system identifier.");
            }
            sysId = null;
        }
        if (c != '>') {
            this.throwDTDUnexpectedChar(c, "; expected closing '>' after NOTATION declaration.");
        }
        Location evtLoc = this.getLocation();
        NotationDecl nd = new NotationDecl(evtLoc, id, pubId, sysId);
        if (this.mPredefdNotations != null && (oldDecl = (NotationDecl)this.mPredefdNotations.get(id)) != null) {
            DTDSubsetImpl.throwNotationException(oldDecl, nd);
        }
        if ((m = this.mNotations) == null) {
            this.mNotations = m = JdkFeatures.getInstance().getInsertOrderedMap();
        } else {
            NotationDecl oldDecl2 = (NotationDecl)m.get(id);
            if (oldDecl2 != null) {
                DTDSubsetImpl.throwNotationException(oldDecl2, nd);
            }
        }
        m.put(id, nd);
    }

    private void handleTargetNsDecl() throws IOException, XMLStreamException {
        String name;
        this.mAnyDTDppFeatures = true;
        char c = this.skipObligatoryDtdWs(true);
        if (FullDTDReader.isNameStartChar(c)) {
            name = this.readDTDLocalName(c, false);
            c = this.skipObligatoryDtdWs(true);
        } else {
            name = null;
        }
        if (c != '\"' && c != '\'') {
            if (c == '>') {
                this.throwDTDError("Missing namespace URI for TARGETNS directive");
            }
            this.throwDTDUnexpectedChar(c, "; expected a single or double quote to enclose the namespace URI");
        }
        String uri = this.parseSystemId(c, false, "in namespace URI");
        if ((this.mConfigFlags & 0x400) != 0) {
            uri = InternCache.getInstance().intern(uri);
        }
        if ((c = this.skipDtdWs(true)) != '>') {
            this.throwDTDUnexpectedChar(c, "; expected '>' to end TARGETNS directive");
        }
        if (name == null) {
            this.mDefaultNsURI = uri;
        } else {
            if (this.mNamespaces == null) {
                this.mNamespaces = new HashMap();
            }
            this.mNamespaces.put(name, uri);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleAttrDecl(DTDElement elem, char c, int index, Location loc) throws IOException, XMLStreamException {
        DTDAttribute attr;
        String defVal;
        int defType;
        WordResolver enumValues;
        int type;
        NameKey attrName;
        block26: {
            block28: {
                String defTypeStr;
                block29: {
                    block25: {
                        block27: {
                            attrName = this.readDTDQName(c);
                            c = this.skipObligatoryDtdWs(true);
                            type = 0;
                            enumValues = null;
                            if (c != '(') break block27;
                            enumValues = this.parseEnumerated(elem, attrName, false);
                            type = 1;
                            break block25;
                        }
                        String typeStr = this.readDTDName(c);
                        switch (typeStr.charAt(0)) {
                            case 'C': {
                                if (typeStr != "CDATA") break;
                                type = 0;
                                break block25;
                            }
                            case 'I': {
                                if (typeStr == "ID") {
                                    type = 2;
                                    break block25;
                                } else if (typeStr == "IDREF") {
                                    type = 3;
                                    break block25;
                                } else {
                                    if (typeStr != "IDREFS") break;
                                    type = 4;
                                }
                                break block25;
                            }
                            case 'E': {
                                if (typeStr == "ENTITY") {
                                    type = 5;
                                    break block25;
                                } else {
                                    if (typeStr != "ENTITIES") break;
                                    type = 6;
                                }
                                break block25;
                            }
                            case 'N': {
                                if (typeStr == "NOTATION") {
                                    type = 7;
                                    c = this.skipObligatoryDtdWs(true);
                                    if (c != '(') {
                                        this.throwDTDUnexpectedChar(c, "Excepted '(' to start the list of NOTATION ids");
                                    }
                                    enumValues = this.parseEnumerated(elem, attrName, true);
                                } else if (typeStr == "NMTOKEN") {
                                    type = 8;
                                } else {
                                    if (typeStr != "NMTOKENS") break;
                                    type = 9;
                                }
                                break block25;
                            }
                        }
                        this.throwDTDAttrError("Unrecognized attribute type '" + typeStr + "'" + ErrorConsts.ERR_DTD_ATTR_TYPE, elem, attrName);
                    }
                    defType = 1;
                    defVal = null;
                    c = this.skipDtdWs(true);
                    if (c != '#') break block28;
                    defTypeStr = this.readDTDName();
                    if (defTypeStr != "REQUIRED") break block29;
                    defType = 3;
                    break block26;
                }
                if (defTypeStr == "IMPLIED") {
                    defType = 2;
                    break block26;
                } else if (defTypeStr == "FIXED") {
                    defType = 4;
                    c = this.skipObligatoryDtdWs(true);
                    defVal = this.parseAttrDefaultValue(c, attrName, loc, true);
                    break block26;
                } else {
                    this.throwDTDAttrError("Unrecognized attribute default value directive #" + defTypeStr + ErrorConsts.ERR_DTD_DEFAULT_TYPE, elem, attrName);
                }
                break block26;
            }
            defVal = this.parseAttrDefaultValue(c, attrName, loc, false);
        }
        if (type == 2 && (defType == 1 || defType == 4)) {
            this.throwDTDAttrError("has type ID; can not have a default (or #FIXED) value (XML 1.0/#3.3.1)", elem, attrName);
        }
        if ((attr = elem.addAttribute(this, attrName, type, defType, defVal, enumValues)) != null) {
            if (defVal == null) return;
            attr.validateDefault(this, this.mCfgNormAttrs);
            return;
        }
        if (this.mReporter == null) return;
        try {
            this.mReporter.report("Attribute '" + attrName + "' already declared for element <" + elem + ">; ignoring re-declaration", ErrorConsts.WT_ATTR_DECL, elem, loc);
            return;
        }
        catch (XMLStreamException strex) {
            this.throwFromStrE(strex);
            return;
        }
    }

    private WordResolver parseEnumerated(DTDElement elem, NameKey attrName, boolean isNotation) throws IOException, XMLStreamException {
        HashMap sharedEnums;
        TreeSet<String> set = new TreeSet<String>();
        char c = this.skipDtdWs(true);
        if (c == ')') {
            this.throwDTDUnexpectedChar(c, " (empty list; missing identifier(s))?");
        }
        if (isNotation) {
            sharedEnums = null;
        } else {
            sharedEnums = this.mSharedEnumValues;
            if (sharedEnums == null && !isNotation) {
                this.mSharedEnumValues = sharedEnums = new HashMap();
            }
        }
        String id = isNotation ? this.readNotationEntry(c, attrName) : this.readEnumEntry(c, sharedEnums);
        set.add(id);
        while ((c = this.skipDtdWs(true)) != ')') {
            if (c != '|') {
                this.throwDTDUnexpectedChar(c, "; missing '|' separator?");
            }
            c = this.skipDtdWs(true);
            id = isNotation ? this.readNotationEntry(c, attrName) : this.readEnumEntry(c, sharedEnums);
            if (set.add(id)) continue;
            this.throwDTDAttrError("Duplicate enumeration value '" + id + "'", elem, attrName);
        }
        return WordResolver.constructInstance(set);
    }

    private String readNotationEntry(char c, NameKey attrName) throws IOException, WstxException {
        NotationDecl decl;
        String id = this.readDTDName(c);
        if (this.mPredefdNotations != null) {
            NotationDecl decl2 = (NotationDecl)this.mPredefdNotations.get(id);
            if (decl2 != null) {
                this.mUsesPredefdNotations = true;
            }
            return decl2.getName();
        }
        NotationDecl notationDecl = decl = this.mNotations == null ? null : (NotationDecl)this.mNotations.get(id);
        if (decl == null) {
            String msg = "Notation '" + id + "' not defined; ";
            if (attrName == null) {
                this.throwDTDError(msg + "can not refer to from an entity");
            }
            this.throwDTDError(msg + "can not be used as value for attribute list of '" + attrName + "'");
        }
        return decl.getName();
    }

    private String readEnumEntry(char c, HashMap sharedEnums) throws IOException, WstxException {
        String id = this.readDTDNmtoken(c);
        String sid = (String)sharedEnums.get(id);
        if (sid == null) {
            sid = id;
            sharedEnums.put(sid, sid);
        }
        return sid;
    }

    private StructValidator readMixedSpec(NameKey elemName, boolean construct) throws IOException, XMLStreamException {
        char c;
        String keyw = this.checkDTDKeyword("PCDATA");
        if (keyw != null) {
            this.throwParseError("Unrecognized directive #" + keyw + "'; expected #PCDATA (or element name)");
        }
        HashMap m = JdkFeatures.getInstance().getInsertOrderedMap();
        while ((c = this.skipDtdWs(true)) != ')') {
            NameKey n;
            TokenContentSpec old;
            if (c == '|') {
                c = this.skipDtdWs(true);
            } else if (c == ',') {
                this.throwDTDUnexpectedChar(c, " (sequences not allowed within mixed content)");
            } else if (c == '(') {
                this.throwDTDUnexpectedChar(c, " (sub-content specs not allowed within mixed content)");
            }
            if ((old = m.put(n = this.readDTDQName(c), TokenContentSpec.construct(' ', n))) == null) continue;
            this.throwDTDElemError("duplicate child element <" + n + "> in mixed content model", elemName);
        }
        char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
        if (c != '*') {
            if (m.size() > 0) {
                this.throwParseError("Missing trailing '*' after a non-empty mixed content specification");
            }
            --this.mInputPtr;
        }
        if (!construct) {
            return null;
        }
        if (m.isEmpty()) {
            return EmptyValidator.getInstance();
        }
        ChoiceContentSpec spec = ChoiceContentSpec.constructMixed(this.mCfgNsEnabled, m.values());
        StructValidator val = ((ContentSpec)spec).getValidator();
        if (val == null) {
            DFAState dfa = DFAState.constructDFA(spec);
            val = new DFAValidator(dfa);
        }
        return val;
    }

    private ContentSpec readContentSpec(NameKey elemName, boolean mainLevel, boolean construct) throws IOException, XMLStreamException {
        ContentSpec cs;
        if (mainLevel) {
            this.mTokenIndex = 1;
        }
        ArrayList<ContentSpec> subSpecs = new ArrayList<ContentSpec>();
        boolean isChoice = false;
        boolean choiceSet = false;
        while (true) {
            char c;
            if ((c = this.skipDtdWs(true)) == ')') {
                if (!subSpecs.isEmpty()) break;
                this.throwParseError("Empty content specification for '" + elemName + "' (need at least one entry)");
                break;
            }
            if (c == '|' || c == ',') {
                boolean newChoice;
                boolean bl = newChoice = c == '|';
                if (!choiceSet) {
                    isChoice = newChoice;
                    choiceSet = true;
                } else if (isChoice != newChoice) {
                    this.throwParseError("Can not mix content spec separators ('|' and ','); need to use parenthesis groups");
                }
                c = this.skipDtdWs(true);
            } else if (!subSpecs.isEmpty()) {
                this.throwDTDUnexpectedChar(c, " (missing separator '|' or ','?)");
            }
            if (c == '(') {
                cs = this.readContentSpec(elemName, false, construct);
                subSpecs.add(cs);
                continue;
            }
            if (c == '|' || c == ',') {
                this.throwDTDUnexpectedChar(c, " (missing element name?)");
            }
            NameKey thisName = this.readDTDQName(c);
            char arity = this.readArity();
            TokenContentSpec cs2 = construct ? TokenContentSpec.construct(arity, thisName) : TokenContentSpec.getDummySpec();
            subSpecs.add(cs2);
        }
        char arity = this.readArity();
        if (!construct) {
            return TokenContentSpec.getDummySpec();
        }
        if (subSpecs.size() == 1) {
            cs = (ContentSpec)subSpecs.get(0);
            char otherArity = cs.getArity();
            if (arity != otherArity) {
                cs.setArity(FullDTDReader.combineArities(arity, otherArity));
            }
            return cs;
        }
        if (isChoice) {
            return ChoiceContentSpec.constructChoice(this.mCfgNsEnabled, arity, subSpecs);
        }
        return SeqContentSpec.construct(this.mCfgNsEnabled, arity, subSpecs);
    }

    private static char combineArities(char arity1, char arity2) {
        if (arity1 == arity2) {
            return arity1;
        }
        if (arity1 == ' ') {
            return arity2;
        }
        if (arity2 == ' ') {
            return arity1;
        }
        if (arity1 == '*' || arity2 == '*') {
            return '*';
        }
        return '*';
    }

    private EntityDecl handleExternalEntityDecl(boolean isParam, String id, char c, Location evtLoc) throws IOException, XMLStreamException {
        Object errId = null;
        boolean isPublic = this.checkPublicSystemKeyword(c);
        String pubId = null;
        if (isPublic) {
            c = this.skipObligatoryDtdWs(true);
            if (c != '\"' && c != '\'') {
                this.throwDTDUnexpectedChar(c, this.getErrorMsg() + "; expected a quote to start the public identifier.");
            }
            pubId = this.parsePublicId(c, this.mCfgNormalizeLFs, this.getErrorMsg());
        }
        if ((c = this.skipObligatoryDtdWs(true)) != '\"' && c != '\'') {
            this.throwDTDUnexpectedChar(c, this.getErrorMsg() + "; expected a quote to start the system identifier.");
        }
        String sysId = this.parseSystemId(c, this.mCfgNormalizeLFs, this.getErrorMsg());
        String notationId = null;
        c = this.skipDtdWs(true);
        if (c != '>') {
            this.checkDTDKeyword("NDATA", c, "; expected either NDATA keyword, or closing '>'.");
            c = this.skipObligatoryDtdWs(true);
            notationId = this.readNotationEntry(c, null);
            c = this.skipDtdWs(true);
        }
        if (c != '>') {
            this.throwDTDUnexpectedChar(c, this.getErrorMsg() + "; expected closing '>'.");
        }
        if (notationId == null) {
            return new ParsedExtEntity(evtLoc, id, this.getSource(), pubId, sysId);
        }
        return new UnparsedExtEntity(evtLoc, id, this.getSource(), pubId, sysId, notationId);
    }

    private HashMap getElementMap() {
        HashMap m = this.mElements;
        if (m == null) {
            this.mElements = m = JdkFeatures.getInstance().getInsertOrderedMap();
        }
        return m;
    }

    private NameKey findSharedName(String prefix, String localName) {
        HashMap<NameKey, NameKey> m = this.mSharedNames;
        if (this.mSharedNames == null) {
            this.mSharedNames = m = new HashMap<NameKey, NameKey>();
        } else {
            NameKey key = this.mAccessKey;
            key.reset(prefix, localName);
            key = (NameKey)m.get(key);
            if (key != null) {
                return key;
            }
        }
        NameKey result = new NameKey(prefix, localName);
        m.put(result, result);
        return result;
    }
}

