/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.evt;

import com.ctc.wstx.cfg.ErrorConsts;
import com.ctc.wstx.dtd.DTDSubset;
import com.ctc.wstx.ent.EntityDecl;
import com.ctc.wstx.evt.BaseStartElement;
import com.ctc.wstx.evt.CompactStartElement;
import com.ctc.wstx.evt.WCharacters;
import com.ctc.wstx.evt.WComment;
import com.ctc.wstx.evt.WDTD;
import com.ctc.wstx.evt.WEndDocument;
import com.ctc.wstx.evt.WEndElement;
import com.ctc.wstx.evt.WEntityReference;
import com.ctc.wstx.evt.WProcInstr;
import com.ctc.wstx.evt.WStartDocument;
import com.ctc.wstx.exc.WstxException;
import com.ctc.wstx.sr.ElemAttrs;
import com.ctc.wstx.sr.ElemCallback;
import com.ctc.wstx.sr.StreamReaderImpl;
import com.ctc.wstx.util.BaseNsContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.stream.util.XMLEventConsumer;
import org.codehaus.stax2.DTDInfo;
import org.codehaus.stax2.XMLStreamReader2;

public class DefaultEventAllocator
extends ElemCallback
implements XMLEventAllocator,
XMLStreamConstants {
    static final DefaultEventAllocator sStdInstance = new DefaultEventAllocator(true);
    protected final boolean mAccurateLocation;
    protected Location mLastLocation = null;

    protected DefaultEventAllocator(boolean accurateLocation) {
        this.mAccurateLocation = accurateLocation;
    }

    public static DefaultEventAllocator getDefaultInstance() {
        return sStdInstance;
    }

    public static DefaultEventAllocator getFastInstance() {
        return new DefaultEventAllocator(false);
    }

    public XMLEvent allocate(XMLStreamReader r) throws XMLStreamException {
        Location loc;
        if (this.mAccurateLocation) {
            loc = r.getLocation();
        } else {
            loc = this.mLastLocation;
            if (loc == null) {
                loc = this.mLastLocation = r.getLocation();
            }
        }
        switch (r.getEventType()) {
            case 12: {
                return new WCharacters(loc, r.getText(), true);
            }
            case 4: {
                return new WCharacters(loc, r.getText(), false);
            }
            case 5: {
                return new WComment(loc, r.getText());
            }
            case 11: {
                if (r instanceof XMLStreamReader2) {
                    XMLStreamReader2 sr2 = (XMLStreamReader2)r;
                    DTDInfo dtd = sr2.getDTDInfo();
                    return new WDTD(loc, dtd.getDTDRootName(), dtd.getDTDSystemId(), dtd.getDTDPublicId(), dtd.getDTDInternalSubset(), (DTDSubset)dtd.getProcessedDTD());
                }
                return new WDTD(loc, null, r.getText());
            }
            case 8: {
                return new WEndDocument(loc);
            }
            case 2: {
                return new WEndElement(loc, r);
            }
            case 3: {
                return new WProcInstr(loc, r.getPITarget(), r.getPIData());
            }
            case 6: {
                WCharacters ch = new WCharacters(loc, r.getText(), false);
                ch.setWhitespaceStatus(true);
                return ch;
            }
            case 7: {
                return new WStartDocument(loc, r);
            }
            case 1: {
                StreamReaderImpl sr = (StreamReaderImpl)r;
                BaseStartElement be = (BaseStartElement)sr.withStartElement(this, loc);
                if (be == null) {
                    throw new WstxException("Trying to create START_ELEMENT when current event is " + ErrorConsts.tokenTypeDesc(sr.getEventType()), loc);
                }
                return be;
            }
            case 9: {
                EntityDecl ed = ((StreamReaderImpl)r).getCurrentEntityDecl();
                return new WEntityReference(loc, ed);
            }
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                throw new WstxException("Internal error: should not get " + ErrorConsts.tokenTypeDesc(r.getEventType()));
            }
        }
        throw new Error("Unrecognized event type " + r.getEventType() + ".");
    }

    public void allocate(XMLStreamReader r, XMLEventConsumer consumer) throws XMLStreamException {
        consumer.add(this.allocate(r));
    }

    public XMLEventAllocator newInstance() {
        return this;
    }

    public Object withStartElement(Location loc, QName name, BaseNsContext nsCtxt, ElemAttrs attrs, boolean wasEmpty) {
        return new CompactStartElement(loc, name, nsCtxt, attrs, wasEmpty);
    }
}

