/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.io;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class AttrValueEscapingWriter
extends FilterWriter {
    final char mQuoteChar;
    final String mQuoteEntity;

    public AttrValueEscapingWriter(Writer out, char qchar, String qent) {
        super(out);
        this.mQuoteChar = qchar;
        this.mQuoteEntity = qent;
    }

    public void write(int c) throws IOException {
        if (c == this.mQuoteChar) {
            this.out.write(this.mQuoteEntity);
        } else if (c == 60) {
            this.out.write("&lt;");
        } else if (c == 38) {
            this.out.write("&amp;");
        } else {
            this.out.write(c);
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        len += off;
        char qchar = this.mQuoteChar;
        do {
            int start = off;
            char c = '\u0000';
            while (off < len && (c = cbuf[off]) != '<' && c != '&' && c != qchar) {
                ++off;
            }
            int outLen = off - start;
            if (outLen > 0) {
                this.out.write(cbuf, start, outLen);
            }
            if (off >= len) continue;
            if (c == '<') {
                this.out.write("&lt;");
                continue;
            }
            if (c == '&') {
                this.out.write("&amp;");
                continue;
            }
            if (c != qchar) continue;
            this.out.write(this.mQuoteEntity);
        } while (++off < len);
    }

    public void write(String str, int off, int len) throws IOException {
        len += off;
        char qchar = this.mQuoteChar;
        do {
            int start = off;
            char c = '\u0000';
            while (off < len && (c = str.charAt(off)) != '<' && c != '&' && c != qchar) {
                ++off;
            }
            int outLen = off - start;
            if (outLen > 0) {
                this.out.write(str, start, outLen);
            }
            if (off >= len) continue;
            if (c == '<') {
                this.out.write("&lt;");
                continue;
            }
            if (c == '&') {
                this.out.write("&amp;");
                continue;
            }
            if (c != qchar) continue;
            this.out.write(this.mQuoteEntity);
        } while (++off < len);
    }

    public static void writeEscapedAttrValue(Writer w, String value) throws IOException {
        int i = 0;
        int len = value.length();
        do {
            int start = i;
            char c = '\u0000';
            while (i < len && (c = value.charAt(i)) != '<' && c != '&' && c != '\"') {
                ++i;
            }
            int outLen = i - start;
            if (outLen > 0) {
                w.write(value, start, outLen);
            }
            if (i >= len) continue;
            if (c == '<') {
                w.write("&lt;");
                continue;
            }
            if (c == '&') {
                w.write("&amp;");
                continue;
            }
            if (c != '\"') continue;
            w.write("&quot;");
        } while (++i < len);
    }
}

