/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.io;

import com.ctc.wstx.io.BaseInputSource;
import com.ctc.wstx.io.WstxInputData;
import com.ctc.wstx.io.WstxInputSource;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;

public class ReaderSource
extends BaseInputSource {
    Reader mReader;
    final boolean mDoRealClose;
    int mInputProcessed = 0;
    int mInputRow = 1;
    int mInputRowStart = 0;

    public ReaderSource(WstxInputSource parent, String fromEntity, String pubId, String sysId, URL src, Reader r, boolean realClose, int bufSize) {
        super(parent, fromEntity, pubId, sysId, src);
        this.mReader = r;
        this.mDoRealClose = realClose;
        this.mBuffer = new char[bufSize];
    }

    public void setInputOffsets(int proc, int row, int rowStart) {
        this.mInputProcessed = proc;
        this.mInputRow = row;
        this.mInputRowStart = rowStart;
    }

    public void initInputLocation(WstxInputData reader) {
        reader.mCurrInputProcessed = this.mInputProcessed;
        reader.mCurrInputRow = this.mInputRow;
        reader.mCurrInputRowStart = this.mInputRowStart;
    }

    public int getInputBufferLength() {
        return this.mBuffer.length;
    }

    public int readInto(WstxInputData reader) throws IOException {
        if (this.mBuffer == null) {
            return -1;
        }
        int count = this.mReader.read(this.mBuffer, 0, this.mBuffer.length);
        if (count < 1) {
            this.mInputLen = 0;
            reader.mInputPtr = 0;
            reader.mInputLen = 0;
            if (count == 0) {
                throw new IOException("Reader returned 0 characters, even when asked to read up to " + this.mBuffer.length);
            }
            return -1;
        }
        reader.mInputBuffer = this.mBuffer;
        reader.mInputPtr = 0;
        this.mInputLen = count;
        reader.mInputLen = count;
        return count;
    }

    public boolean readMore(WstxInputData reader, int minAmount) throws IOException {
        if (this.mBuffer == null) {
            return false;
        }
        int ptr = reader.mInputPtr;
        int currAmount = this.mInputLen - ptr;
        if (currAmount > 0) {
            System.arraycopy(this.mBuffer, ptr, this.mBuffer, 0, currAmount);
            reader.mCurrInputProcessed -= currAmount;
            reader.mCurrInputRowStart += currAmount;
            minAmount -= currAmount;
        }
        reader.mInputBuffer = this.mBuffer;
        reader.mInputPtr = 0;
        this.mInputLen = currAmount;
        while (minAmount > 0) {
            int amount = this.mBuffer.length - currAmount;
            int actual = this.mReader.read(this.mBuffer, currAmount, amount);
            if (actual < 1) {
                if (actual == 0) {
                    throw new IOException("Reader returned 0 characters, even when asked to read up to " + amount);
                }
                reader.mInputLen = this.mInputLen = currAmount;
                return false;
            }
            currAmount += actual;
            minAmount -= actual;
        }
        reader.mInputLen = this.mInputLen = currAmount;
        return true;
    }

    public void close() throws IOException {
        if (this.mDoRealClose) {
            this.mReader.close();
        }
        this.mReader = null;
        this.mBuffer = null;
    }
}

