/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.sr;

import com.ctc.wstx.api.ReaderConfig;
import com.ctc.wstx.cfg.ErrorConsts;
import com.ctc.wstx.dtd.DTDId;
import com.ctc.wstx.dtd.DTDSubset;
import com.ctc.wstx.exc.WstxException;
import com.ctc.wstx.io.BranchingReaderSource;
import com.ctc.wstx.io.DefaultInputResolver;
import com.ctc.wstx.io.InputBootstrapper;
import com.ctc.wstx.io.WstxInputSource;
import com.ctc.wstx.sr.InputElementStack;
import com.ctc.wstx.sr.ReaderCreator;
import com.ctc.wstx.sr.VNonNsInputElementStack;
import com.ctc.wstx.sr.VNsInputElementStack;
import com.ctc.wstx.sr.WstxStreamReader;
import com.ctc.wstx.util.ExceptionUtil;
import com.ctc.wstx.util.URLUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.stream.StreamSource;

public class FullStreamReader
extends WstxStreamReader {
    static final String STAX_PROP_ENTITIES = "javax.xml.stream.entities";
    static final String STAX_PROP_NOTATIONS = "javax.xml.stream.notations";
    DTDSubset mDTD = null;
    boolean mDTDOverridden = false;

    private FullStreamReader(BranchingReaderSource input, ReaderCreator owner, ReaderConfig cfg, InputElementStack elemStack) throws IOException, XMLStreamException {
        super(input, owner, cfg, elemStack);
    }

    public static FullStreamReader createFullStreamReader(BranchingReaderSource input, ReaderCreator owner, ReaderConfig cfg, InputBootstrapper bs) throws IOException, XMLStreamException {
        InputElementStack elemStack;
        if (!cfg.willValidateWithDTD()) {
            elemStack = WstxStreamReader.createElementStack(cfg);
        } else {
            boolean normAttrs = cfg.willNormalizeAttrValues();
            elemStack = cfg.willSupportNamespaces() ? new VNsInputElementStack(16, sPrefixXml, sPrefixXmlns, normAttrs) : new VNonNsInputElementStack(16, normAttrs);
        }
        FullStreamReader sr = new FullStreamReader(input, owner, cfg, elemStack);
        sr.initProlog(bs);
        return sr;
    }

    public Object getProperty(String name) {
        if (this.mStTokenUnfinished) {
            try {
                this.finishToken();
            }
            catch (Exception ie) {
                this.throwLazyError(ie);
            }
        }
        if (this.mCurrToken == 11 && this.mDTD != null) {
            if (name.equals(STAX_PROP_ENTITIES)) {
                return this.mDTD.getGeneralEntityList();
            }
            if (name.equals(STAX_PROP_NOTATIONS)) {
                return this.mDTD.getNotationList();
            }
        }
        return super.getProperty(name);
    }

    public void setFeature(String name, Object value) {
        if (name.equals("org.codehaus.stax2.propDtdOverride")) {
            try {
                this.mDTD = this.setFeatureDTDOverride(value);
                this.mDTDOverridden = true;
            }
            catch (Throwable t) {
                ExceptionUtil.throwAsIllegalArgument(t);
            }
        } else {
            super.setFeature(name, value);
        }
    }

    protected final DTDSubset setFeatureDTDOverride(Object value) throws IOException, XMLStreamException {
        if (value == null) {
            return null;
        }
        boolean cache = this.hasConfigFlags(16384);
        DTDId id = null;
        if (cache) {
            Object ss;
            if (value instanceof StreamSource) {
                ss = (StreamSource)value;
                id = this.constructDtdId(((StreamSource)ss).getPublicId(), ((StreamSource)ss).getSystemId());
            } else if (value instanceof URL) {
                id = this.constructDtdId((URL)value);
            }
            if (id != null && (ss = this.findCachedSubset(id, null)) != null) {
                return ss;
            }
        }
        WstxInputSource src = DefaultInputResolver.sourceFrom(this.mInput, null, value, this.mReporter);
        return this.mConfig.getDtdReader().readExternalSubset(this, src, this.mConfig, null);
    }

    public Object getProcessedDTD() {
        return this.mDTD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishDTD(boolean copyContents) throws IOException, XMLStreamException {
        DTDSubset combo;
        if (!this.hasConfigFlags(16)) {
            super.finishDTD(copyContents);
            return;
        }
        char c = this.getNextChar(" in DOCTYPE declaration");
        DTDSubset intSubset = null;
        if (c == '[') {
            if (copyContents) {
                ((BranchingReaderSource)this.mInput).startBranch(this.mTextBuffer, this.mInputPtr, this.mCfgNormalizeLFs);
            }
            try {
                intSubset = this.mConfig.getDtdReader().readInternalSubset(this, this.mInput, this.mConfig);
                Object var5_4 = null;
                if (copyContents) {
                    ((BranchingReaderSource)this.mInput).endBranch(this.mInputPtr - 1);
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (copyContents) {
                    ((BranchingReaderSource)this.mInput).endBranch(this.mInputPtr - 1);
                }
                throw throwable;
            }
            c = this.getNextCharAfterWS(" in internal DTD subset");
        }
        if (c != '>') {
            this.throwUnexpectedChar(c, "; expected '>' to finish DOCTYPE declaration.");
        }
        if (this.mDTDOverridden) {
            combo = this.mDTD;
        } else {
            DTDSubset extSubset;
            DTDSubset dTDSubset = extSubset = this.mDtdPublicId != null || this.mDtdSystemId != null ? this.findDtdExtSubset(this.mDtdPublicId, this.mDtdSystemId, intSubset) : null;
            combo = intSubset == null ? extSubset : (extSubset == null ? intSubset : intSubset.combineWithExternalSubset(this, extSubset));
            this.mDTD = combo;
        }
        if (combo == null) {
            this.mGeneralEntities = null;
        } else {
            this.mGeneralEntities = combo.getGeneralEntityMap();
            if (this.hasConfigFlags(32)) {
                this.mElementStack.setElementSpecs(combo.getElementMap(), this.mSymbols, this.mCfgNormalizeAttrs, this.mGeneralEntities);
            }
        }
    }

    private DTDSubset findDtdExtSubset(String pubId, String sysId, DTDSubset intSubset) throws IOException, XMLStreamException {
        DTDSubset extSubset;
        boolean cache = this.hasConfigFlags(16384);
        DTDId dtdId = this.constructDtdId(pubId, sysId);
        if (cache && (extSubset = this.findCachedSubset(dtdId, intSubset)) != null) {
            return extSubset;
        }
        URL sysRef = dtdId.getSystemId();
        if (sysId == null) {
            this.throwParseError("Can not resolve DTD with public id '" + this.mDtdPublicId + "'; missing system identifier.");
        }
        if (sysRef == null) {
            sysRef = this.resolveExtSubsetPath(sysId);
        }
        WstxInputSource src = null;
        try {
            src = DefaultInputResolver.resolveEntity(this.mInput, null, pubId, sysId, this.mConfig.getDtdResolver(), this.mReporter);
        }
        catch (FileNotFoundException fex) {
            this.throwParseError("(was " + fex.getClass().getName() + ") " + fex.getMessage());
        }
        DTDSubset extSubset2 = this.mConfig.getDtdReader().readExternalSubset(this, src, this.mConfig, intSubset);
        if (cache && extSubset2.isCachable()) {
            this.mOwner.addCachedDTD(dtdId, extSubset2);
        }
        return extSubset2;
    }

    private DTDSubset findCachedSubset(DTDId id, DTDSubset intSubset) throws XMLStreamException {
        DTDSubset extSubset = this.mOwner.findCachedDTD(id);
        if (extSubset != null && (intSubset == null || extSubset.isReusableWith(intSubset))) {
            return extSubset;
        }
        return null;
    }

    private URL resolveExtSubsetPath(String systemId) throws IOException {
        URL ctxt;
        URL uRL = ctxt = this.mInput == null ? null : this.mInput.getSource();
        if (ctxt == null) {
            return URLUtil.urlFromSystemId(systemId);
        }
        return URLUtil.urlFromSystemId(systemId, ctxt);
    }

    protected DTDId constructDtdId(String pubId, String sysId) throws IOException {
        URL sysRef;
        int significantFlags = this.mConfigFlags & 0x20321;
        URL uRL = sysRef = sysId == null || sysId.length() == 0 ? null : this.resolveExtSubsetPath(sysId);
        if (pubId != null && pubId.length() > 0) {
            return DTDId.construct(pubId, sysRef, significantFlags);
        }
        if (sysRef == null) {
            return null;
        }
        return DTDId.constructFromSystemId(sysRef, significantFlags);
    }

    protected DTDId constructDtdId(URL sysId) throws IOException {
        int significantFlags = this.mConfigFlags & 0x20321;
        return DTDId.constructFromSystemId(sysId, significantFlags);
    }

    protected void reportInvalidContent(int evtType) throws WstxException {
        switch (this.mVldContent) {
            case 0: {
                this.throwParseError(ErrorConsts.ERR_VLD_EMPTY, this.mElementStack.getTopElementDesc(), ErrorConsts.tokenTypeDesc(evtType));
                break;
            }
            case 1: {
                this.throwParseError(ErrorConsts.ERR_VLD_NON_MIXED, (Object)this.mElementStack.getTopElementDesc());
                break;
            }
            case 2: {
                this.throwParseError(ErrorConsts.ERR_VLD_ANY, this.mElementStack.getTopElementDesc(), ErrorConsts.tokenTypeDesc(evtType));
                break;
            }
            default: {
                this.throwParseError("Internal error: trying to report invalid content for " + evtType);
            }
        }
    }
}

