/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.stax;

import com.ctc.wstx.api.ReaderConfig;
import com.ctc.wstx.cfg.InputConfigFlags;
import com.ctc.wstx.dtd.DTDId;
import com.ctc.wstx.dtd.DTDReaderProxy;
import com.ctc.wstx.dtd.DTDSubset;
import com.ctc.wstx.dtd.MinimalDTDReaderProxy;
import com.ctc.wstx.exc.WstxIOException;
import com.ctc.wstx.io.BranchingReaderSource;
import com.ctc.wstx.io.InputBootstrapper;
import com.ctc.wstx.io.InputSourceFactory;
import com.ctc.wstx.io.ReaderBootstrapper;
import com.ctc.wstx.io.StreamBootstrapper;
import com.ctc.wstx.sr.ReaderCreator;
import com.ctc.wstx.sr.WstxStreamReader;
import com.ctc.wstx.util.DefaultXmlSymbolTable;
import com.ctc.wstx.util.SymbolTable;
import com.ctc.wstx.util.URLUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;

public class MinimalInputFactory
implements ReaderCreator,
InputConfigFlags {
    protected final boolean mIsMinimal;
    protected final ReaderConfig mConfig;
    static final SymbolTable mRootSymbols = DefaultXmlSymbolTable.getInstance();
    SymbolTable mSymbols = mRootSymbols;
    static /* synthetic */ Class class$com$ctc$wstx$stax$MinimalInputFactory;

    public MinimalInputFactory() {
        this(MinimalDTDReaderProxy.getInstance(), true);
    }

    protected MinimalInputFactory(DTDReaderProxy dtdReader, boolean minimal) {
        this.mConfig = ReaderConfig.createJ2MEDefaults(null, dtdReader);
        this.mIsMinimal = minimal;
    }

    public static MinimalInputFactory newMinimalInstance() {
        return new MinimalInputFactory();
    }

    public DTDSubset findCachedDTD(DTDId id) {
        return null;
    }

    public synchronized void updateSymbolTable(SymbolTable t) {
        SymbolTable curr = mRootSymbols;
        if (t.isDirectChildOf(curr)) {
            this.mSymbols = t;
        }
    }

    public synchronized void addCachedDTD(DTDId id, DTDSubset extSubset) {
    }

    public XMLStreamReader createXMLStreamReader(InputStream in) throws XMLStreamException {
        return this.createSR(null, StreamBootstrapper.getInstance(in, null, null, this.mConfig.getInputBufferLength()));
    }

    public XMLStreamReader createXMLStreamReader(InputStream in, String enc) throws XMLStreamException {
        if (enc == null || enc.length() == 0) {
            return this.createXMLStreamReader(in);
        }
        try {
            return this.createSR(null, ReaderBootstrapper.getInstance(new InputStreamReader(in, enc), null, null, this.mConfig.getInputBufferLength(), enc));
        }
        catch (UnsupportedEncodingException ex) {
            throw new XMLStreamException(ex);
        }
    }

    public XMLStreamReader createXMLStreamReader(Reader r) throws XMLStreamException {
        return this.createXMLStreamReader(null, r);
    }

    public XMLStreamReader createXMLStreamReader(Source source) throws XMLStreamException {
        return this.createSR(source);
    }

    public XMLStreamReader createXMLStreamReader(String systemId, InputStream in) throws XMLStreamException {
        return this.createSR(systemId, StreamBootstrapper.getInstance(in, null, systemId, this.mConfig.getInputBufferLength()));
    }

    public XMLStreamReader createXMLStreamReader(String systemId, Reader r) throws XMLStreamException {
        return this.createSR(systemId, ReaderBootstrapper.getInstance(r, null, systemId, this.mConfig.getInputBufferLength(), null));
    }

    public Object getProperty(String name) {
        int id = this.mConfig.getPropertyId(name);
        if (id == 7) {
            throw new IllegalArgumentException("Event allocator not usable with J2ME subset.");
        }
        return this.mConfig.getProperty(id);
    }

    public XMLReporter getXMLReporter() {
        return this.mConfig.getXMLReporter();
    }

    public XMLResolver getXMLResolver() {
        return this.mConfig.getXMLResolver();
    }

    public boolean isPropertySupported(String name) {
        return this.mConfig.isPropertySupported(name);
    }

    public void setXMLReporter(XMLReporter r) {
        this.mConfig.setXMLReporter(r);
    }

    public void setXMLResolver(XMLResolver r) {
        this.mConfig.setXMLResolver(r);
    }

    public void setProperty(String propName, Object value) {
        int id = this.mConfig.getPropertyId(propName);
        if (id == 7) {
            throw new IllegalArgumentException("Event allocator not usable with J2ME subset.");
        }
        this.mConfig.setProperty(propName, id, value);
    }

    public ReaderConfig getConfig() {
        return this.mConfig;
    }

    protected XMLStreamReader doCreateSR(BranchingReaderSource input, ReaderConfig cfg, InputBootstrapper bs) throws IOException, XMLStreamException {
        return WstxStreamReader.createBasicStreamReader(input, this, cfg, bs);
    }

    private XMLStreamReader createSR(String systemId, InputBootstrapper bs) throws XMLStreamException {
        Reader r;
        URL src = this.mConfig.getBaseURL();
        if (src == null && systemId != null && systemId.length() > 0) {
            try {
                src = URLUtil.urlFromSystemId(systemId);
            }
            catch (IOException ie) {
                throw new WstxIOException(ie);
            }
        }
        try {
            r = bs.bootstrapInput(true, this.getXMLReporter());
        }
        catch (IOException ie) {
            throw new WstxIOException(ie);
        }
        ReaderConfig cfg = this.mConfig.createNonShared(this.mSymbols.makeChild());
        BranchingReaderSource input = InputSourceFactory.constructDocumentSource(bs, null, systemId, src, r, false, cfg.getInputBufferLength());
        try {
            return this.doCreateSR(input, cfg, bs);
        }
        catch (IOException ie) {
            throw new XMLStreamException(ie);
        }
    }

    private XMLStreamReader createSR(Source src) throws XMLStreamException {
        if (src instanceof StreamSource) {
            InputBootstrapper bs;
            StreamSource ss = (StreamSource)src;
            Reader r = ss.getReader();
            if (r == null) {
                InputStream in = ss.getInputStream();
                if (in == null) {
                    throw new XMLStreamException("Can not create StAX reader for a StreamSource -- neither reader nor input stream was set.");
                }
                bs = StreamBootstrapper.getInstance(in, ss.getPublicId(), ss.getSystemId(), this.mConfig.getInputBufferLength());
            } else {
                bs = ReaderBootstrapper.getInstance(r, ss.getPublicId(), ss.getSystemId(), this.mConfig.getInputBufferLength(), null);
            }
            return this.createSR(src.getSystemId(), bs);
        }
        if (src instanceof SAXSource) {
            SAXSource sr = (SAXSource)src;
            throw new XMLStreamException("Can not create a STaX reader for a SAXSource -- not (yet) implemented.");
        }
        if (src instanceof DOMSource) {
            DOMSource sr = (DOMSource)src;
            throw new XMLStreamException("Can not create a STaX reader for a DOMSource -- not (yet) implemented.");
        }
        throw new IllegalArgumentException("Can not instantiate StAX reader for XML source type " + src.getClass() + " (unknown type)");
    }

    private void throwUnsupported(String msg) {
        throw new IllegalArgumentException("MinimalInputFactory has no DTD support: can not call " + msg);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: java " + (class$com$ctc$wstx$stax$MinimalInputFactory == null ? (class$com$ctc$wstx$stax$MinimalInputFactory = MinimalInputFactory.class$("com.ctc.wstx.stax.MinimalInputFactory")) : class$com$ctc$wstx$stax$MinimalInputFactory) + " [input file]");
            System.exit(1);
        }
        MinimalInputFactory f = new MinimalInputFactory();
        System.out.println("Creating J2ME stream reader for file '" + args[0] + "'.");
        XMLStreamReader r = f.createXMLStreamReader(new FileInputStream(args[0]));
        r.close();
        System.out.println("Reader created and closed ok, exiting.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        mRootSymbols.setInternStrings(true);
    }
}

