/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.stax;

import com.ctc.wstx.api.WriterConfig;
import com.ctc.wstx.cfg.OutputConfigFlags;
import com.ctc.wstx.sw.BaseStreamWriter;
import com.ctc.wstx.sw.NonNsStreamWriter;
import com.ctc.wstx.sw.RepairingNsStreamWriter;
import com.ctc.wstx.sw.SimpleNsStreamWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;

public final class MinimalOutputFactory
implements OutputConfigFlags {
    protected final boolean mIsMinimal;
    protected final WriterConfig mConfig;

    protected MinimalOutputFactory(boolean isMinimal) {
        this.mIsMinimal = isMinimal;
        this.mConfig = WriterConfig.createJ2MEDefaults();
    }

    public static MinimalOutputFactory newMinimalInstance() {
        return new MinimalOutputFactory(true);
    }

    public XMLStreamWriter createXMLStreamWriter(OutputStream out) {
        return this.createXMLStreamWriter(new OutputStreamWriter(out));
    }

    public XMLStreamWriter createXMLStreamWriter(OutputStream out, String enc) throws XMLStreamException {
        try {
            return this.createXMLStreamWriter(new OutputStreamWriter(out, enc));
        }
        catch (UnsupportedEncodingException ex) {
            throw new XMLStreamException(ex);
        }
    }

    public XMLStreamWriter createXMLStreamWriter(Result result) throws XMLStreamException {
        return this.createWstxStreamWriter(result);
    }

    public XMLStreamWriter createXMLStreamWriter(Writer w) {
        return this.createWstxStreamWriter(w);
    }

    public Object getProperty(String name) {
        return this.mConfig.getProperty(name);
    }

    public boolean isPropertySupported(String name) {
        return this.mConfig.isPropertySupported(name);
    }

    public void setProperty(String name, Object value) {
        this.mConfig.setProperty(name, value);
    }

    public WriterConfig getConfig() {
        return this.mConfig;
    }

    private BaseStreamWriter createWstxStreamWriter(Writer w) {
        if (this.mConfig.willSupportNamespaces()) {
            if (this.mConfig.automaticNamespacesEnabled()) {
                return new RepairingNsStreamWriter(w, this.mConfig);
            }
            return new SimpleNsStreamWriter(w, this.mConfig);
        }
        return new NonNsStreamWriter(w, this.mConfig);
    }

    private BaseStreamWriter createWstxStreamWriter(Result res) throws XMLStreamException {
        if (res instanceof StreamResult) {
            StreamResult sr = (StreamResult)res;
            Writer w = sr.getWriter();
            if (w == null) {
                OutputStream out = sr.getOutputStream();
                if (out == null) {
                    throw new XMLStreamException("Can not create StAX writer for a StreamResult -- neither writer nor output stream was set.");
                }
                w = new OutputStreamWriter(out);
            }
            return this.createWstxStreamWriter(w);
        }
        if (res instanceof SAXResult) {
            SAXResult sr = (SAXResult)res;
            throw new XMLStreamException("Can not create a STaX writer for a SAXResult -- not (yet) implemented.");
        }
        if (res instanceof DOMResult) {
            DOMResult sr = (DOMResult)res;
            throw new XMLStreamException("Can not create a STaX writer for a DOMResult -- not (yet) implemented.");
        }
        throw new IllegalArgumentException("Can not instantiate a writer for XML result type " + res.getClass() + " (unknown type)");
    }
}

