/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.sw;

import com.ctc.wstx.api.WriterConfig;
import com.ctc.wstx.cfg.ErrorConsts;
import com.ctc.wstx.sw.BaseStreamWriter;
import com.ctc.wstx.sw.OutputElement;
import com.ctc.wstx.util.DefaultXmlSymbolTable;
import java.io.IOException;
import java.io.Writer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public abstract class BaseNsStreamWriter
extends BaseStreamWriter {
    protected static final String sPrefixXml = DefaultXmlSymbolTable.getXmlSymbol();
    protected static final String sPrefixXmlns = DefaultXmlSymbolTable.getXmlnsSymbol();
    protected static final String ERR_NSDECL_WRONG_STATE = "Trying to write a namespace declaration when there is no open start element.";
    protected final boolean mCheckNS;
    protected final boolean mCheckNSWrite;
    protected final boolean mAutomaticNS;
    protected static final OutputElement sSharedRootElem = OutputElement.getRootInstance();
    protected OutputElement mCurrElem = sSharedRootElem;
    protected OutputElement.Declarations mNsDecl = null;
    protected NamespaceContext mRootNsContext = null;

    public BaseNsStreamWriter(Writer w, WriterConfig cfg, boolean repairing) {
        super(w, cfg);
        this.mCheckNS = cfg.willValidateNamespaces();
        this.mCheckNSWrite = this.mCheckNS && !repairing;
        this.mAutomaticNS = repairing;
    }

    public NamespaceContext getNamespaceContext() {
        if (this.mNsDecl == null) {
            return this.mCurrElem;
        }
        return this.mNsDecl;
    }

    public String getPrefix(String uri) {
        if (this.mNsDecl != null) {
            return this.mNsDecl.getPrefix(uri);
        }
        return this.mCurrElem.getPrefix(uri);
    }

    public void setDefaultNamespace(String uri) throws XMLStreamException {
        if (this.mNsDecl == null) {
            this.mNsDecl = new OutputElement.Declarations(this.mCurrElem);
        }
        this.mNsDecl.setDefaultNsUri(uri);
    }

    public void setNamespaceContext(NamespaceContext context) {
        if (this.mState != 1) {
            throw new IllegalStateException("Called setNamespaceContext() after having already output root element.");
        }
        this.mRootNsContext = context;
    }

    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        if (prefix == null) {
            throw new NullPointerException("Can not pass null 'prefix' value");
        }
        if (prefix.length() == 0) {
            this.setDefaultNamespace(uri);
            return;
        }
        if (uri == null) {
            throw new NullPointerException("Can not pass null 'uri' value");
        }
        if (this.mCheckNS) {
            if (prefix.equals(sPrefixXml)) {
                if (!uri.equals("http://www.w3.org/XML/1998/namespace")) {
                    this.throwOutputError(ErrorConsts.ERR_NS_REDECL_XML, uri);
                }
            } else if (prefix.equals(sPrefixXmlns)) {
                if (!uri.equals("http://www.w3.org/2000/xmlns/")) {
                    this.throwOutputError(ErrorConsts.ERR_NS_REDECL_XMLNS, uri);
                }
            } else if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
                this.throwOutputError(ErrorConsts.ERR_NS_REDECL_XML_URI, prefix);
            } else if (uri.equals("http://www.w3.org/2000/xmlns/")) {
                this.throwOutputError(ErrorConsts.ERR_NS_REDECL_XMLNS_URI, prefix);
            }
            if (uri.length() == 0) {
                this.throwOutputError(ErrorConsts.ERR_NS_EMPTY);
            }
        }
        if (this.mNsDecl == null) {
            this.mNsDecl = new OutputElement.Declarations(this.mCurrElem);
        }
        this.mNsDecl.addNamespace(prefix, uri);
    }

    public void writeAttribute(String localName, String value) throws XMLStreamException {
        if (this.mCheckContent) {
            this.checkNameValidity(localName, false);
        }
        if (!this.mStartElementOpen) {
            throw new IllegalStateException("Trying to write an attribute when there is no open start element.");
        }
        this.doWriteAttr(localName, null, null, value);
    }

    public abstract void writeAttribute(String var1, String var2, String var3) throws XMLStreamException;

    public abstract void writeAttribute(String var1, String var2, String var3, String var4) throws XMLStreamException;

    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.checkStartElement(localName);
        this.mEmptyElement = true;
        this.mCurrElem = new OutputElement(this.mCurrElem, localName, this.mNsDecl, this.mCheckNS);
        this.doWriteStartElement(null, localName);
        this.mNsDecl = null;
    }

    public void writeEmptyElement(String nsURI, String localName) throws XMLStreamException {
        this.writeStartOrEmpty(localName, nsURI);
        this.mEmptyElement = true;
    }

    public void writeEmptyElement(String prefix, String localName, String nsURI) throws XMLStreamException {
        this.writeStartOrEmpty(prefix, localName, nsURI);
        this.mEmptyElement = true;
    }

    public void writeEndElement() throws XMLStreamException {
        this.doWriteEndElement(null, this.mCfgOutputEmptyElems);
    }

    public void writeStartElement(String localName) throws XMLStreamException {
        this.checkStartElement(localName);
        this.mEmptyElement = false;
        this.mCurrElem = new OutputElement(this.mCurrElem, localName, this.mNsDecl, this.mCheckNS);
        this.doWriteStartElement(null, localName);
        this.mNsDecl = null;
    }

    public void writeStartElement(String nsURI, String localName) throws XMLStreamException {
        this.writeStartOrEmpty(localName, nsURI);
        this.mEmptyElement = false;
    }

    public void writeStartElement(String prefix, String localName, String nsURI) throws XMLStreamException {
        this.writeStartOrEmpty(prefix, localName, nsURI);
        this.mEmptyElement = false;
    }

    public void writeFullEndElement() throws XMLStreamException {
        this.doWriteEndElement(null, false);
    }

    public String getTopElemName() {
        return this.mCurrElem.getElementName();
    }

    public void writeEndElement(QName name) throws XMLStreamException {
        this.doWriteEndElement(this.mCheckStructure ? name : null, this.mCfgOutputEmptyElems);
    }

    protected void closeStartElement(boolean emptyElem) throws XMLStreamException {
        this.mStartElementOpen = false;
        if (this.mCheckNSWrite) {
            this.mCurrElem.checkAllNsWrittenOk();
        }
        try {
            if (emptyElem) {
                this.mWriter.write(" />");
            } else {
                this.mWriter.write(62);
            }
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
        if (emptyElem) {
            this.mCurrElem = this.mCurrElem.getParent();
            if (this.mCurrElem.isRoot()) {
                this.mState = 3;
            }
        }
    }

    protected void checkStartElement(String localName) throws XMLStreamException {
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        } else if (this.mCheckStructure && this.mState == 3) {
            throw new IllegalStateException("Trying to output second root ('" + localName + "').");
        }
        if (this.mCheckContent) {
            this.checkNameValidity(localName, false);
        }
        if (this.mState == 1) {
            this.mState = 2;
        }
    }

    protected void doWriteAttr(String localName, String nsURI, String prefix, String value) throws XMLStreamException {
        if (this.mCheckAttr) {
            this.mCurrElem.checkAttrWrite(nsURI, localName, value);
        }
        try {
            this.mWriter.write(32);
            if (prefix != null && prefix.length() > 0) {
                this.mWriter.write(prefix);
                this.mWriter.write(58);
            }
            this.mWriter.write(localName);
            this.mWriter.write("=\"");
            this.mAttrValueWriter.write(value);
            this.mWriter.write(34);
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    protected void doWriteNamespace(String prefix, String nsURI) throws XMLStreamException {
        try {
            this.mWriter.write(32);
            this.mWriter.write("xmlns");
            if (prefix != null) {
                this.mWriter.write(58);
                this.mWriter.write(prefix);
            }
            this.mWriter.write("=\"");
            if (nsURI != null && nsURI.length() > 0) {
                this.mWriter.write(nsURI);
            }
            this.mWriter.write(34);
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    protected void doWriteEndElement(QName expName, boolean allowEmpty) throws XMLStreamException {
        if (this.mStartElementOpen && this.mEmptyElement) {
            this.mEmptyElement = false;
            this.closeStartElement(true);
        }
        if (this.mState != 2) {
            this.throwOutputError("No open start element, when trying to write end element");
        }
        String prefix = this.mCurrElem.getPrefix();
        String localName = this.mCurrElem.getLocalName();
        this.mCurrElem = this.mCurrElem.getParent();
        if (expName != null && !localName.equals(expName.getLocalPart())) {
            throw new IllegalArgumentException("Mismatching close element local name, '" + localName + "'; expected '" + expName.getLocalPart() + "'.");
        }
        if (this.mStartElementOpen) {
            this.mStartElementOpen = false;
            if (this.mCheckNSWrite) {
                this.mCurrElem.checkAllNsWrittenOk();
            }
            try {
                if (allowEmpty) {
                    this.mWriter.write(" />");
                    if (this.mCurrElem.isRoot()) {
                        this.mState = 3;
                    }
                    return;
                }
                this.mWriter.write(62);
            }
            catch (IOException ioe) {
                throw new XMLStreamException(ioe);
            }
        }
        try {
            this.mWriter.write("</");
            if (prefix != null && prefix.length() > 0) {
                this.mWriter.write(prefix);
                this.mWriter.write(58);
            }
            this.mWriter.write(localName);
            this.mWriter.write(62);
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
        if (this.mCurrElem.isRoot()) {
            this.mState = 3;
        }
    }

    protected void doWriteStartElement(String prefix, String localName) throws XMLStreamException {
        this.mAnyOutput = true;
        this.mStartElementOpen = true;
        try {
            this.mWriter.write(60);
            if (prefix != null && prefix.length() > 0) {
                this.mWriter.write(prefix);
                this.mWriter.write(58);
            }
            this.mWriter.write(localName);
            if (this.mAutomaticNS) {
                this.mCurrElem.outputDeclaredNamespaces(this.mWriter);
            }
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    public abstract void writeDefaultNamespace(String var1) throws XMLStreamException;

    public abstract void writeNamespace(String var1, String var2) throws XMLStreamException;

    public abstract void writeStartElement(StartElement var1) throws XMLStreamException;

    protected abstract void writeStartOrEmpty(String var1, String var2) throws XMLStreamException;

    protected abstract void writeStartOrEmpty(String var1, String var2, String var3) throws XMLStreamException;
}

