/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.sw;

import com.ctc.wstx.api.WriterConfig;
import com.ctc.wstx.sr.AttributeCollector;
import com.ctc.wstx.sr.InputElementStack;
import com.ctc.wstx.sw.BaseNsStreamWriter;
import com.ctc.wstx.sw.OutputElement;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;

public class RepairingNsStreamWriter
extends BaseNsStreamWriter {
    final String mAutomaticNsPrefix;

    public RepairingNsStreamWriter(Writer w, WriterConfig cfg) {
        super(w, cfg, true);
        this.mAutomaticNsPrefix = cfg.getAutomaticNsPrefix();
    }

    public void writeAttribute(String nsURI, String localName, String value) throws XMLStreamException {
        if (!this.mStartElementOpen) {
            throw new IllegalStateException("Trying to write an attribute when there is no open start element.");
        }
        String prefix = this.findOrCreatePrefix(nsURI, false);
        this.doWriteAttr(localName, nsURI, prefix, value);
    }

    public void writeAttribute(String prefix, String nsURI, String localName, String value) throws XMLStreamException {
        if (!this.mStartElementOpen) {
            throw new IllegalStateException("Trying to write an attribute when there is no open start element.");
        }
        prefix = this.validatePrefix(prefix, nsURI, false);
        this.doWriteAttr(localName, nsURI, prefix, value);
    }

    public void writeDefaultNamespace(String nsURI) throws XMLStreamException {
        if (!this.mStartElementOpen) {
            throw new IllegalStateException("Trying to write a namespace declaration when there is no open start element.");
        }
        if (this.mCheckNS) {
            this.mCurrElem.checkDefaultNsWrite(nsURI);
        }
    }

    public void writeNamespace(String prefix, String nsURI) throws XMLStreamException {
        if (!this.mStartElementOpen) {
            throw new IllegalStateException("Trying to write a namespace declaration when there is no open start element.");
        }
        if (this.mCheckNS) {
            this.mCurrElem.checkNsWrite(this.mRootNsContext, prefix, nsURI);
        }
    }

    public void writeStartElement(StartElement elem) throws XMLStreamException {
        String prefix;
        QName name = elem.getName();
        Iterator<Attribute> it = elem.getNamespaces();
        while (it.hasNext()) {
            Namespace ns = it.next();
            prefix = ns.getPrefix();
            if (prefix == null || prefix.length() == 0) {
                this.setDefaultNamespace(ns.getNamespaceURI());
                continue;
            }
            this.setPrefix(prefix, ns.getNamespaceURI());
        }
        String nsURI = name.getNamespaceURI();
        if (nsURI == null) {
            this.writeStartElement(name.getLocalPart());
        } else {
            prefix = name.getPrefix();
            if (prefix == null || prefix.length() == 0) {
                this.writeStartElement(nsURI, name.getLocalPart());
            }
        }
        it = elem.getNamespaces();
        while (it.hasNext()) {
            Namespace ns = it.next();
            String prefix2 = ns.getPrefix();
            if (prefix2 == null || prefix2.length() == 0) continue;
            this.doWriteNamespace(prefix2, ns.getNamespaceURI());
        }
        it = elem.getAttributes();
        while (it.hasNext()) {
            Attribute attr = it.next();
            name = attr.getName();
            this.writeAttribute(name.getLocalPart(), attr.getValue());
        }
    }

    protected void writeStartOrEmpty(String localName, String nsURI) throws XMLStreamException {
        this.checkStartElement(localName);
        this.mCurrElem = new OutputElement(this.mCurrElem, localName, this.mNsDecl, this.mCheckNS);
        String prefix = this.findOrCreatePrefix(nsURI, true);
        this.mCurrElem.setPrefix(prefix);
        this.doWriteStartElement(prefix, localName);
        this.mNsDecl = null;
    }

    protected void writeStartOrEmpty(String prefix, String localName, String nsURI) throws XMLStreamException {
        this.checkStartElement(localName);
        this.mCurrElem = new OutputElement(this.mCurrElem, localName, this.mNsDecl, this.mCheckNS);
        this.mNsDecl = null;
        prefix = this.validatePrefix(prefix, nsURI, true);
        this.mCurrElem.setPrefix(prefix);
        this.doWriteStartElement(prefix, localName);
    }

    public final void copyStartElement(InputElementStack elemStack, AttributeCollector attrCollector) throws IOException, XMLStreamException {
        this.writeStartElement(elemStack.getPrefix(), elemStack.getLocalName(), elemStack.getNsURI());
        int nsCount = elemStack.getCurrentNsCount();
        AttributeCollector ac = this.mAttrCollector;
        int attrCount = ac.getSpecifiedCount();
        for (int i = 0; i < attrCount; ++i) {
            String uri = attrCollector.getNsURI(i);
            String prefix = attrCollector.getPrefix(i);
            if (prefix != null) {
                prefix = prefix.length() == 0 ? null : this.validatePrefix(prefix, uri, false);
            }
            this.mWriter.write(32);
            if (prefix != null) {
                this.mWriter.write(prefix);
                this.mWriter.write(58);
            }
            this.mWriter.write(attrCollector.getLocalName(i));
            this.mWriter.write(61);
            this.mWriter.write(34);
            attrCollector.writeValue(i, this.mAttrValueWriter);
            this.mWriter.write(34);
        }
    }

    protected final String findOrCreatePrefix(String nsURI, boolean isElement) throws XMLStreamException {
        if (nsURI == null || nsURI.length() == 0) {
            String currURL;
            if (isElement && (currURL = this.mCurrElem.getDefaultNsUri()) != null && currURL.length() > 0) {
                this.mCurrElem.setDefaultNs(currURL);
            }
            return null;
        }
        String prefix = this.mCurrElem.findPrefix(nsURI, isElement);
        if (prefix != null) {
            return prefix;
        }
        if (this.mRootNsContext != null) {
            prefix = this.mRootNsContext.getPrefix(nsURI);
            if (prefix == null || prefix.length() == 0) {
                prefix = this.mCurrElem.generatePrefix(this.mRootNsContext, this.mAutomaticNsPrefix);
            }
        } else {
            prefix = this.mCurrElem.generatePrefix(this.mRootNsContext, this.mAutomaticNsPrefix);
        }
        this.mCurrElem.addPrefix(prefix, nsURI);
        if (!isElement) {
            this.doWriteNamespace(prefix, nsURI);
        }
        return prefix;
    }

    private final String validatePrefix(String prefix, String nsURI, boolean isElement) throws XMLStreamException {
        if (nsURI.length() == 0) {
            String currURL;
            if (isElement && (currURL = this.mCurrElem.getDefaultNsUri()) != null && currURL.length() > 0) {
                this.mCurrElem.setDefaultNs(currURL);
            }
            return null;
        }
        int status = this.mCurrElem.isPrefixValid(prefix, nsURI, this.mCheckNS, isElement);
        if (status == 1) {
            return prefix;
        }
        if (status == 0) {
            this.mCurrElem.addPrefix(prefix, nsURI);
            if (!isElement) {
                this.doWriteNamespace(prefix, nsURI);
            }
        } else {
            prefix = this.getPrefix(nsURI);
            if (prefix == null) {
                prefix = this.mCurrElem.generatePrefix(this.mRootNsContext, this.mAutomaticNsPrefix);
                this.mCurrElem.addPrefix(prefix, nsURI);
                if (!isElement) {
                    this.doWriteNamespace(prefix, nsURI);
                }
            }
        }
        return prefix;
    }
}

