/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.sw;

import com.ctc.wstx.api.WriterConfig;
import com.ctc.wstx.cfg.ErrorConsts;
import com.ctc.wstx.sr.AttributeCollector;
import com.ctc.wstx.sr.InputElementStack;
import com.ctc.wstx.sw.BaseNsStreamWriter;
import com.ctc.wstx.sw.OutputElement;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;

public class SimpleNsStreamWriter
extends BaseNsStreamWriter {
    public SimpleNsStreamWriter(Writer w, WriterConfig cfg) {
        super(w, cfg, false);
    }

    public void writeAttribute(String nsURI, String localName, String value) throws XMLStreamException {
        if (!this.mStartElementOpen) {
            throw new IllegalStateException("Trying to write an attribute when there is no open start element.");
        }
        String prefix = this.findPrefix(nsURI, false);
        this.doWriteAttr(localName, nsURI, prefix, value);
    }

    public void writeAttribute(String prefix, String nsURI, String localName, String value) throws XMLStreamException {
        if (!this.mStartElementOpen) {
            throw new IllegalStateException("Trying to write an attribute when there is no open start element.");
        }
        if (this.mCheckNS) {
            this.checkNsDecl(prefix, nsURI);
        }
        this.doWriteAttr(localName, nsURI, prefix, value);
    }

    public void writeDefaultNamespace(String nsURI) throws XMLStreamException {
        if (!this.mStartElementOpen) {
            throw new IllegalStateException("Trying to write a namespace declaration when there is no open start element.");
        }
        if (this.mCheckNS) {
            this.mCurrElem.checkDefaultNsWrite(nsURI);
        }
        try {
            this.mWriter.write(32);
            this.mWriter.write("xmlns");
            this.mWriter.write("=\"");
            this.mWriter.write(nsURI);
            this.mWriter.write(34);
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    public void writeNamespace(String prefix, String nsURI) throws XMLStreamException {
        if (prefix == null || prefix.length() == 0 || prefix.equals("xmlns")) {
            this.writeDefaultNamespace(nsURI);
            return;
        }
        if (!this.mStartElementOpen) {
            throw new IllegalStateException("Trying to write a namespace declaration when there is no open start element.");
        }
        if (this.mCheckNS) {
            if (nsURI.length() == 0) {
                this.throwOutputError(ErrorConsts.ERR_NS_EMPTY);
            }
            this.mCurrElem.checkNsWrite(this.mRootNsContext, prefix, nsURI);
        }
        this.doWriteNamespace(prefix, nsURI);
    }

    public void writeStartElement(StartElement elem) throws XMLStreamException {
        String prefix;
        QName name = elem.getName();
        Iterator<Attribute> it = elem.getNamespaces();
        while (it.hasNext()) {
            Namespace ns = it.next();
            prefix = ns.getPrefix();
            if (prefix == null || prefix.length() == 0) {
                this.setDefaultNamespace(ns.getNamespaceURI());
                continue;
            }
            this.setPrefix(prefix, ns.getNamespaceURI());
        }
        String nsURI = name.getNamespaceURI();
        if (nsURI == null) {
            this.writeStartElement(name.getLocalPart());
        } else {
            prefix = name.getPrefix();
            this.writeStartElement(prefix, name.getLocalPart(), nsURI);
        }
        it = elem.getNamespaces();
        while (it.hasNext()) {
            Namespace ns = it.next();
            String prefix2 = ns.getPrefix();
            if (prefix2 == null || prefix2.length() == 0) {
                this.writeDefaultNamespace(ns.getNamespaceURI());
                continue;
            }
            this.writeNamespace(prefix2, ns.getNamespaceURI());
        }
        it = elem.getAttributes();
        while (it.hasNext()) {
            Attribute attr = it.next();
            name = attr.getName();
            this.writeAttribute(name.getLocalPart(), attr.getValue());
        }
    }

    protected void writeStartOrEmpty(String localName, String nsURI) throws XMLStreamException {
        this.checkStartElement(localName);
        this.mCurrElem = new OutputElement(this.mCurrElem, localName, this.mNsDecl, this.mCheckNS);
        String prefix = this.findPrefix(nsURI, true);
        this.mCurrElem.setPrefix(prefix);
        this.doWriteStartElement(prefix, localName);
        this.mNsDecl = null;
    }

    protected void writeStartOrEmpty(String prefix, String localName, String nsURI) throws XMLStreamException {
        this.checkStartElement(localName);
        this.mCurrElem = new OutputElement(this.mCurrElem, localName, this.mNsDecl, this.mCheckNS);
        this.mNsDecl = null;
        if (this.mCheckNS) {
            this.checkNsDecl(prefix, nsURI);
        }
        this.mCurrElem.setPrefix(prefix);
        this.doWriteStartElement(prefix, localName);
    }

    public final void copyStartElement(InputElementStack elemStack, AttributeCollector attrCollector) throws IOException, XMLStreamException {
        String uri;
        String prefix;
        int i;
        int nsCount = elemStack.getCurrentNsCount();
        if (nsCount > 0) {
            for (i = 0; i < nsCount; ++i) {
                prefix = elemStack.getLocalNsPrefix(i);
                uri = elemStack.getLocalNsURI(i);
                if (prefix == null || prefix.length() == 0) {
                    this.setDefaultNamespace(uri);
                    continue;
                }
                this.setPrefix(prefix, uri);
            }
        }
        this.writeStartElement(elemStack.getPrefix(), elemStack.getLocalName(), elemStack.getNsURI());
        if (nsCount > 0) {
            for (i = 0; i < nsCount; ++i) {
                prefix = elemStack.getLocalNsPrefix(i);
                uri = elemStack.getLocalNsURI(i);
                if (prefix == null || prefix.length() == 0) {
                    this.writeDefaultNamespace(uri);
                    continue;
                }
                this.writeNamespace(prefix, uri);
            }
        }
        AttributeCollector ac = this.mAttrCollector;
        int attrCount = ac.getSpecifiedCount();
        for (int i2 = 0; i2 < attrCount; ++i2) {
            this.mWriter.write(32);
            attrCollector.writeAttribute(i2, '\"', this.mWriter, this.mAttrValueWriter);
        }
    }

    private final String findPrefix(String nsURI, boolean canUseDefault) throws XMLStreamException {
        String prefix = this.mCurrElem.findPrefix(nsURI, canUseDefault);
        if (prefix == null) {
            if (this.mRootNsContext != null && (prefix = this.mRootNsContext.getPrefix(nsURI)) != null && prefix.length() > 0) {
                this.mCurrElem.addPrefix(prefix, nsURI);
            }
            throw new XMLStreamException("Unbound namespace prefix '" + prefix + "'");
        }
        return prefix;
    }

    private final void checkNsDecl(String prefix, String nsURI) throws XMLStreamException {
        int status = this.mCurrElem.isPrefixValid(prefix, nsURI, true, false);
        if (status != 1) {
            if (status == 0) {
                throw new XMLStreamException("Unbound namespace prefix '" + prefix + "'");
            }
            String actURI = this.mCurrElem.getNamespaceURI(prefix);
            throw new XMLStreamException("Misbound namespace prefix '" + prefix + "': was declared as '" + actURI + "', trying to use it as '" + nsURI + "'");
        }
    }
}

