/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.evt;

import com.ctc.wstx.api.WriterConfig;
import com.ctc.wstx.cfg.OutputConfigFlags;
import com.ctc.wstx.sw.BaseStreamWriter;
import com.ctc.wstx.sw.NonNsStreamWriter;
import com.ctc.wstx.sw.RepairingNsStreamWriter;
import com.ctc.wstx.sw.SimpleNsStreamWriter;
import java.io.Writer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.XMLEvent;

public class WstxEventWriter
implements XMLEventWriter,
XMLStreamConstants,
OutputConfigFlags {
    final BaseStreamWriter mWriter;

    public WstxEventWriter(Writer w, WriterConfig cfg) {
        this.mWriter = cfg.willSupportNamespaces() ? (cfg.automaticNamespacesEnabled() ? new RepairingNsStreamWriter(w, cfg) : new SimpleNsStreamWriter(w, cfg)) : new NonNsStreamWriter(w, cfg);
    }

    public WstxEventWriter(BaseStreamWriter sw, WriterConfig cfg) {
        this.mWriter = sw;
    }

    public void add(XMLEvent event) throws XMLStreamException {
        switch (event.getEventType()) {
            case 10: {
                Attribute attr = (Attribute)event;
                QName name = attr.getName();
                this.mWriter.writeAttribute(name.getPrefix(), name.getNamespaceURI(), name.getLocalPart(), attr.getValue());
                break;
            }
            case 8: {
                this.mWriter.writeEndDocument();
                break;
            }
            case 2: {
                this.mWriter.writeEndElement(event.asEndElement().getName());
                break;
            }
            case 13: {
                Namespace ns = (Namespace)event;
                this.mWriter.writeNamespace(ns.getPrefix(), ns.getNamespaceURI());
                break;
            }
            case 7: {
                StartDocument sd = (StartDocument)event;
                if (sd.encodingSet()) {
                    this.mWriter.writeStartDocument(sd.getVersion());
                    break;
                }
                this.mWriter.writeStartDocument(sd.getCharacterEncodingScheme(), sd.getVersion());
                break;
            }
            case 1: {
                this.mWriter.writeStartElement(event.asStartElement());
                break;
            }
            case 4: {
                Characters ch = event.asCharacters();
                String text = ch.getData();
                if (ch.isCData()) {
                    this.mWriter.writeCData(text);
                    break;
                }
                this.mWriter.writeCharacters(text);
                break;
            }
            case 5: {
                this.mWriter.writeComment(((Comment)event).getText());
                break;
            }
            case 11: {
                this.mWriter.writeDTD(((DTD)event).getDocumentTypeDeclaration());
                break;
            }
            case 9: {
                this.mWriter.writeEntityRef(((EntityReference)event).getName());
                break;
            }
            case 3: {
                ProcessingInstruction pi = (ProcessingInstruction)event;
                this.mWriter.writeProcessingInstruction(pi.getTarget(), pi.getData());
                break;
            }
            default: {
                event.writeAsEncodedUnicode(this.mWriter.getWriter());
            }
        }
    }

    public void add(XMLEventReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            this.add(reader.nextEvent());
        }
    }

    public void close() throws XMLStreamException {
        this.mWriter.close();
    }

    public void flush() throws XMLStreamException {
        this.mWriter.flush();
    }

    public NamespaceContext getNamespaceContext() {
        return this.mWriter.getNamespaceContext();
    }

    public String getPrefix(String uri) {
        return this.mWriter.getPrefix(uri);
    }

    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.mWriter.setDefaultNamespace(uri);
    }

    public void setNamespaceContext(NamespaceContext ctxt) {
        this.mWriter.setNamespaceContext(ctxt);
    }

    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.mWriter.setPrefix(prefix, uri);
    }
}

