/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.io;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class TextEscapingWriter
extends FilterWriter {
    private boolean mJustWroteBracket = false;

    public TextEscapingWriter(Writer out) {
        super(out);
    }

    public void write(int c) throws IOException {
        if (c == 60) {
            this.out.write("&lt;");
        } else if (c == 38) {
            this.out.write("&amp;");
        } else if (c == 62) {
            if (this.mJustWroteBracket) {
                this.out.write("&gt;");
            } else {
                this.out.write(c);
            }
        } else {
            if (c == 93) {
                this.out.write(c);
                this.mJustWroteBracket = true;
                return;
            }
            this.out.write(c);
        }
        this.mJustWroteBracket = false;
    }

    public void write(char[] cbuf, int offset, int len) throws IOException {
        char c;
        if (len < 2) {
            if (len == 1) {
                this.write(cbuf[offset]);
            }
            return;
        }
        len += offset;
        if (this.mJustWroteBracket && (c = cbuf[offset]) == '>') {
            this.out.write("&gt;");
            ++offset;
        }
        c = '\u0000';
        do {
            int start = offset;
            while (offset < len && (c = cbuf[offset]) != '<' && c != '&' && (c != '>' || cbuf[offset - 1] != ']')) {
                ++offset;
            }
            int outLen = offset - start;
            if (outLen > 0) {
                this.out.write(cbuf, start, outLen);
            }
            if (offset >= len) continue;
            if (c == '<') {
                this.out.write("&lt;");
                continue;
            }
            if (c == '&') {
                this.out.write("&amp;");
                continue;
            }
            if (c != '>') continue;
            this.out.write("&gt;");
        } while (++offset < len);
        this.mJustWroteBracket = c == ']';
    }

    public void write(String str, int offset, int len) throws IOException {
        char c;
        if (len < 2) {
            if (len == 1) {
                this.write(str.charAt(offset));
            }
            return;
        }
        len += offset;
        if (this.mJustWroteBracket && (c = str.charAt(offset)) == '>') {
            this.out.write("&gt;");
            ++offset;
        }
        c = '\u0000';
        do {
            int start = offset;
            while (offset < len && (c = str.charAt(offset)) != '<' && c != '&' && (c != '>' || str.charAt(offset - 1) != ']')) {
                ++offset;
            }
            int outLen = offset - start;
            if (outLen > 0) {
                this.out.write(str, start, outLen);
            }
            if (offset >= len) continue;
            if (c == '<') {
                this.out.write("&lt;");
                continue;
            }
            if (c == '&') {
                this.out.write("&amp;");
                continue;
            }
            if (c != '>') continue;
            this.out.write("&gt;");
        } while (++offset < len);
        this.mJustWroteBracket = c == ']';
    }

    public static void writeEscapedXMLText(Writer w, String text) throws IOException {
        int len = text.length();
        if (len < 2) {
            if (len == 1) {
                char c = text.charAt(0);
                if (c == '<') {
                    w.write("&lt;");
                } else if (c == '&') {
                    w.write("&amp;");
                } else {
                    w.write(text.charAt(0));
                }
            }
            return;
        }
        for (int i = 0; i < len; ++i) {
            int start = i;
            char c = '\u0000';
            while (i < len && (c = text.charAt(i)) != '<' && c != '&' && (c != '>' || i < 2 || text.charAt(i - 1) != ']' || text.charAt(i - 2) != ']')) {
                ++i;
            }
            int outLen = i - start;
            if (outLen > 0) {
                w.write(text, start, outLen);
            }
            if (i >= len) continue;
            if (c == '<') {
                w.write("&lt;");
                continue;
            }
            if (c == '&') {
                w.write("&amp;");
                continue;
            }
            if (c != '>') continue;
            w.write("&gt;");
        }
    }
}

