/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.io;

import com.ctc.wstx.io.BaseReader;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;

public final class UTF8Reader
extends BaseReader {
    static final char NULL_CHAR = '\u0000';
    static final char NULL_BYTE = '\u0000';
    char mSurrogate = '\u0000';
    int mCharCount = 0;
    int mByteCount = 0;

    public UTF8Reader(InputStream in, byte[] buf, int ptr, int len) {
        super(in, buf, ptr, len);
    }

    public int read(char[] cbuf, int start, int len) throws IOException {
        if (this.mBuffer == null) {
            return -1;
        }
        if (len < 1) {
            return len;
        }
        if (start < 0 || start + len > cbuf.length) {
            this.reportBounds(cbuf, start, len);
        }
        len += start;
        int outPtr = start;
        if (this.mSurrogate != '\u0000') {
            cbuf[outPtr++] = this.mSurrogate;
            this.mSurrogate = '\u0000';
        } else {
            int left = this.mLength - this.mPtr;
            if (!(left >= 4 || left >= 1 && this.mBuffer[this.mPtr] >= 0 || this.loadMore(left))) {
                return -1;
            }
        }
        byte[] buf = this.mBuffer;
        block0: while (outPtr < len) {
            byte d;
            int needed;
            int b = buf[this.mPtr++];
            while (b >= 0) {
                cbuf[outPtr] = (char)b;
                if (++outPtr >= len || this.mPtr >= this.mLength) break block0;
                b = buf[this.mPtr++];
            }
            int c = b;
            if ((c & 0xE0) == 192) {
                c = b & 0x1F;
                needed = 1;
            } else if ((c & 0xF0) == 224) {
                c = b & 0xF;
                needed = 2;
            } else if ((c & 0xF8) == 240) {
                c = b & 0xF;
                needed = 3;
            } else {
                this.reportInvalidInitial(c & 0xFF, outPtr - start);
                needed = 1;
            }
            if (this.mLength - this.mPtr < needed) {
                --this.mPtr;
                break;
            }
            if (((d = buf[this.mPtr++]) & 0xC0) != 128) {
                this.reportInvalidOther(d & 0xFF, outPtr - start);
            }
            c = c << 6 | d & 0x3F;
            if (needed > 1) {
                if (((d = buf[this.mPtr++]) & 0xC0) != 128) {
                    this.reportInvalidOther(d & 0xFF, outPtr - start);
                }
                c = c << 6 | d & 0x3F;
                if (needed > 2) {
                    if (((d = buf[this.mPtr++]) & 0xC0) != 128) {
                        this.reportInvalidOther(d & 0xFF, outPtr - start);
                    }
                    c = c << 6 | d & 0x3F;
                    if (needed > 3) {
                        if (((d = buf[this.mPtr++]) & 0xC0) != 128) {
                            this.reportInvalidOther(d & 0xFF, outPtr - start);
                        }
                        c = c << 6 | d & 0x3F;
                        cbuf[outPtr++] = (char)(55296 + ((c -= 65536) >> 10));
                        c = 0xDC00 | c & 0x3FF;
                        if (outPtr >= len) {
                            this.mSurrogate = (char)c;
                            break;
                        }
                    }
                }
            }
            cbuf[outPtr++] = (char)c;
            if (this.mPtr < this.mLength) continue;
            break;
        }
        len = outPtr - start;
        this.mCharCount += len;
        return len;
    }

    private void reportInvalidInitial(int mask, int offset) throws IOException {
        int bytePos = this.mByteCount + this.mPtr - 1;
        int charPos = this.mCharCount + offset + 1;
        throw new CharConversionException("Invalid UTF-8 start byte 0x" + Integer.toHexString(mask) + " (at char #" + charPos + ", byte #" + bytePos + ")");
    }

    private void reportInvalidOther(int mask, int offset) throws IOException {
        int bytePos = this.mByteCount + this.mPtr - 1;
        int charPos = this.mCharCount + offset;
        throw new CharConversionException("Invalid UTF-8 middle byte 0x" + Integer.toHexString(mask) + " (at char #" + charPos + ", byte #" + bytePos + ")");
    }

    private void reportUnexpectedEOF(int gotBytes, int needed) throws IOException {
        int bytePos = this.mByteCount + gotBytes;
        int charPos = this.mCharCount;
        throw new CharConversionException("Unexpected EOF in the middle of a multi-byte char: got " + gotBytes + ", needed " + needed + ", at char #" + charPos + ", byte #" + bytePos + ")");
    }

    private boolean loadMore(int available) throws IOException {
        int needed;
        this.mByteCount += this.mLength - available;
        if (available > 0) {
            if (this.mPtr > 0) {
                for (int i = 0; i < available; ++i) {
                    this.mBuffer[i] = this.mBuffer[this.mPtr + i];
                }
                this.mPtr = 0;
            }
            this.mLength = available;
        } else {
            this.mPtr = 0;
            int count = this.mIn.read(this.mBuffer);
            if (count < 1) {
                this.mLength = 0;
                if (count < 0) {
                    this.mBuffer = null;
                    return false;
                }
                this.reportStrangeStream();
            }
            this.mLength = count;
        }
        byte c = this.mBuffer[0];
        if (c >= 0) {
            return true;
        }
        if ((c & 0xE0) == 192) {
            needed = 2;
        } else if ((c & 0xF0) == 224) {
            needed = 3;
        } else if ((c & 0xF8) == 240) {
            needed = 4;
        } else {
            this.reportInvalidInitial(c & 0xFF, 0);
            needed = 1;
        }
        while (this.mLength < needed) {
            int count = this.mIn.read(this.mBuffer, this.mLength, this.mBuffer.length - this.mLength);
            if (count < 1) {
                if (count < 0) {
                    this.mBuffer = null;
                    this.reportUnexpectedEOF(this.mLength, needed);
                }
                this.reportStrangeStream();
            }
            this.mLength += count;
        }
        return true;
    }
}

