/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.sr;

import com.ctc.wstx.cfg.ErrorConsts;
import com.ctc.wstx.exc.WstxException;
import com.ctc.wstx.sr.AttributeCollector;
import com.ctc.wstx.sr.CompactNsContext;
import com.ctc.wstx.sr.InputElementStack;
import com.ctc.wstx.sr.NsAttributeCollector;
import com.ctc.wstx.util.BaseNsContext;
import com.ctc.wstx.util.EmptyIterator;
import com.ctc.wstx.util.InternCache;
import com.ctc.wstx.util.SingletonIterator;
import com.ctc.wstx.util.StringVector;
import com.ctc.wstx.util.TextBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;

public class NsInputElementStack
extends InputElementStack {
    static final String DEFAULT_NAMESPACE_URI = "";
    static final int IX_PREFIX = 0;
    static final int IX_LOCALNAME = 1;
    static final int IX_URI = 2;
    static final int IX_DEFAULT_NS = 3;
    static final int ENTRY_SIZE = 4;
    protected final String mPrefixXml;
    protected final String mPrefixXmlns;
    static final InternCache sInternCache = InternCache.getInstance();
    protected final NsAttributeCollector mAttrCollector;
    protected final StringVector mNamespaces = new StringVector(64);
    protected String[] mElements;
    protected int mSize;
    protected int[] mNsCounts;
    protected String mLastLocalName = null;
    protected String mLastPrefix = null;
    protected String mLastNsURI = null;
    protected QName mLastName = null;

    public NsInputElementStack(int initialSize, String prefixXml, String prefixXmlns, boolean normAttrs) {
        this.mPrefixXml = prefixXml;
        this.mPrefixXmlns = prefixXmlns;
        this.mSize = 0;
        if (initialSize < 4) {
            initialSize = 4;
        }
        this.mElements = new String[initialSize << 2];
        this.mNsCounts = new int[initialSize];
        this.mAttrCollector = new NsAttributeCollector(normAttrs, prefixXml, prefixXmlns);
    }

    public final void push(String prefix, String localName) {
        Object[] old;
        int index = this.mSize;
        if (index == this.mElements.length) {
            old = this.mElements;
            this.mElements = new String[old.length + 64];
            System.arraycopy(old, 0, this.mElements, 0, old.length);
        }
        this.mElements[index] = prefix;
        this.mElements[index + 1] = localName;
        if (index == 0) {
            this.mElements[3] = DEFAULT_NAMESPACE_URI;
        } else {
            this.mElements[index + 3] = this.mElements[index - 1];
        }
        this.mSize = index + 4;
        if ((index >>= 2) == this.mNsCounts.length) {
            old = this.mNsCounts;
            this.mNsCounts = new int[old.length + 16];
            System.arraycopy(old, 0, this.mNsCounts, 0, old.length);
        }
        this.mNsCounts[index] = this.mNamespaces.size();
        this.mAttrCollector.reset();
    }

    public final void push(String fullName) {
        throw new Error("Internal error: push(fullName) shouldn't be called for namespace aware element stack.");
    }

    public int pop() throws WstxException {
        int index = this.mSize;
        if (index == 0) {
            throw new IllegalStateException("Popping from empty stack.");
        }
        this.mSize = index -= 4;
        this.mElements[index] = null;
        this.mElements[index + 1] = null;
        this.mElements[index + 2] = null;
        this.mElements[index + 3] = null;
        int nsCount = this.mNamespaces.size() - this.mNsCounts[index >>= 2];
        if (nsCount > 0) {
            this.mNamespaces.removeLast(nsCount);
        }
        return 3;
    }

    public int resolveElem(boolean internNsURIs) throws WstxException {
        String prefix;
        if (this.mSize == 0) {
            throw new IllegalStateException("Calling validate() on empty stack.");
        }
        NsAttributeCollector ac = this.mAttrCollector;
        int nsCount = ac.getNsCount();
        if (nsCount > 0) {
            String[] nsPrefixes = ac.getNsPrefixes();
            TextBuilder nsURIs = ac.getNsURIs();
            for (int i = 0; i < nsCount; ++i) {
                String prefix2;
                String nsUri = nsURIs.getEntry(i);
                if (internNsURIs && nsUri.length() > 0) {
                    nsUri = sInternCache.intern(nsUri);
                }
                if ((prefix2 = nsPrefixes[i]) == null) {
                    prefix2 = DEFAULT_NAMESPACE_URI;
                    this.mElements[this.mSize - 1] = nsUri;
                } else if (prefix2 == this.mPrefixXml) {
                    if (!nsUri.equals("http://www.w3.org/XML/1998/namespace")) {
                        this.mReporter.throwParseError(ErrorConsts.ERR_NS_REDECL_XML, (Object)nsUri);
                    }
                } else if (prefix2 == this.mPrefixXmlns && !nsUri.equals("http://www.w3.org/2000/xmlns/")) {
                    this.mReporter.throwParseError(ErrorConsts.ERR_NS_REDECL_XMLNS, (Object)nsUri);
                }
                this.mNamespaces.addStrings(prefix2, nsUri);
            }
        }
        if ((prefix = this.mElements[this.mSize - 4]) == null || prefix.length() == 0) {
            this.mElements[this.mSize - 2] = this.mElements[this.mSize - 1];
        } else {
            String ns = this.mNamespaces.findLastFromMap(prefix);
            if (ns == null) {
                this.mReporter.throwParseError("Undeclared namespace prefix '" + prefix + "'.");
            }
            this.mElements[this.mSize - 2] = ns;
        }
        ac.resolveNamespaces(this.mReporter, this.mNamespaces);
        return 3;
    }

    public final boolean isNamespaceAware() {
        return true;
    }

    public final int getDepth() {
        return this.mSize >> 2;
    }

    public final AttributeCollector getAttrCollector() {
        return this.mAttrCollector;
    }

    public final BaseNsContext createNonTransientNsContext(Location loc) {
        int localCount = this.getCurrentNsCount() << 1;
        return new CompactNsContext(loc, this.getDefaultNsURI(), this.mNamespaces.asArray(), this.mNamespaces.size() - localCount);
    }

    public final String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Illegal to pass null as argument.");
        }
        if (prefix.length() == 0) {
            if (this.mSize == 0) {
                return null;
            }
            return this.mElements[this.mSize - 1];
        }
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (prefix.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        return this.mNamespaces.findLastNonInterned(prefix);
    }

    public final String getPrefix(String nsURI) {
        if (nsURI == null || nsURI.length() == 0) {
            throw new IllegalArgumentException("Illegal to pass null/empty prefix as argument.");
        }
        if (nsURI.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (nsURI.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        String prefix = null;
        String[] strs = this.mNamespaces.getInternalArray();
        int len = this.mNamespaces.size();
        block0: for (int index = len - 1; index > 0; index -= 2) {
            if (!nsURI.equals(strs[index])) continue;
            prefix = strs[index - 1];
            for (int j = index + 1; j < len; j += 2) {
                if (strs[j] != prefix) continue;
                prefix = null;
                continue block0;
            }
        }
        return prefix;
    }

    public final Iterator getPrefixes(String nsURI) {
        if (nsURI == null || nsURI.length() == 0) {
            throw new IllegalArgumentException("Illegal to pass null/empty prefix as argument.");
        }
        if (nsURI.equals("http://www.w3.org/XML/1998/namespace")) {
            return new SingletonIterator("xml");
        }
        if (nsURI.equals("http://www.w3.org/2000/xmlns/")) {
            return new SingletonIterator("xmlns");
        }
        String[] strs = this.mNamespaces.getInternalArray();
        int len = this.mNamespaces.size();
        ArrayList<String> l = null;
        block0: for (int index = len - 1; index > 0; index -= 2) {
            if (!nsURI.equals(strs[index])) continue;
            String prefix = strs[index - 1];
            for (int j = index + 1; j < len; j += 2) {
                if (strs[j] == prefix) continue block0;
            }
            if (l == null) {
                l = new ArrayList<String>();
            }
            l.add(prefix);
        }
        return l == null ? EmptyIterator.getInstance() : l.iterator();
    }

    public int findAttributeIndex(String nsURI, String localName) {
        return this.mAttrCollector.findIndex(nsURI, localName);
    }

    public final boolean isEmpty() {
        return this.mSize == 0;
    }

    public final String getDefaultNsURI() {
        if (this.mSize == 0) {
            throw new IllegalStateException("Illegal access, empty stack.");
        }
        return this.mElements[this.mSize - 1];
    }

    public final String getNsURI() {
        if (this.mSize == 0) {
            throw new IllegalStateException("Illegal access, empty stack.");
        }
        return this.mElements[this.mSize - 2];
    }

    public final String getPrefix() {
        if (this.mSize == 0) {
            throw new IllegalStateException("Illegal access, empty stack.");
        }
        return this.mElements[this.mSize - 4];
    }

    public final String getLocalName() {
        if (this.mSize == 0) {
            throw new IllegalStateException("Illegal access, empty stack.");
        }
        return this.mElements[this.mSize - 3];
    }

    public final QName getQName() {
        QName n;
        if (this.mSize == 0) {
            throw new IllegalStateException("Illegal access, empty stack.");
        }
        String prefix = this.mElements[this.mSize - 4];
        if (prefix == null) {
            prefix = DEFAULT_NAMESPACE_URI;
        }
        String nsURI = this.mElements[this.mSize - 2];
        String ln = this.mElements[this.mSize - 3];
        if (ln != this.mLastLocalName) {
            this.mLastLocalName = ln;
            this.mLastPrefix = prefix;
            this.mLastNsURI = nsURI;
        } else if (prefix != this.mLastPrefix) {
            this.mLastPrefix = prefix;
            this.mLastNsURI = nsURI;
        } else if (nsURI != this.mLastNsURI) {
            this.mLastNsURI = nsURI;
        } else {
            return this.mLastName;
        }
        this.mLastName = n = new QName(nsURI, ln, prefix);
        return n;
    }

    public final boolean matches(String prefix, String localName) {
        if (this.mSize == 0) {
            throw new IllegalStateException("Illegal access, empty stack.");
        }
        String thisPrefix = this.mElements[this.mSize - 4];
        if (prefix == null || prefix.length() == 0 ? thisPrefix != null && thisPrefix.length() > 0 : thisPrefix != prefix && !thisPrefix.equals(prefix)) {
            return false;
        }
        String thisName = this.mElements[this.mSize - 3];
        return thisName == localName || thisName.equals(localName);
    }

    public final String getTopElementDesc() {
        if (this.mSize == 0) {
            throw new IllegalStateException("Illegal access, empty stack.");
        }
        String name = this.mElements[this.mSize - 3];
        String prefix = this.mElements[this.mSize - 4];
        if (prefix == null || prefix.length() == 0) {
            return name;
        }
        return prefix + ":" + name;
    }

    public final int getTotalNsCount() {
        return this.mNamespaces.size() >> 1;
    }

    public final int getCurrentNsCount() {
        return this.mNamespaces.size() - this.mNsCounts[this.mSize - 1 >> 2] >> 1;
    }

    public final String getLocalNsPrefix(int index) {
        int offset = this.mNsCounts[this.mSize - 1 >> 2];
        int localCount = this.mNamespaces.size() - offset;
        if ((index <<= 1) < 0 || index >= localCount) {
            throw new IllegalArgumentException("Illegal namespace index " + (index >> 1) + "; current scope only has " + (localCount >> 1) + " namespace declarations.");
        }
        return this.mNamespaces.getString(offset + index);
    }

    public final String getLocalNsURI(int index) {
        int offset = this.mNsCounts[this.mSize - 1 >> 2];
        int localCount = this.mNamespaces.size() - offset;
        if ((index <<= 1) < 0 || index >= localCount) {
            throw new IllegalArgumentException("Illegal namespace index " + (index >> 1) + "; current scope only has " + (localCount >> 1) + " namespace declarations.");
        }
        return this.mNamespaces.getString(offset + index + 1);
    }
}

