/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.sw;

import com.ctc.wstx.api.WriterConfig;
import com.ctc.wstx.cfg.ErrorConsts;
import com.ctc.wstx.sw.BaseStreamWriter;
import com.ctc.wstx.sw.SimpleOutputElement;
import com.ctc.wstx.util.DefaultXmlSymbolTable;
import java.io.IOException;
import java.io.Writer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public abstract class BaseNsStreamWriter
extends BaseStreamWriter {
    protected static final String sPrefixXml = DefaultXmlSymbolTable.getXmlSymbol();
    protected static final String sPrefixXmlns = DefaultXmlSymbolTable.getXmlnsSymbol();
    protected static final String ERR_NSDECL_WRONG_STATE = "Trying to write a namespace declaration when there is no open start element.";
    protected final boolean mAutomaticNS;
    protected SimpleOutputElement mCurrElem = SimpleOutputElement.createRoot();
    protected NamespaceContext mRootNsContext = null;

    public BaseNsStreamWriter(Writer w, WriterConfig cfg, boolean repairing) {
        super(w, cfg);
        this.mAutomaticNS = repairing;
    }

    public NamespaceContext getNamespaceContext() {
        return this.mCurrElem;
    }

    public String getPrefix(String uri) {
        return this.mCurrElem.getPrefix(uri);
    }

    public abstract void setDefaultNamespace(String var1) throws XMLStreamException;

    public void setNamespaceContext(NamespaceContext ctxt) {
        if (this.mState != 1) {
            throw new IllegalStateException("Called setNamespaceContext() after having already output root element.");
        }
        this.mRootNsContext = ctxt;
        this.mCurrElem.setRootNsContext(ctxt);
    }

    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        if (prefix == null) {
            throw new NullPointerException("Can not pass null 'prefix' value");
        }
        if (prefix.length() == 0) {
            this.setDefaultNamespace(uri);
            return;
        }
        if (uri == null) {
            throw new NullPointerException("Can not pass null 'uri' value");
        }
        if (prefix.equals(sPrefixXml)) {
            if (!uri.equals("http://www.w3.org/XML/1998/namespace")) {
                BaseNsStreamWriter.throwOutputError(ErrorConsts.ERR_NS_REDECL_XML, uri);
            }
        } else if (prefix.equals(sPrefixXmlns)) {
            if (!uri.equals("http://www.w3.org/2000/xmlns/")) {
                BaseNsStreamWriter.throwOutputError(ErrorConsts.ERR_NS_REDECL_XMLNS, uri);
            }
        } else if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
            BaseNsStreamWriter.throwOutputError(ErrorConsts.ERR_NS_REDECL_XML_URI, prefix);
        } else if (uri.equals("http://www.w3.org/2000/xmlns/")) {
            BaseNsStreamWriter.throwOutputError(ErrorConsts.ERR_NS_REDECL_XMLNS_URI, prefix);
        }
        if (uri.length() == 0) {
            BaseNsStreamWriter.throwOutputError(ErrorConsts.ERR_NS_EMPTY);
        }
        this.doSetPrefix(prefix, uri);
    }

    public void writeAttribute(String localName, String value) throws XMLStreamException {
        if (!this.mStartElementOpen) {
            throw new IllegalStateException(ErrorConsts.WERR_ATTR_NO_ELEM);
        }
        this.doWriteAttr(localName, null, null, value);
    }

    public abstract void writeAttribute(String var1, String var2, String var3) throws XMLStreamException;

    public abstract void writeAttribute(String var1, String var2, String var3, String var4) throws XMLStreamException;

    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.checkStartElement(localName);
        this.mEmptyElement = true;
        this.mCurrElem = this.mCurrElem.createChild("", localName);
        this.doWriteStartElement(null, localName);
    }

    public void writeEmptyElement(String nsURI, String localName) throws XMLStreamException {
        this.writeStartOrEmpty(localName, nsURI);
        this.mEmptyElement = true;
    }

    public void writeEmptyElement(String prefix, String localName, String nsURI) throws XMLStreamException {
        this.writeStartOrEmpty(prefix, localName, nsURI);
        this.mEmptyElement = true;
    }

    public void writeEndElement() throws XMLStreamException {
        this.doWriteEndElement(null, this.mCfgOutputEmptyElems);
    }

    public void writeStartElement(String localName) throws XMLStreamException {
        this.checkStartElement(localName);
        this.mEmptyElement = false;
        this.mCurrElem = this.mCurrElem.createChild("", localName);
        this.doWriteStartElement(null, localName);
    }

    public void writeStartElement(String nsURI, String localName) throws XMLStreamException {
        this.writeStartOrEmpty(localName, nsURI);
        this.mEmptyElement = false;
    }

    public void writeStartElement(String prefix, String localName, String nsURI) throws XMLStreamException {
        this.writeStartOrEmpty(prefix, localName, nsURI);
        this.mEmptyElement = false;
    }

    public void writeFullEndElement() throws XMLStreamException {
        this.doWriteEndElement(null, false);
    }

    public void writeEndElement(QName name) throws XMLStreamException {
        this.doWriteEndElement(this.mCheckStructure ? name : null, this.mCfgOutputEmptyElems);
    }

    protected void closeStartElement(boolean emptyElem) throws XMLStreamException {
        this.mStartElementOpen = false;
        try {
            if (emptyElem) {
                this.mWriter.write(" />");
            } else {
                this.mWriter.write(62);
            }
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
        if (emptyElem) {
            this.mCurrElem = this.mCurrElem.getParent();
            if (this.mCurrElem.isRoot()) {
                this.mState = 3;
            }
        }
    }

    protected void checkStartElement(String localName) throws XMLStreamException {
        if (this.mStartElementOpen) {
            this.closeStartElement(this.mEmptyElement);
        } else if (this.mCheckStructure && this.mState == 3) {
            throw new IllegalStateException("Trying to output second root ('" + localName + "').");
        }
        if (this.mCheckContent) {
            BaseNsStreamWriter.verifyNameValidity(localName, this.mNsAware);
        }
        if (this.mState == 1) {
            this.mState = 2;
        }
    }

    protected void doWriteAttr(String localName, String nsURI, String prefix, String value) throws XMLStreamException {
        if (this.mCheckNames) {
            BaseNsStreamWriter.verifyNameValidity(localName, true);
        }
        if (this.mCheckAttr) {
            this.mCurrElem.checkAttrWrite(nsURI, localName, value);
        }
        try {
            this.mWriter.write(32);
            if (prefix != null && prefix.length() > 0) {
                this.mWriter.write(prefix);
                this.mWriter.write(58);
            }
            this.mWriter.write(localName);
            this.mWriter.write("=\"");
            this.mAttrValueWriter.write(value);
            this.mWriter.write(34);
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    protected void doWriteNamespace(String prefix, String nsURI) throws XMLStreamException {
        try {
            this.mWriter.write(32);
            this.mWriter.write("xmlns");
            if (prefix != null && prefix.length() > 0) {
                this.mWriter.write(58);
                this.mWriter.write(prefix);
            }
            this.mWriter.write("=\"");
            if (nsURI != null && nsURI.length() > 0) {
                this.mWriter.write(nsURI);
            }
            this.mWriter.write(34);
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    protected void doWriteEndElement(QName expName, boolean allowEmpty) throws XMLStreamException {
        if (this.mStartElementOpen && this.mEmptyElement) {
            this.mEmptyElement = false;
            this.closeStartElement(true);
        }
        if (this.mState != 2) {
            BaseNsStreamWriter.throwOutputError("No open start element, when trying to write end element");
        }
        String prefix = this.mCurrElem.getPrefix();
        String localName = this.mCurrElem.getLocalName();
        this.mCurrElem = this.mCurrElem.getParent();
        if (expName != null && !localName.equals(expName.getLocalPart())) {
            throw new IllegalArgumentException("Mismatching close element local name, '" + localName + "'; expected '" + expName.getLocalPart() + "'.");
        }
        if (this.mStartElementOpen) {
            this.mStartElementOpen = false;
            try {
                if (allowEmpty) {
                    this.mWriter.write(" />");
                    if (this.mCurrElem.isRoot()) {
                        this.mState = 3;
                    }
                    return;
                }
                this.mWriter.write(62);
            }
            catch (IOException ioe) {
                throw new XMLStreamException(ioe);
            }
        }
        try {
            this.mWriter.write("</");
            if (prefix != null && prefix.length() > 0) {
                this.mWriter.write(prefix);
                this.mWriter.write(58);
            }
            this.mWriter.write(localName);
            this.mWriter.write(62);
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
        if (this.mCurrElem.isRoot()) {
            this.mState = 3;
        }
    }

    protected void doWriteStartElement(String prefix, String localName) throws XMLStreamException {
        this.mAnyOutput = true;
        this.mStartElementOpen = true;
        if (this.mCheckNames) {
            if (prefix != null && prefix.length() > 0) {
                BaseNsStreamWriter.verifyNameValidity(prefix, true);
            }
            BaseNsStreamWriter.verifyNameValidity(localName, true);
        }
        try {
            this.mWriter.write(60);
            if (prefix != null && prefix.length() > 0) {
                this.mWriter.write(prefix);
                this.mWriter.write(58);
            }
            this.mWriter.write(localName);
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    public abstract void doSetPrefix(String var1, String var2) throws XMLStreamException;

    public abstract void writeDefaultNamespace(String var1) throws XMLStreamException;

    public abstract void writeNamespace(String var1, String var2) throws XMLStreamException;

    public abstract void writeStartElement(StartElement var1) throws XMLStreamException;

    protected abstract void writeStartOrEmpty(String var1, String var2) throws XMLStreamException;

    protected abstract void writeStartOrEmpty(String var1, String var2, String var3) throws XMLStreamException;
}

