/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dtd;

import com.ctc.wstx.api.ReaderConfig;
import com.ctc.wstx.ent.EntityDecl;
import com.ctc.wstx.exc.WstxException;
import com.ctc.wstx.io.WstxInputSource;
import com.ctc.wstx.sr.StreamScanner;
import java.io.IOException;
import javax.xml.stream.Location;

public class MinimalDTDReader
extends StreamScanner {
    final boolean mIsExternal;

    private MinimalDTDReader(StreamScanner master, WstxInputSource input, ReaderConfig cfg) {
        this(input, cfg, master, false);
    }

    protected MinimalDTDReader(WstxInputSource input, ReaderConfig cfg, StreamScanner master, boolean isExt) {
        super(input, cfg, cfg.getDtdResolver());
        this.mIsExternal = isExt;
        this.mNameBuffer = master == null ? null : master.mNameBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void skipInternalSubset(StreamScanner master, WstxInputSource input, ReaderConfig cfg) throws IOException, WstxException {
        MinimalDTDReader r = new MinimalDTDReader(master, input, cfg);
        r.copyBufferStateFrom(master);
        try {
            r.skipInternalSubset();
        }
        finally {
            master.copyBufferStateFrom(r);
        }
    }

    public final Location getLocation() {
        return this.getStartLocation();
    }

    public EntityDecl findEntity(String entName) {
        return null;
    }

    protected void skipInternalSubset() throws IOException, WstxException {
        while (true) {
            int i;
            if ((i = this.getNextAfterWS()) < 0) {
                this.throwUnexpectedEOF(" in internal DTD subset");
            }
            if (i == 37) {
                this.skipPE();
                continue;
            }
            if (i == 60) {
                char c = this.getNextSkippingPEs();
                if (c == '?') {
                    this.skipPI();
                    continue;
                }
                if (c == '!') {
                    c = this.getNextSkippingPEs();
                    if (c == '[') continue;
                    if (c == '-') {
                        this.skipComment();
                        continue;
                    }
                    if (c >= 'A' && c <= 'Z') {
                        this.skipDeclaration(c);
                        continue;
                    }
                    this.skipDeclaration(c);
                    continue;
                }
                --this.mInputPtr;
                continue;
            }
            if (i == 93) {
                if (this.mInput == this.mRootInput) break;
                this.throwParseError("Encountered int. subset end marker ']]>' in an expanded entity; has to be at main level.");
                break;
            }
            this.throwUnexpectedChar(i, " in internal DTD subset; expected a '<' to start a directive, or \"]>\" to end internal subset.");
        }
    }

    protected char getNextSkippingPEs() throws IOException, WstxException {
        while (true) {
            char c;
            char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
            if (c != '%') {
                return c;
            }
            this.skipPE();
        }
    }

    private void skipPE() throws IOException, WstxException {
        char c;
        this.skipDTDName();
        char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
        if (c != ';') {
            --this.mInputPtr;
        }
    }

    protected void skipComment() throws IOException, WstxException {
        char c;
        this.skipCommentContent();
        char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
        if (c != '>') {
            this.throwParseError("String '--' not allowed in comment (missing '>'?)");
        }
    }

    protected void skipCommentContent() throws IOException, WstxException {
        while (true) {
            char c;
            char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
            if (c == '-') {
                c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
                if (c != '-') continue;
                return;
            }
            if (c != '\n' && c != '\r') continue;
            this.skipCRLF(c);
        }
    }

    protected void skipPI() throws IOException, WstxException {
        while (true) {
            char c;
            char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
            if (c == '?') {
                while ((c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg())) == '?') {
                }
                if (c == '>') break;
            }
            if (c != '\n' && c != '\r') continue;
            this.skipCRLF(c);
        }
    }

    private void skipDeclaration(char c) throws IOException, WstxException {
        while (c != '>') {
            char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
            if (c == '\n' || c == '\r') {
                this.skipCRLF(c);
                continue;
            }
            if (c != '\'' && c != '\"') continue;
            this.skipLiteral(c);
        }
    }

    private void skipLiteral(char quoteChar) throws IOException, WstxException {
        while (true) {
            char c;
            char c2 = c = this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.getNextChar(this.getErrorMsg());
            if (c == '\n' || c == '\r') {
                this.skipCRLF(c);
                continue;
            }
            if (c == quoteChar) break;
        }
    }

    private void skipDTDName() throws IOException, WstxException {
        int len = this.skipFullName(this.getNextChar(this.getErrorMsg()));
    }

    protected String getErrorMsg() {
        return this.mIsExternal ? " in external DTD subset" : " in internal DTD subset";
    }
}

