/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.io;

import com.ctc.wstx.io.WriterBase;
import java.io.IOException;
import java.io.Writer;

public class SingleByteAttrValueWriter
extends WriterBase {
    private final char mLowestEntity;
    final char mQuoteChar;
    final String mQuoteEntity;

    public SingleByteAttrValueWriter(Writer out, String enc, char qchar, int charsetSize) {
        super(out);
        this.mQuoteChar = qchar;
        this.mQuoteEntity = SingleByteAttrValueWriter.getQuoteEntity(qchar);
        this.mLowestEntity = (char)charsetSize;
    }

    public void write(int c) throws IOException {
        if (c <= 60) {
            if (c == this.mQuoteChar) {
                this.out.write(this.mQuoteEntity);
                return;
            }
            if (c == 60) {
                this.out.write("&lt;");
                return;
            }
            if (c == 38) {
                this.out.write("&amp;");
                return;
            }
            if (c == 0) {
                this.throwNullChar();
            }
        } else if (c >= this.mLowestEntity) {
            this.writeAsEntity(c);
        } else {
            this.out.write(c);
        }
    }

    public void write(char[] cbuf, int offset, int len) throws IOException {
        len += offset;
        char qchar = this.mQuoteChar;
        do {
            int outLen;
            int start = offset;
            char c = '\u0000';
            String ent = null;
            while (offset < len) {
                c = cbuf[offset];
                if (c <= '<') {
                    if (c >= this.mLowestEntity) break;
                    if (c == qchar) {
                        ent = this.mQuoteEntity;
                        break;
                    }
                    if (c == '<') {
                        ent = "&lt;";
                        break;
                    }
                    if (c == '&') {
                        ent = "&amp;";
                        break;
                    }
                    if (c == '\u0000') {
                        this.throwNullChar();
                        break;
                    }
                }
                ++offset;
            }
            if ((outLen = offset - start) > 0) {
                this.out.write(cbuf, start, outLen);
            }
            if (ent != null) {
                this.out.write(ent);
                continue;
            }
            if (offset >= len) continue;
            this.writeAsEntity(c);
        } while (++offset < len);
    }

    public void write(String str, int offset, int len) throws IOException {
        len += offset;
        char qchar = this.mQuoteChar;
        do {
            int outLen;
            int start = offset;
            char c = '\u0000';
            String ent = null;
            while (offset < len) {
                c = str.charAt(offset);
                if (c <= '<') {
                    if (c >= this.mLowestEntity) break;
                    if (c == qchar) {
                        ent = this.mQuoteEntity;
                        break;
                    }
                    if (c == '<') {
                        ent = "&lt;";
                        break;
                    }
                    if (c == '&') {
                        ent = "&amp;";
                        break;
                    }
                    if (c == '\u0000') {
                        this.throwNullChar();
                        break;
                    }
                }
                ++offset;
            }
            if ((outLen = offset - start) > 0) {
                this.out.write(str, start, outLen);
            }
            if (ent != null) {
                this.out.write(ent);
                continue;
            }
            if (offset >= len) continue;
            this.writeAsEntity(c);
        } while (++offset < len);
    }
}

