/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.util;

public final class IntVector {
    static final int[] sEmptyArray = new int[0];
    private int[] mInts;
    private final int mInitialSize;
    private int mSize;

    public IntVector(int initialSize) {
        this.mInitialSize = initialSize;
        this.mInts = null;
        this.mSize = 0;
    }

    public int size() {
        return this.mSize;
    }

    public int getInt(int index) {
        return this.mInts[index];
    }

    public int popInt() {
        if (this.mSize < 1) {
            throw new IllegalStateException("Popping from empty stack.");
        }
        return this.mInts[--this.mSize];
    }

    public int peekInt() {
        if (this.mSize < 1) {
            throw new IllegalStateException("Peeking from empty stack.");
        }
        return this.mInts[this.mSize - 1];
    }

    public void addInt(int value) {
        if (this.mInts == null) {
            this.mInts = new int[this.mInitialSize];
        } else if (this.mSize >= this.mInts.length) {
            int[] old = this.mInts;
            this.mInts = new int[this.mSize + this.mSize];
            System.arraycopy(old, 0, this.mInts, 0, old.length);
        }
        this.mInts[this.mSize++] = value;
    }

    public int[] getInternalArray() {
        return this.mInts == null ? sEmptyArray : this.mInts;
    }
}

