/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.io;

import com.ctc.wstx.io.WriterBase;
import java.io.IOException;
import java.io.Writer;

public class UTFTextWriter
extends WriterBase {
    private boolean mJustWroteBracket = false;

    public UTFTextWriter(Writer out, String enc) {
        super(out);
    }

    public void write(int c) throws IOException {
        if (c <= 62) {
            if (c == 60) {
                this.out.write("&lt;");
            } else if (c == 38) {
                this.out.write("&amp;");
            } else if (c == 62) {
                if (this.mJustWroteBracket) {
                    this.out.write("&gt;");
                } else {
                    this.out.write(c);
                }
            } else {
                this.out.write(c);
            }
            this.mJustWroteBracket = false;
        } else {
            this.out.write(c);
            this.mJustWroteBracket = c == 93;
        }
    }

    public void write(char[] cbuf, int offset, int len) throws IOException {
        if (len < 2) {
            if (len == 1) {
                this.write(cbuf[offset]);
            }
            return;
        }
        char c = '\u0000';
        len += offset;
        if (this.mJustWroteBracket && (c = cbuf[offset]) == '>') {
            this.out.write("&gt;");
            ++offset;
        }
        do {
            int outLen;
            int start = offset;
            String ent = null;
            while (offset < len) {
                c = cbuf[offset];
                if (c <= '>') {
                    if (c == '<') {
                        ent = "&lt;";
                        break;
                    }
                    if (c == '&') {
                        ent = "&amp;";
                        break;
                    }
                    if (c == '>' && offset > start && cbuf[offset - 1] == ']') {
                        ent = "&gt;";
                        break;
                    }
                }
                ++offset;
            }
            if ((outLen = offset - start) > 0) {
                this.out.write(cbuf, start, outLen);
            }
            if (ent == null) continue;
            this.out.write(ent);
            ent = null;
        } while (++offset < len);
        this.mJustWroteBracket = c == ']';
    }

    public void write(String str, int offset, int len) throws IOException {
        if (len < 2) {
            if (len == 1) {
                this.write(str.charAt(offset));
            }
            return;
        }
        char c = '\u0000';
        len += offset;
        if (this.mJustWroteBracket && (c = str.charAt(offset)) == '>') {
            this.out.write("&gt;");
            ++offset;
        }
        do {
            int outLen;
            int start = offset;
            String ent = null;
            while (offset < len) {
                c = str.charAt(offset);
                if (c <= '>') {
                    if (c == '<') {
                        ent = "&lt;";
                        break;
                    }
                    if (c == '&') {
                        ent = "&amp;";
                        break;
                    }
                    if (c == '>' && offset > start && str.charAt(offset - 1) == ']') {
                        ent = "&gt;";
                        break;
                    }
                }
                ++offset;
            }
            if ((outLen = offset - start) > 0) {
                this.out.write(str, start, outLen);
            }
            if (ent == null) continue;
            this.out.write(ent);
            ent = null;
        } while (++offset < len);
        this.mJustWroteBracket = c == ']';
    }
}

