/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.io;

import com.ctc.wstx.exc.WstxException;
import com.ctc.wstx.io.InputBootstrapper;
import com.ctc.wstx.io.InputSourceFactory;
import com.ctc.wstx.io.ReaderBootstrapper;
import com.ctc.wstx.io.StreamBootstrapper;
import com.ctc.wstx.io.WstxInputSource;
import com.ctc.wstx.util.URLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public final class DefaultInputResolver {
    private static final int DEFAULT_BUFFER_LENGTH = 4000;

    private DefaultInputResolver() {
    }

    public static WstxInputSource resolveEntity(WstxInputSource refCtxt, String entityName, String publicId, String systemId, XMLResolver customResolver, XMLReporter rep) throws IOException, XMLStreamException {
        URL ctxt;
        URL uRL = ctxt = refCtxt == null ? null : refCtxt.getSource();
        if (ctxt == null) {
            ctxt = URLUtil.urlFromCurrentDir();
        }
        if (customResolver != null) {
            Object source;
            Object object = source = customResolver == null ? null : customResolver.resolveEntity(publicId, systemId, ctxt.toExternalForm(), entityName);
            if (source != null) {
                return DefaultInputResolver.sourceFrom(refCtxt, entityName, source, rep);
            }
        }
        if (systemId == null) {
            throw new XMLStreamException("Can not resolve " + (entityName == null ? "[External DTD subset]" : "entity '" + entityName + "'") + " without a system id (public id '" + publicId + "')");
        }
        URL url = URLUtil.urlFromSystemId(systemId, ctxt);
        return DefaultInputResolver.sourceFromURL(refCtxt, rep, entityName, url, publicId, systemId);
    }

    public static WstxInputSource sourceFrom(WstxInputSource parent, String refName, Object o, XMLReporter rep) throws IllegalArgumentException, IOException, WstxException {
        if (o instanceof Source) {
            if (o instanceof StreamSource) {
                return DefaultInputResolver.sourceFromSS(parent, rep, refName, (StreamSource)o);
            }
            throw new IllegalArgumentException("Can not use other Source objects than StreamSource: got " + o.getClass());
        }
        if (o instanceof URL) {
            return DefaultInputResolver.sourceFromURL(parent, rep, refName, (URL)o, null, null);
        }
        if (o instanceof InputStream) {
            return DefaultInputResolver.sourceFromIS(parent, rep, refName, (InputStream)o, null, null);
        }
        if (o instanceof Reader) {
            return DefaultInputResolver.sourceFromR(parent, rep, refName, (Reader)o, null, null);
        }
        if (o instanceof String) {
            return DefaultInputResolver.sourceFromString(parent, rep, refName, (String)o);
        }
        throw new IllegalArgumentException("Unrecognized input argument type for sourceFrom(): " + o.getClass());
    }

    private static WstxInputSource sourceFromSS(WstxInputSource parent, XMLReporter rep, String refName, StreamSource ssrc) throws IOException, WstxException {
        InputBootstrapper bs;
        URL url;
        Reader r = ssrc.getReader();
        String pubId = ssrc.getPublicId();
        String sysId = ssrc.getSystemId();
        URL ctxt = parent == null ? null : parent.getSource();
        URL uRL = url = sysId == null || sysId.length() == 0 ? null : URLUtil.urlFromSystemId(sysId, ctxt);
        if (r == null) {
            InputStream in = ssrc.getInputStream();
            if (in == null) {
                if (url == null) {
                    throw new IllegalArgumentException("Can not create StAX reader for a StreamSource -- neither reader, input stream nor system id was set.");
                }
                in = URLUtil.optimizedStreamFromURL(url);
            }
            bs = StreamBootstrapper.getInstance(in, pubId, sysId, DefaultInputResolver.getInputBufferLength(parent));
        } else {
            bs = ReaderBootstrapper.getInstance(r, pubId, sysId, DefaultInputResolver.getInputBufferLength(parent), null);
        }
        Reader r2 = ((InputBootstrapper)bs).bootstrapInput(false, rep);
        return InputSourceFactory.constructEntitySource(parent, refName, bs, pubId, sysId, url == null ? ctxt : url, r2);
    }

    private static WstxInputSource sourceFromURL(WstxInputSource parent, XMLReporter rep, String refName, URL url, String pubId, String sysId) throws IOException, WstxException {
        InputStream in = URLUtil.optimizedStreamFromURL(url);
        if (sysId == null) {
            sysId = url.toExternalForm();
        }
        StreamBootstrapper bs = StreamBootstrapper.getInstance(in, pubId, sysId, DefaultInputResolver.getInputBufferLength(parent));
        Reader r = bs.bootstrapInput(false, rep);
        return InputSourceFactory.constructEntitySource(parent, refName, bs, pubId, sysId, url, r);
    }

    private static WstxInputSource sourceFromString(WstxInputSource parent, XMLReporter rep, String refName, String refContent) throws IOException, WstxException {
        return DefaultInputResolver.sourceFromR(parent, rep, refName, new StringReader(refContent), null, refName);
    }

    private static WstxInputSource sourceFromIS(WstxInputSource parent, XMLReporter rep, String refName, InputStream is, String pubId, String sysId) throws IOException, WstxException {
        StreamBootstrapper bs = StreamBootstrapper.getInstance(is, pubId, sysId, DefaultInputResolver.getInputBufferLength(parent));
        Reader r = bs.bootstrapInput(false, rep);
        URL ctxt = parent.getSource();
        if (sysId != null && sysId.length() > 0) {
            ctxt = URLUtil.urlFromSystemId(sysId, ctxt);
        }
        return InputSourceFactory.constructEntitySource(parent, refName, bs, pubId, sysId, ctxt, r);
    }

    private static WstxInputSource sourceFromR(WstxInputSource parent, XMLReporter rep, String refName, Reader r, String pubId, String sysId) throws IOException, WstxException {
        ReaderBootstrapper rbs = ReaderBootstrapper.getInstance(r, pubId, sysId, DefaultInputResolver.getInputBufferLength(parent), null);
        r = rbs.bootstrapInput(false, rep);
        URL ctxt = parent.getSource();
        if (sysId != null && sysId.length() > 0) {
            ctxt = URLUtil.urlFromSystemId(sysId, ctxt);
        }
        return InputSourceFactory.constructEntitySource(parent, refName, rbs, pubId, sysId, ctxt, r);
    }

    private static int getInputBufferLength(WstxInputSource parent) {
        return parent == null ? 4000 : parent.getInputBufferLength();
    }
}

