/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.io;

public class WstxInputData {
    public static final char CHAR_NULL = '\u0000';
    public static final char INT_NULL = '\u0000';
    public static final char CHAR_SPACE = ' ';
    public static final char INT_SPACE = ' ';
    private static final int VALID_CHAR_COUNT = 256;
    private static final byte NAME_CHAR_INVALID_B = 0;
    private static final byte NAME_CHAR_ALL_VALID_B = 1;
    private static final byte NAME_CHAR_VALID_NONFIRST_B = -1;
    private static final int NAME_CHAR_INVALID_I = 0;
    private static final int NAME_CHAR_ALL_VALID_I = 1;
    private static final int NAME_CHAR_VALID_NONFIRST_I = -1;
    private static final byte[] sCharValidity;
    private static final int VALID_PUBID_CHAR_COUNT = 128;
    private static final byte[] sPubidValidity;
    private static final byte PUBID_CHAR_INVALID_B = 0;
    private static final byte PUBID_CHAR_VALID_B = 1;
    protected char[] mInputBuffer;
    protected int mInputPtr = 0;
    protected int mInputLen = 0;
    protected long mCurrInputProcessed = 0L;
    protected int mCurrInputRow = 1;
    protected int mCurrInputRowStart = 0;

    protected WstxInputData() {
    }

    public void copyBufferStateFrom(WstxInputData src) {
        this.mInputBuffer = src.mInputBuffer;
        this.mInputPtr = src.mInputPtr;
        this.mInputLen = src.mInputLen;
        this.mCurrInputProcessed = src.mCurrInputProcessed;
        this.mCurrInputRow = src.mCurrInputRow;
        this.mCurrInputRowStart = src.mCurrInputRowStart;
    }

    public static final boolean is11NameStartChar(char c) {
        if (c < '\u0100') {
            if (c <= ' ') {
                return false;
            }
            return sCharValidity[c] == 1;
        }
        if (c <= '\u2fef') {
            if (c < '\u0300' || c >= '\u2c00') {
                return true;
            }
            if (c < '\u0370' || c > '\u218f') {
                return false;
            }
            if (c < '\u2000') {
                return c != '\u037e';
            }
            if (c >= '\u2070') {
                return c <= '\u218f';
            }
            return c == '\u200c' || c == '\u200d';
        }
        if (c >= '\u3001') {
            if (c <= '\udbff') {
                return true;
            }
            if (c >= '\uf900' && c <= '\ufffd') {
                return c <= '\ufdcf' || c >= '\ufdf0';
            }
        }
        return false;
    }

    public static final boolean is11NameChar(char c) {
        if (c < '\u0100') {
            if (c <= ' ') {
                return false;
            }
            return sCharValidity[c] != 0;
        }
        if (c <= '\u2fef') {
            if (c < '\u2000' || c >= '\u2c00') {
                return true;
            }
            if (c < '\u200c' || c > '\u218f') {
                return false;
            }
            if (c >= '\u2070') {
                return true;
            }
            return c == '\u200c' || c == '\u200d' || c == '\u203f' || c == '\u2040';
        }
        if (c >= '\u3001') {
            if (c <= '\udfff') {
                return true;
            }
            if (c >= '\uf900' && c <= '\ufffd') {
                return c <= '\ufdcf' || c >= '\ufdf0';
            }
        }
        return false;
    }

    public static final boolean isSpaceChar(char c) {
        return c <= ' ';
    }

    public static String getCharDesc(char c) {
        char i = c;
        if (Character.isISOControl(c)) {
            return "(CTRL-CHAR, code " + i + ")";
        }
        return "'" + c + "' (code " + i + ")";
    }

    static {
        int i;
        sCharValidity = new byte[256];
        WstxInputData.sCharValidity[95] = 1;
        int last = 25;
        for (i = 0; i <= last; ++i) {
            WstxInputData.sCharValidity[65 + i] = 1;
            WstxInputData.sCharValidity[97 + i] = 1;
        }
        for (i = 192; i < 246; ++i) {
            WstxInputData.sCharValidity[i] = 1;
        }
        WstxInputData.sCharValidity[215] = 0;
        WstxInputData.sCharValidity[247] = 0;
        WstxInputData.sCharValidity[45] = -1;
        WstxInputData.sCharValidity[46] = -1;
        WstxInputData.sCharValidity[183] = -1;
        for (i = 48; i <= 57; ++i) {
            WstxInputData.sCharValidity[i] = -1;
        }
        sPubidValidity = new byte[128];
        last = 25;
        for (i = 0; i <= last; ++i) {
            WstxInputData.sPubidValidity[65 + i] = 1;
            WstxInputData.sPubidValidity[97 + i] = 1;
        }
        for (i = 48; i <= 57; ++i) {
            WstxInputData.sPubidValidity[i] = 1;
        }
        WstxInputData.sPubidValidity[10] = 1;
        WstxInputData.sPubidValidity[13] = 1;
        WstxInputData.sPubidValidity[32] = 1;
        WstxInputData.sPubidValidity[45] = 1;
        WstxInputData.sPubidValidity[39] = 1;
        WstxInputData.sPubidValidity[40] = 1;
        WstxInputData.sPubidValidity[41] = 1;
        WstxInputData.sPubidValidity[43] = 1;
        WstxInputData.sPubidValidity[44] = 1;
        WstxInputData.sPubidValidity[46] = 1;
        WstxInputData.sPubidValidity[47] = 1;
        WstxInputData.sPubidValidity[58] = 1;
        WstxInputData.sPubidValidity[61] = 1;
        WstxInputData.sPubidValidity[63] = 1;
        WstxInputData.sPubidValidity[59] = 1;
        WstxInputData.sPubidValidity[33] = 1;
        WstxInputData.sPubidValidity[42] = 1;
        WstxInputData.sPubidValidity[35] = 1;
        WstxInputData.sPubidValidity[64] = 1;
        WstxInputData.sPubidValidity[36] = 1;
        WstxInputData.sPubidValidity[95] = 1;
        WstxInputData.sPubidValidity[37] = 1;
    }
}

