/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.stax;

import com.ctc.wstx.api.ReaderConfig;
import com.ctc.wstx.cfg.InputConfigFlags;
import com.ctc.wstx.dtd.DTDId;
import com.ctc.wstx.dtd.DTDSubset;
import com.ctc.wstx.dtd.FullDTDReaderProxy;
import com.ctc.wstx.evt.DefaultEventAllocator;
import com.ctc.wstx.evt.FilteredEventReader;
import com.ctc.wstx.evt.WstxEventReader;
import com.ctc.wstx.exc.WstxIOException;
import com.ctc.wstx.io.AsciiReader;
import com.ctc.wstx.io.BranchingReaderSource;
import com.ctc.wstx.io.ISOLatinReader;
import com.ctc.wstx.io.InputBootstrapper;
import com.ctc.wstx.io.InputSourceFactory;
import com.ctc.wstx.io.ReaderBootstrapper;
import com.ctc.wstx.io.StreamBootstrapper;
import com.ctc.wstx.io.UTF8Reader;
import com.ctc.wstx.sr.FullStreamReader;
import com.ctc.wstx.sr.ReaderCreator;
import com.ctc.wstx.stax.FilteredStreamReader;
import com.ctc.wstx.util.DefaultXmlSymbolTable;
import com.ctc.wstx.util.SimpleCache;
import com.ctc.wstx.util.StringUtil;
import com.ctc.wstx.util.SymbolTable;
import com.ctc.wstx.util.URLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import javax.xml.stream.EventFilter;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.codehaus.stax2.XMLEventReader2;
import org.codehaus.stax2.XMLInputFactory2;
import org.codehaus.stax2.XMLStreamReader2;

public final class WstxInputFactory
extends XMLInputFactory2
implements ReaderCreator,
InputConfigFlags {
    protected final ReaderConfig mConfig;
    protected XMLEventAllocator mAllocator = null;
    protected SimpleCache mDTDCache = null;
    static final SymbolTable mRootSymbols = DefaultXmlSymbolTable.getInstance();
    SymbolTable mSymbols = mRootSymbols;
    static DefaultEventAllocator sStdAllocator;

    public WstxInputFactory() {
        this.mConfig = ReaderConfig.createFullDefaults(FullDTDReaderProxy.getInstance());
    }

    public synchronized DTDSubset findCachedDTD(DTDId id) {
        return this.mDTDCache == null ? null : (DTDSubset)this.mDTDCache.find(id);
    }

    public synchronized void updateSymbolTable(SymbolTable t) {
        SymbolTable curr = this.mSymbols;
        if (t.isDirectChildOf(curr)) {
            this.mSymbols = t;
        }
    }

    public synchronized void addCachedDTD(DTDId id, DTDSubset extSubset) {
        if (this.mDTDCache == null) {
            this.mDTDCache = new SimpleCache(this.mConfig.getDtdCacheSize());
        }
        this.mDTDCache.add(id, extSubset);
    }

    public XMLEventReader createFilteredReader(XMLEventReader reader, EventFilter filter) {
        return new FilteredEventReader(reader, filter);
    }

    public XMLStreamReader createFilteredReader(XMLStreamReader reader, StreamFilter filter) throws XMLStreamException {
        return new FilteredStreamReader(reader, filter);
    }

    public XMLEventReader createXMLEventReader(InputStream in) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createXMLStreamReader(in));
    }

    public XMLEventReader createXMLEventReader(InputStream in, String enc) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createXMLStreamReader(in, enc));
    }

    public XMLEventReader createXMLEventReader(Reader r) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createXMLStreamReader(r));
    }

    public XMLEventReader createXMLEventReader(Source source) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createXMLStreamReader(source));
    }

    public XMLEventReader createXMLEventReader(String systemId, InputStream in) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createXMLStreamReader(systemId, in));
    }

    public XMLEventReader createXMLEventReader(String systemId, Reader r) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createXMLStreamReader(systemId, r));
    }

    public XMLEventReader createXMLEventReader(XMLStreamReader sr) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), sr);
    }

    public XMLStreamReader createXMLStreamReader(InputStream in) throws XMLStreamException {
        if (in == null) {
            throw new IllegalArgumentException("Null InputStream is not a valid argument");
        }
        return this.createSR(null, StreamBootstrapper.getInstance(in, null, null, this.mConfig.getInputBufferLength()));
    }

    public XMLStreamReader createXMLStreamReader(InputStream in, String enc) throws XMLStreamException {
        if (enc == null || enc.length() == 0) {
            return this.createXMLStreamReader(in);
        }
        Reader r = null;
        int inputBufLen = this.mConfig.getInputBufferLength();
        char c = enc.charAt(0);
        if (c == 'u' || c == 'U') {
            if (StringUtil.equalEncodings(enc, "UTF-8")) {
                r = new UTF8Reader(in, new byte[inputBufLen], 0, 0);
            } else if (StringUtil.equalEncodings(enc, "US-ASCII")) {
                r = new AsciiReader(in, new byte[inputBufLen], 0, 0);
            }
        } else if ((c == 'i' || c == 'I') && StringUtil.equalEncodings(enc, "ISO-8859-1")) {
            r = new ISOLatinReader(in, new byte[inputBufLen], 0, 0);
        }
        if (r == null) {
            try {
                r = new InputStreamReader(in, enc);
            }
            catch (UnsupportedEncodingException ex) {
                throw new XMLStreamException(ex);
            }
        }
        return this.createSR(null, ReaderBootstrapper.getInstance(r, null, null, inputBufLen, enc));
    }

    public XMLStreamReader createXMLStreamReader(Reader r) throws XMLStreamException {
        return this.createXMLStreamReader(null, r);
    }

    public XMLStreamReader createXMLStreamReader(Source src) throws XMLStreamException {
        if (src instanceof StreamSource) {
            InputBootstrapper bs;
            StreamSource ss = (StreamSource)src;
            Reader r = ss.getReader();
            String sysId = ss.getSystemId();
            if (r == null) {
                InputStream in = ss.getInputStream();
                if (in == null) {
                    if (sysId == null) {
                        throw new XMLStreamException("Can not create StAX reader for a StreamSource -- neither reader, input stream nor system id was set.");
                    }
                    try {
                        return this.createXMLStreamReader(URLUtil.urlFromSystemId(sysId));
                    }
                    catch (IOException ioe) {
                        throw new WstxIOException(ioe);
                    }
                }
                bs = StreamBootstrapper.getInstance(in, ss.getPublicId(), sysId, this.mConfig.getInputBufferLength());
            } else {
                bs = ReaderBootstrapper.getInstance(r, ss.getPublicId(), sysId, this.mConfig.getInputBufferLength(), null);
            }
            return this.createSR(sysId, bs);
        }
        if (src instanceof SAXSource) {
            throw new XMLStreamException("Can not create a STaX reader for a SAXSource -- not (yet) implemented.");
        }
        if (src instanceof DOMSource) {
            throw new XMLStreamException("Can not create a STaX reader for a DOMSource -- not (yet) implemented.");
        }
        throw new IllegalArgumentException("Can not instantiate StAX reader for XML source type " + src.getClass() + " (unknown type)");
    }

    public XMLStreamReader createXMLStreamReader(String systemId, InputStream in) throws XMLStreamException {
        return this.createSR(systemId, StreamBootstrapper.getInstance(in, null, systemId, this.mConfig.getInputBufferLength()));
    }

    public XMLStreamReader createXMLStreamReader(String systemId, Reader r) throws XMLStreamException {
        return this.createSR(systemId, ReaderBootstrapper.getInstance(r, null, systemId, this.mConfig.getInputBufferLength(), null));
    }

    public Object getProperty(String name) {
        int id = this.mConfig.getPropertyId(name);
        if (id == 7) {
            return this.getEventAllocator();
        }
        return this.mConfig.getProperty(id);
    }

    public XMLEventAllocator getEventAllocator() {
        return this.mAllocator;
    }

    public XMLReporter getXMLReporter() {
        return this.mConfig.getXMLReporter();
    }

    public XMLResolver getXMLResolver() {
        return this.mConfig.getXMLResolver();
    }

    public boolean isPropertySupported(String name) {
        return this.mConfig.isPropertySupported(name);
    }

    public void setEventAllocator(XMLEventAllocator allocator) {
        this.mAllocator = allocator;
    }

    public void setXMLReporter(XMLReporter r) {
        this.mConfig.setXMLReporter(r);
    }

    public void setXMLResolver(XMLResolver r) {
        this.mConfig.setXMLResolver(r);
    }

    public void setProperty(String propName, Object value) {
        if ("javax.xml.stream.allocator".equals(propName)) {
            this.setEventAllocator((XMLEventAllocator)value);
        } else {
            this.mConfig.setProperty(propName, value);
        }
    }

    public XMLEventReader2 createXMLEventReader(URL src) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createXMLStreamReader(src));
    }

    public XMLEventReader2 createXMLEventReader(File f) throws XMLStreamException {
        return new WstxEventReader(this.createEventAllocator(), this.createXMLStreamReader(f));
    }

    public XMLStreamReader2 createXMLStreamReader(URL src) throws XMLStreamException {
        try {
            return this.createSR(src, URLUtil.optimizedStreamFromURL(src));
        }
        catch (IOException ie) {
            throw new WstxIOException(ie);
        }
    }

    public XMLStreamReader2 createXMLStreamReader(File f) throws XMLStreamException {
        try {
            return this.createSR(f.toURL(), new FileInputStream(f));
        }
        catch (IOException ie) {
            throw new WstxIOException(ie);
        }
    }

    public void configureForXmlConformance() {
        this.mConfig.configureForXmlConformance();
    }

    public void configureForConvenience() {
        this.mConfig.configureForConvenience();
    }

    public void configureForSpeed() {
        this.mConfig.configureForSpeed();
    }

    public void configureForLowMemUsage() {
        this.mConfig.configureForLowMemUsage();
    }

    public void configureForRoundTripping() {
        this.mConfig.configureForRoundTripping();
    }

    public ReaderConfig getConfig() {
        return this.mConfig;
    }

    private FullStreamReader createSR(String systemId, InputBootstrapper bs) throws XMLStreamException {
        URL src = this.mConfig.getBaseURL();
        if (src == null && systemId != null && systemId.length() > 0) {
            try {
                src = URLUtil.urlFromSystemId(systemId);
            }
            catch (IOException ie) {
                throw new WstxIOException(ie);
            }
        }
        return this.createSR(systemId, bs, src);
    }

    private FullStreamReader createSR(String systemId, InputBootstrapper bs, URL src) throws XMLStreamException {
        Reader r;
        try {
            r = bs.bootstrapInput(true, this.getXMLReporter());
        }
        catch (IOException ie) {
            throw new WstxIOException(ie);
        }
        ReaderConfig cfg = this.mConfig.createNonShared(this.mSymbols.makeChild());
        BranchingReaderSource input = InputSourceFactory.constructDocumentSource(bs, null, systemId, src, r, false, cfg.getInputBufferLength());
        try {
            FullStreamReader sr = FullStreamReader.createFullStreamReader(input, this, cfg, bs);
            return sr;
        }
        catch (IOException ie) {
            throw new XMLStreamException(ie);
        }
    }

    private FullStreamReader createSR(URL src, InputStream in) throws XMLStreamException {
        String sysId = src.toExternalForm();
        return this.createSR(sysId, StreamBootstrapper.getInstance(in, null, sysId, this.mConfig.getInputBufferLength()), src);
    }

    protected XMLEventAllocator createEventAllocator() {
        if (this.mAllocator != null) {
            return this.mAllocator.newInstance();
        }
        return this.mConfig.willPreserveLocation() ? DefaultEventAllocator.getDefaultInstance() : DefaultEventAllocator.getFastInstance();
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: java com.ctc.wstx.stax.WstxInputFactory [input file]");
            System.exit(1);
        }
        WstxInputFactory f = new WstxInputFactory();
        System.out.println("Creating stream reader for file '" + args[0] + "'.");
        XMLStreamReader r = f.createXMLStreamReader(new FileInputStream(args[0]));
        r.close();
        System.out.println("Reader created and closed ok, exiting.");
    }

    static {
        mRootSymbols.setInternStrings(true);
        sStdAllocator = null;
    }
}

