/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax2.validation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.xml.stream.FactoryConfigurationError;

public abstract class XMLValidatorFactory {
    static final String JAXP_PROP_FILENAME = "jaxp.properties";
    public static final String SYSTEM_PROPERTY_FOR_IMPL = "org.codehaus.stax2.validation";
    public static final String SERVICE_DEFINITION_PATH = "META-INF/services/org.codehaus.stax2.validation";
    public static final String P_IS_NAMESPACE_AWARE = "org.codehaus2.stax2.validation.isNamespaceAware";

    protected XMLValidatorFactory() {
    }

    public static XMLValidatorFactory newInstance() throws FactoryConfigurationError {
        return XMLValidatorFactory.newInstance(Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLValidatorFactory newInstance(ClassLoader classLoader) throws FactoryConfigurationError {
        SecurityException secEx;
        block18: {
            block17: {
                secEx = null;
                try {
                    String clsName = System.getProperty(SYSTEM_PROPERTY_FOR_IMPL);
                    if (clsName != null && clsName.length() > 0) {
                        return XMLValidatorFactory.newInstance(classLoader, clsName);
                    }
                }
                catch (SecurityException se) {
                    secEx = se;
                }
                try {
                    String home = System.getProperty("java.home");
                    File f = new File(home);
                    f = new File(f, "lib");
                    f = new File(JAXP_PROP_FILENAME);
                    if (!f.exists()) break block17;
                    try {
                        Properties props = new Properties();
                        props.load(new FileInputStream(f));
                        String clsName = props.getProperty(SYSTEM_PROPERTY_FOR_IMPL);
                        if (clsName != null && clsName.length() > 0) {
                            return XMLValidatorFactory.newInstance(classLoader, clsName);
                        }
                    }
                    catch (IOException ioe) {}
                }
                catch (SecurityException se) {
                    secEx = se;
                }
            }
            try {
                InputStream is = classLoader == null ? ClassLoader.getSystemResourceAsStream(SERVICE_DEFINITION_PATH) : classLoader.getResourceAsStream(SERVICE_DEFINITION_PATH);
                if (is == null) break block18;
                BufferedReader rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                String clsName = null;
                try {
                    clsName = rd.readLine();
                    if (clsName != null) {
                        clsName = clsName.trim();
                    }
                }
                finally {
                    rd.close();
                }
                if (clsName != null && clsName.length() > 0) {
                    return XMLValidatorFactory.newInstance(classLoader, clsName);
                }
            }
            catch (SecurityException se) {
                secEx = se;
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        String msg = "No XMLValidatoryFactory implementation class specified or accessible (via 'org.codehaus.stax2.validation' system property, or service definition under 'META-INF/services/org.codehaus.stax2.validation')";
        if (secEx != null) {
            throw new FactoryConfigurationError(msg + " (possibly caused by: " + secEx + ")", secEx);
        }
        throw new FactoryConfigurationError(msg);
    }

    private static XMLValidatorFactory newInstance(ClassLoader cloader, String clsName) throws FactoryConfigurationError {
        try {
            Class<?> factoryClass = cloader == null ? Class.forName(clsName) : cloader.loadClass(clsName);
            return (XMLValidatorFactory)factoryClass.newInstance();
        }
        catch (ClassNotFoundException x) {
            throw new FactoryConfigurationError("XMLValidatoryFactory implementation '" + clsName + "' not found (missing jar in classpath?)", x);
        }
        catch (Exception x) {
            throw new FactoryConfigurationError("XMLValidatoryFactory implementation '" + clsName + "' could not be instantiated: " + x, x);
        }
    }
}

