/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dtd;

import com.ctc.wstx.cfg.ErrorConsts;
import com.ctc.wstx.dtd.DTDAttribute;
import com.ctc.wstx.dtd.DTDElement;
import com.ctc.wstx.dtd.DTDSubset;
import com.ctc.wstx.dtd.ElementId;
import com.ctc.wstx.dtd.ElementIdMap;
import com.ctc.wstx.dtd.NameKey;
import com.ctc.wstx.dtd.StructValidator;
import com.ctc.wstx.exc.WstxValidationException;
import com.ctc.wstx.util.DataUtil;
import com.ctc.wstx.util.StringUtil;
import java.text.MessageFormat;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.Location;
import org.codehaus.stax2.validation.ValidationContext;
import org.codehaus.stax2.validation.XMLValidationException;
import org.codehaus.stax2.validation.XMLValidationSchema;
import org.codehaus.stax2.validation.XMLValidator;

public class DTDValidator
extends XMLValidator {
    static final int DEFAULT_STACK_SIZE = 32;
    static final int EXP_MAX_ATTRS = 32;
    static final HashMap EMPTY_MAP = new HashMap();
    final DTDSubset mSchema;
    final ValidationContext mContext;
    final Map mElemSpecs;
    final Map mGeneralEntities;
    boolean mNormAttrs;
    protected boolean mReportDuplicateErrors = false;
    protected DTDElement mCurrElem = null;
    protected DTDElement[] mElems = null;
    protected HashMap mCurrAttrDefs = null;
    protected BitSet mCurrSpecialAttrs = null;
    boolean mCurrHasAnyFixed = false;
    protected int mElemCount = 0;
    protected StructValidator[] mValidators = null;
    protected DTDAttribute[] mAttrSpecs = null;
    protected int mAttrCount = 1;
    protected int mIdAttrIndex = -1;
    protected ElementIdMap mIdMap = null;
    final transient NameKey mTmpKey = new NameKey(null, null);
    BitSet mTmpSpecialAttrs;
    char[] mTmpAttrValueBuffer = null;

    public DTDValidator(DTDSubset schema, ValidationContext ctxt, Map elemSpecs, Map genEntities) {
        this.mSchema = schema;
        this.mContext = ctxt;
        this.mElemSpecs = elemSpecs == null || elemSpecs.size() == 0 ? Collections.EMPTY_MAP : elemSpecs;
        this.mGeneralEntities = genEntities;
        this.mNormAttrs = true;
        this.mElems = new DTDElement[32];
        this.mValidators = new StructValidator[32];
        this.mAttrSpecs = new DTDAttribute[32];
    }

    public void setAttrValueNormalization(boolean state) {
        this.mNormAttrs = state;
    }

    public XMLValidationSchema getSchema() {
        return this.mSchema;
    }

    public void validateElementStart(String localName, String uri, String prefix) throws XMLValidationException {
        String msg;
        StructValidator pv;
        this.mTmpKey.reset(prefix, localName);
        DTDElement elem = (DTDElement)this.mElemSpecs.get(this.mTmpKey);
        int elemCount = this.mElemCount++;
        if (elemCount >= this.mElems.length) {
            this.mElems = (DTDElement[])DataUtil.growArrayBy50Pct(this.mElems);
            this.mValidators = (StructValidator[])DataUtil.growArrayBy50Pct(this.mValidators);
        }
        this.mElems[elemCount] = this.mCurrElem = elem;
        if (elem == null || !elem.isDefined()) {
            this.reportValidationProblem(ErrorConsts.ERR_VLD_UNKNOWN_ELEM, this.mTmpKey.toString());
        }
        StructValidator structValidator = pv = elemCount > 0 ? this.mValidators[elemCount - 1] : null;
        if (pv != null && (msg = pv.tryToValidate(elem.getName())) != null) {
            int ix = msg.indexOf("$END");
            String pname = this.mElems[elemCount - 1].toString();
            if (ix >= 0) {
                msg = msg.substring(0, ix) + "</" + pname + ">" + msg.substring(ix + 4);
            }
            this.reportValidationProblem("Validation error, encountered element <" + elem.getName() + "> as a child of <" + pname + ">: " + msg);
        }
        if (elem == null) {
            this.mValidators[elemCount] = null;
            this.mCurrAttrDefs = EMPTY_MAP;
            this.mCurrHasAnyFixed = false;
            this.mCurrSpecialAttrs = null;
        } else {
            this.mValidators[elemCount] = elem.getValidator();
            this.mCurrAttrDefs = elem.getAttributes();
            if (this.mCurrAttrDefs == null) {
                this.mCurrAttrDefs = EMPTY_MAP;
            }
            this.mCurrHasAnyFixed = elem.hasFixedAttrs();
            this.mAttrCount = 0;
            this.mIdAttrIndex = -2;
            int specCount = elem.getSpecialCount();
            if (specCount == 0) {
                this.mCurrSpecialAttrs = null;
            } else {
                BitSet bs = this.mTmpSpecialAttrs;
                if (bs == null) {
                    this.mTmpSpecialAttrs = bs = new BitSet(specCount);
                } else {
                    bs.clear();
                }
                this.mCurrSpecialAttrs = bs;
            }
        }
    }

    public String validateAttribute(String localName, String uri, String prefix, String value) throws XMLValidationException {
        String exp;
        String act;
        int specIndex;
        int index;
        DTDAttribute attr = (DTDAttribute)this.mCurrAttrDefs.get(this.mTmpKey.reset(prefix, localName));
        if (attr == null) {
            if (this.mCurrElem == null) {
                return null;
            }
            this.reportValidationProblem(ErrorConsts.ERR_VLD_UNKNOWN_ATTR, this.mCurrElem.toString(), this.mTmpKey.toString());
        }
        if ((index = this.mAttrCount++) >= this.mAttrSpecs.length) {
            this.mAttrSpecs = (DTDAttribute[])DataUtil.growArrayBy50Pct(this.mAttrSpecs);
        }
        this.mAttrSpecs[index] = attr;
        if (this.mCurrSpecialAttrs != null && (specIndex = attr.getSpecialIndex()) >= 0) {
            this.mCurrSpecialAttrs.set(specIndex);
        }
        String result = attr.validate(this, value, this.mNormAttrs);
        if (this.mCurrHasAnyFixed && attr.isFixed() && !(act = result == null ? value : result).equals(exp = attr.getDefaultValue())) {
            this.reportValidationProblem("Value of attribute \"" + attr + "\" (element <" + this.mCurrElem + ">) not \"" + exp + "\" as expected, but \"" + act + "\"");
        }
        return result;
    }

    public String validateAttribute(String localName, String uri, String prefix, char[] valueChars, int valueStart, int valueEnd) throws XMLValidationException {
        int specIndex;
        int index;
        DTDAttribute attr = (DTDAttribute)this.mCurrAttrDefs.get(this.mTmpKey.reset(prefix, localName));
        if (attr == null) {
            if (this.mCurrElem == null) {
                return null;
            }
            this.reportValidationProblem(ErrorConsts.ERR_VLD_UNKNOWN_ATTR, this.mCurrElem.toString(), this.mTmpKey.toString());
        }
        if ((index = this.mAttrCount++) >= this.mAttrSpecs.length) {
            this.mAttrSpecs = (DTDAttribute[])DataUtil.growArrayBy50Pct(this.mAttrSpecs);
        }
        this.mAttrSpecs[index] = attr;
        if (this.mCurrSpecialAttrs != null && (specIndex = attr.getSpecialIndex()) >= 0) {
            this.mCurrSpecialAttrs.set(specIndex);
        }
        String result = attr.validate(this, valueChars, valueStart, valueEnd, this.mNormAttrs);
        if (this.mCurrHasAnyFixed && attr.isFixed()) {
            String exp = attr.getDefaultValue();
            boolean match = result == null ? StringUtil.matches(exp, valueChars, valueStart, valueEnd) : exp.equals(result);
            if (!match) {
                String act = result == null ? new String(valueChars, valueStart, valueEnd) : result;
                this.reportValidationProblem("Value of #FIXED attribute \"" + attr + "\" (element <" + this.mCurrElem + ">) not \"" + exp + "\" as expected, but \"" + act + "\"");
            }
        }
        return result;
    }

    public int validateElementAndAttributes() throws XMLValidationException {
        DTDElement elem = this.mCurrElem;
        if (elem == null) {
            return 3;
        }
        if (this.mCurrSpecialAttrs != null) {
            BitSet specBits = this.mCurrSpecialAttrs;
            int specCount = elem.getSpecialCount();
            int ix = specBits.nextClearBit(0);
            while (ix < specCount) {
                int defIx;
                String def;
                List specAttrs = elem.getSpecialAttrs();
                DTDAttribute attr = (DTDAttribute)specAttrs.get(ix);
                if (attr.isRequired()) {
                    this.reportValidationProblem("Required attribute '" + attr + "' missing from element <" + elem + ">");
                }
                if ((def = attr.getDefaultValue()) == null) {
                    throw new Error("Internal error: null default attribute value");
                }
                NameKey an = attr.getName();
                String prefix = an.getPrefix();
                String uri = "";
                if (prefix != null && prefix.length() > 0 && ((uri = this.mContext.getNamespaceURI(prefix)) == null || uri.length() == 0)) {
                    this.reportValidationProblem("Unbound namespace prefix '" + prefix + "' for default attribute " + attr);
                    uri = "";
                }
                if ((defIx = this.mContext.addDefaultAttribute(an.getLocalName(), uri, prefix, def)) >= 0) {
                    while (defIx >= this.mAttrSpecs.length) {
                        this.mAttrSpecs = (DTDAttribute[])DataUtil.growArrayBy50Pct(this.mAttrSpecs);
                    }
                    while (this.mAttrCount < defIx) {
                        this.mAttrSpecs[this.mAttrCount++] = null;
                    }
                    this.mAttrSpecs[defIx] = attr;
                    this.mAttrCount = defIx + 1;
                }
                ix = specBits.nextClearBit(ix + 1);
            }
        }
        return elem.getAllowedContent();
    }

    public int validateElementEnd(String localName, String uri, String prefix) throws XMLValidationException {
        String msg;
        int ix = --this.mElemCount;
        DTDElement closingElem = this.mElems[ix];
        this.mElems[ix] = null;
        StructValidator v = this.mValidators[ix];
        this.mValidators[ix] = null;
        if (v != null && (msg = v.fullyValid()) != null) {
            this.reportValidationProblem("Validation error, element </" + closingElem + ">: " + msg);
        }
        if (ix < 1) {
            ElementId ref;
            if (this.mIdMap != null && (ref = this.mIdMap.getFirstUndefined()) != null) {
                this.reportValidationProblem("Undefined id '" + ref.getId() + "': referenced from element <" + ref.getElemName() + ">, attribute '" + ref.getAttrName() + "'", ref.getLocation());
            }
            return 1;
        }
        return this.mElems[ix - 1].getAllowedContent();
    }

    public void validateText(String text, boolean lastTextSegment) throws XMLValidationException {
    }

    public void validateText(char[] cbuf, int textStart, int textEnd, boolean lastTextSegment) throws XMLValidationException {
    }

    public void validationCompleted(boolean eod) throws XMLValidationException {
    }

    public String getAttributeType(int index) {
        return this.mAttrSpecs[index].getValueTypeString();
    }

    public int getIdAttrIndex() {
        int ix = this.mIdAttrIndex;
        if (ix == -2) {
            DTDAttribute idAttr;
            ix = -1;
            if (this.mCurrElem != null && (idAttr = this.mCurrElem.getIdAttribute()) != null) {
                DTDAttribute[] attrs = this.mAttrSpecs;
                int len = attrs.length;
                for (int i = 0; i < len; ++i) {
                    if (attrs[i] != idAttr) continue;
                    ix = i;
                    break;
                }
            }
            this.mIdAttrIndex = ix;
        }
        return ix;
    }

    public int getNotationAttrIndex() {
        int len = this.mAttrCount;
        for (int i = 0; i < len; ++i) {
            if (!this.mAttrSpecs[i].typeIsNotation()) continue;
            return i;
        }
        return -1;
    }

    NameKey getElemName() {
        DTDElement elem = this.mElems[this.mElemCount - 1];
        return elem.getName();
    }

    Location getLocation() {
        return this.mContext.getValidationLocation();
    }

    ElementIdMap getIdMap() {
        if (this.mIdMap == null) {
            this.mIdMap = new ElementIdMap();
        }
        return this.mIdMap;
    }

    Map getEntityMap() {
        return this.mGeneralEntities;
    }

    char[] getTempAttrValueBuffer(int neededLength) {
        if (this.mTmpAttrValueBuffer == null || this.mTmpAttrValueBuffer.length < neededLength) {
            int size = neededLength < 100 ? 100 : neededLength;
            this.mTmpAttrValueBuffer = new char[size];
        }
        return this.mTmpAttrValueBuffer;
    }

    void reportValidationProblem(String msg) throws XMLValidationException {
        this.doReportProblem(msg, null);
    }

    void reportValidationProblem(String msg, Location loc) throws XMLValidationException {
        this.doReportProblem(msg, loc);
    }

    void reportValidationProblem(String format, String arg) throws XMLValidationException {
        this.doReportProblem(MessageFormat.format(format, arg), null);
    }

    void reportValidationProblem(String format, String arg1, String arg2) throws XMLValidationException {
        this.doReportProblem(MessageFormat.format(format, arg1, arg2), null);
    }

    protected void doReportProblem(String msg, Location loc) throws XMLValidationException {
        if (loc == null) {
            loc = this.getLocation();
        }
        throw WstxValidationException.create(msg, loc, 2);
    }
}

