/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.io;

import com.ctc.wstx.io.WstxInputData;
import com.ctc.wstx.io.WstxInputLocation;
import java.io.IOException;
import java.net.URL;

public abstract class WstxInputSource {
    protected final WstxInputSource mParent;
    final String mFromEntity;

    protected WstxInputSource(WstxInputSource parent, String fromEntity) {
        this.mParent = parent;
        this.mFromEntity = fromEntity;
    }

    public abstract int getInputBufferLength();

    public final WstxInputSource getParent() {
        return this.mParent;
    }

    public boolean hasRecursion() {
        String entityId = this.mFromEntity;
        if (entityId != null) {
            WstxInputSource input = this.mParent;
            while (input != null) {
                if (input.mFromEntity == entityId) {
                    return true;
                }
                input = input.mParent;
            }
        }
        return false;
    }

    public abstract URL getSource();

    public abstract String getPublicId();

    public abstract String getSystemId();

    protected abstract WstxInputLocation getLocation();

    public abstract WstxInputLocation getLocation(long var1, int var3, int var4);

    public abstract void initInputLocation(WstxInputData var1);

    public abstract int readInto(WstxInputData var1) throws IOException;

    public abstract boolean readMore(WstxInputData var1, int var2) throws IOException;

    public abstract void saveContext(WstxInputData var1);

    public abstract void restoreContext(WstxInputData var1);

    public abstract void close() throws IOException;

    public abstract void closeCompletely() throws IOException;

    public String toString() {
        StringBuffer sb = new StringBuffer(80);
        sb.append("<WstxInputSource [class ");
        sb.append(this.getClass().toString());
        sb.append("]; systemId: ");
        sb.append(this.getSystemId());
        sb.append(", source: ");
        sb.append(this.getSource());
        sb.append('>');
        return sb.toString();
    }
}

