/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.evt;

import com.ctc.wstx.cfg.ErrorConsts;
import com.ctc.wstx.exc.WstxParsingException;
import com.ctc.wstx.util.ExceptionUtil;
import java.util.NoSuchElementException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.XMLEventAllocator;
import org.codehaus.stax2.XMLEventReader2;

public class WstxEventReader
implements XMLEventReader2,
XMLStreamConstants {
    protected static final int STATE_INITIAL = 1;
    protected static final int STATE_EOD = 2;
    protected static final int STATE_CONTENT = 3;
    private final XMLEventAllocator mAllocator;
    private final XMLStreamReader mReader;
    private XMLEvent mPeekedEvent = null;
    protected int mState = 1;
    protected int mPrePeekEvent = 7;

    public WstxEventReader(XMLEventAllocator a, XMLStreamReader r) {
        this.mAllocator = a;
        this.mReader = r;
    }

    public void close() throws XMLStreamException {
        this.mReader.close();
    }

    public String getElementText() throws XMLStreamException {
        if (this.mPeekedEvent == null) {
            return this.mReader.getElementText();
        }
        XMLEvent evt = this.mPeekedEvent;
        this.mPeekedEvent = null;
        if (this.mPrePeekEvent != 1) {
            throw new WstxParsingException(ErrorConsts.ERR_STATE_NOT_STELEM, evt.getLocation());
        }
        String str = null;
        StringBuffer sb = null;
        while (!evt.isEndElement()) {
            int type = evt.getEventType();
            if (type == 5 || type == 3) {
                // empty if block
            }
            if (!evt.isCharacters()) {
                throw new WstxParsingException("Expected a text token, got " + ErrorConsts.tokenTypeDesc(type), evt.getLocation());
            }
            String curr = evt.asCharacters().getData();
            if (str == null) {
                str = curr;
            } else {
                if (sb == null) {
                    sb = new StringBuffer(str.length() + curr);
                    sb.append(str);
                }
                sb.append(curr);
            }
            evt = this.nextEvent();
        }
        if (sb != null) {
            return sb.toString();
        }
        return str == null ? "" : str;
    }

    public Object getProperty(String name) {
        return this.mReader.getProperty(name);
    }

    public boolean hasNext() {
        return this.mState != 2;
    }

    public XMLEvent nextEvent() throws XMLStreamException {
        if (this.mState == 2) {
            throw new NoSuchElementException();
        }
        if (this.mState == 1) {
            this.mState = 3;
            return this.createStartEvent();
        }
        if (this.mPeekedEvent != null) {
            XMLEvent evt = this.mPeekedEvent;
            this.mPeekedEvent = null;
            if (evt.isEndDocument()) {
                this.mState = 2;
            }
            return evt;
        }
        return this.createNextEvent(true, this.mReader.next());
    }

    public Object next() {
        try {
            return this.nextEvent();
        }
        catch (XMLStreamException sex) {
            this.throwFromSex(sex);
            return null;
        }
    }

    public XMLEvent nextTag() throws XMLStreamException {
        if (this.mPeekedEvent != null) {
            XMLEvent evt = this.mPeekedEvent;
            this.mPeekedEvent = null;
            switch (evt.getEventType()) {
                case 8: {
                    return null;
                }
                case 3: 
                case 5: 
                case 6: {
                    break;
                }
                case 4: 
                case 12: {
                    if (((Characters)evt).isWhiteSpace()) break;
                    this.throwParseError("Received non-all-whitespace CHARACTERS or CDATA event in nextTag().");
                    break;
                }
                case 1: 
                case 2: {
                    return evt;
                }
                default: {
                    this.throwParseError("Received event " + evt.getEventType() + ", instead of START_ELEMENT or END_ELEMENT.");
                }
            }
        } else if (this.mState == 1) {
            this.mState = 3;
        }
        block12: while (true) {
            int next = this.mReader.next();
            switch (next) {
                case 8: {
                    return null;
                }
                case 3: 
                case 5: 
                case 6: {
                    continue block12;
                }
                case 4: 
                case 12: {
                    if (this.mReader.isWhiteSpace()) continue block12;
                    this.throwParseError("Received non-all-whitespace CHARACTERS or CDATA event in nextTag().");
                    continue block12;
                }
                case 1: 
                case 2: {
                    return this.createNextEvent(false, next);
                }
            }
            this.throwParseError("Received event " + next + ", instead of START_ELEMENT or END_ELEMENT.");
        }
    }

    public XMLEvent peek() throws XMLStreamException {
        if (this.mPeekedEvent == null) {
            if (this.mState == 2) {
                this.throwEOD();
            }
            if (this.mState == 1) {
                this.mPrePeekEvent = 7;
                this.mPeekedEvent = this.createStartEvent();
                this.mState = 3;
            } else {
                this.mPrePeekEvent = this.mReader.getEventType();
                this.mPeekedEvent = this.createNextEvent(false, this.mReader.next());
            }
        }
        return this.mPeekedEvent;
    }

    public void remove() {
        throw new UnsupportedOperationException("Can not remove events from XMLEventReader.");
    }

    public boolean hasNextEvent() throws XMLStreamException {
        return this.mState != 2;
    }

    protected XMLEvent createNextEvent(boolean checkEOD, int type) throws XMLStreamException {
        XMLEvent evt = this.mAllocator.allocate(this.mReader);
        if (checkEOD && type == 8) {
            this.mState = 2;
        }
        return evt;
    }

    protected XMLEvent createStartEvent() throws XMLStreamException {
        XMLEvent start = this.mAllocator.allocate(this.mReader);
        return start;
    }

    private void throwEOD() {
        throw new NoSuchElementException();
    }

    protected void throwFromSex(XMLStreamException sex) {
        ExceptionUtil.throwRuntimeException(sex);
    }

    protected void throwParseError(String msg) throws XMLStreamException {
        this.throwParseError(msg, this.mReader.getLocation());
    }

    protected void throwParseError(String msg, Location loc) throws XMLStreamException {
        throw new WstxParsingException(msg, loc);
    }
}

