/*
 * Decompiled with CFR 0.152.
 */
package work.lince.commons.rest.client;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import work.lince.commons.authentication.AuthenticationService;

@Configuration
public class AuthenticationFeignInterceptor
implements RequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationFeignInterceptor.class);
    @Value(value="${lince.userName:lince.user.name}")
    protected String userNameHeader;
    @Autowired
    protected AuthenticationService authenticationService;

    public void apply(RequestTemplate requestTemplate) {
        log.trace("[processName:apply][{}:{}]", (Object)this.userNameHeader, (Object)this.authenticationService.getAuthenticatedUser());
        requestTemplate.header(this.userNameHeader, new String[]{this.authenticationService.getAuthenticatedUser()});
    }
}

