/*
 * Decompiled with CFR 0.152.
 */
package com.shart.work.util;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.shart.work.util.Excel;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ExcelUtil {
    private static List data;
    private static Workbook workbook;
    private static Sheet sheet;
    private static String title;
    private static Map<String, CellStyle> cellStyleMap;
    private static Class<?> object;
    private static List<Object[]> fieldList;
    private static int rowNum;
    private static int importCellNum;
    private static HttpServletResponse resp;

    private static HttpServletResponse getResp() {
        if (ObjectUtil.isNotEmpty((Object)RequestContextHolder.getRequestAttributes())) {
            return ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getResponse();
        }
        return null;
    }

    public static <T> void excelExportLocalMachine(Class<?> objectClass, Collection<T> dataList, String sheetName, String title, String filePath) {
        if (dataList.isEmpty()) {
            dataList = Lists.newArrayList();
        }
        fieldList = Lists.newArrayList();
        object = objectClass;
        data = dataList;
        ExcelUtil.createWorkBook(sheetName, title);
        ExcelUtil.createCellStyle();
        ExcelUtil.createFields();
        ExcelUtil.createTitle();
        ExcelUtil.createHeader();
        ExcelUtil.createCellTable();
        ExcelUtil.writeFile(filePath);
    }

    public static <T> void excelExport(Class<?> objectClass, Collection<T> dataList, String sheetName, String title, String fileName) {
        if (dataList.isEmpty()) {
            dataList = Lists.newArrayList();
        }
        fieldList = Lists.newArrayList();
        object = objectClass;
        data = dataList;
        ExcelUtil.createWorkBook(sheetName, title);
        ExcelUtil.createCellStyle();
        ExcelUtil.createFields();
        ExcelUtil.createTitle();
        ExcelUtil.createHeader();
        ExcelUtil.createCellTable();
        ExcelUtil.download(fileName);
    }

    public static <T> void dowlonadImportTemplateLocalMachine(Class<?> objectClass, String sheetName, String title, String path) {
        fieldList = Lists.newArrayList();
        object = objectClass;
        data = Lists.newArrayList();
        ExcelUtil.createWorkBook(sheetName, title);
        ExcelUtil.createCellStyle();
        ExcelUtil.createFields();
        ExcelUtil.createTitle();
        ExcelUtil.createHeader();
        ExcelUtil.createCellTable();
        ExcelUtil.writeFile(path);
    }

    public static <T> void dowlonadImportTemplate(Class<?> objectClass, String sheetName, String title, String fileName) {
        fieldList = Lists.newArrayList();
        object = objectClass;
        data = Lists.newArrayList();
        ExcelUtil.createWorkBook(sheetName, title);
        ExcelUtil.createCellStyle();
        ExcelUtil.createFields();
        ExcelUtil.createTitle();
        ExcelUtil.createHeader();
        ExcelUtil.createCellTable();
        ExcelUtil.download(fileName);
    }

    public static <T> List<T> excelImportLocalMachine(String sheetName, InputStream inputStream, Class<T> objectClass) {
        ArrayList data = Lists.newArrayList();
        try {
            Sheet sheet;
            object = objectClass;
            fieldList = Lists.newArrayList();
            ExcelUtil.createFields();
            workbook = WorkbookFactory.create((InputStream)inputStream);
            Sheet sheet2 = sheet = StrUtil.isEmpty((CharSequence)sheetName) ? workbook.getSheetAt(0) : workbook.getSheet(sheetName);
            if (sheet == null) {
                throw new RuntimeException("sheet\u9875\u4e0d\u5b58\u5728");
            }
            for (int i = importCellNum; i < sheet.getLastRowNum(); ++i) {
                Row row = sheet.getRow(i);
                Object object = ReflectUtil.newInstance(objectClass, (Object[])new Object[0]);
                for (int j = 0; j < row.getLastCellNum(); ++j) {
                    Field field = (Field)fieldList.get(j)[0];
                    Cell cell = row.getCell(j);
                    Method method = object.getClass().getMethod(ExcelUtil.parSetName(field.getName()), Class.forName(ExcelUtil.valType(field, cell.getStringCellValue())[0].toString()));
                    method.invoke(object, ExcelUtil.valType(field, cell.getStringCellValue())[1]);
                }
                data.add(object);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return data;
    }

    private static Object[] valType(Field field, String val) {
        if (StrUtil.equals((CharSequence)"java.lang.Long", (CharSequence)field.getType().getTypeName())) {
            return new Object[]{"java.lang.Long", Long.valueOf(val)};
        }
        if (StrUtil.equals((CharSequence)"java.lang.String", (CharSequence)field.getType().getTypeName())) {
            return new Object[]{"java.lang.String", String.valueOf(val)};
        }
        if (StrUtil.equals((CharSequence)"java.lang.Integer", (CharSequence)field.getType().getTypeName())) {
            return new Object[]{"java.lang.Integer", Integer.valueOf(val)};
        }
        if (StrUtil.equals((CharSequence)"java.lang.Double", (CharSequence)field.getType().getTypeName())) {
            return new Object[]{"java.lang.Double", Double.valueOf(val)};
        }
        return null;
    }

    private static String parSetName(String fieldName) {
        return "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    private static void createWorkBook(String sheetName, String tableTitle) {
        workbook = new SXSSFWorkbook(600);
        sheet = workbook.createSheet(sheetName);
        title = tableTitle;
    }

    private static void createCellStyle() {
        cellStyleMap = Maps.newHashMap();
        CellStyle titleStyle = workbook.createCellStyle();
        titleStyle.setAlignment(HorizontalAlignment.CENTER);
        titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        Font titleFont = workbook.createFont();
        titleFont.setFontName("Arial");
        titleFont.setFontHeightInPoints((short)18);
        titleFont.setBold(true);
        titleStyle.setFont(titleFont);
        cellStyleMap.put("title", titleStyle);
        CellStyle headerStyle = workbook.createCellStyle();
        headerStyle.setAlignment(HorizontalAlignment.CENTER);
        headerStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headerStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headerStyle.setBorderBottom(BorderStyle.THIN);
        headerStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        headerStyle.setBorderLeft(BorderStyle.THIN);
        headerStyle.setLeftBorderColor(IndexedColors.GREEN.getIndex());
        headerStyle.setBorderRight(BorderStyle.THIN);
        headerStyle.setRightBorderColor(IndexedColors.BLUE.getIndex());
        headerStyle.setBorderTop(BorderStyle.MEDIUM_DASHED);
        headerStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cellStyleMap.put("header", headerStyle);
        CellStyle dataStyle = workbook.createCellStyle();
        dataStyle.setAlignment(HorizontalAlignment.CENTER);
        dataStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        dataStyle.setBorderBottom(BorderStyle.THICK);
        dataStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        dataStyle.setBorderLeft(BorderStyle.THICK);
        dataStyle.setLeftBorderColor(IndexedColors.GREEN.getIndex());
        dataStyle.setBorderRight(BorderStyle.THICK);
        dataStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        dataStyle.setBorderTop(BorderStyle.THICK);
        dataStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        dataStyle.setFillForegroundColor(IndexedColors.ORANGE.getIndex());
        dataStyle.setFillPattern(FillPatternType.FINE_DOTS);
        dataStyle.setWrapText(true);
        cellStyleMap.put("data", dataStyle);
    }

    private static void createTitle() {
        int n;
        if (rowNum == 0) {
            int n2 = rowNum;
            n = n2;
            rowNum = n2 + 1;
        } else {
            n = rowNum;
        }
        Row row = sheet.createRow(n);
        Cell cell = row.createCell(0);
        cell.setCellValue(title);
        cell.setCellStyle(cellStyleMap.get("title"));
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, fieldList.size() - 1));
    }

    private static void createHeader() {
        int n;
        if (rowNum == 0) {
            int n2 = rowNum;
            n = n2;
            rowNum = n2 + 1;
        } else {
            n = rowNum;
        }
        Row row = sheet.createRow(n);
        for (int i = 0; i < fieldList.size(); ++i) {
            Excel excel = (Excel)fieldList.get(i)[1];
            Cell cell = row.createCell(i);
            cell.setCellValue(excel.titleName());
            cell.setCellStyle(cellStyleMap.get("header"));
        }
    }

    private static <T> void createCellTable() {
        for (int i = 0; i < data.size(); ++i) {
            Row row = sheet.createRow(++rowNum);
            Object dataObject = data.get(i);
            for (int j = 0; j < fieldList.size(); ++j) {
                Field field = (Field)fieldList.get(j)[0];
                Excel excel = (Excel)fieldList.get(j)[1];
                Cell cell = row.createCell(j);
                String cellVal = String.valueOf(ReflectUtil.getFieldValue(dataObject, (Field)field));
                cell.setCellValue(cellVal);
                if (StrUtil.isNotEmpty((CharSequence)excel.dictType())) {
                    cell.setCellValue(ExcelUtil.convertDictType(excel, cellVal));
                }
                cell.setCellStyle(cellStyleMap.get("data"));
            }
        }
    }

    private static String convertDictType(Excel excel, String cellVal) {
        if (excel.dictType().equals("user_status")) {
            if (cellVal.equals("0")) {
                return "\u62d2\u7edd";
            }
            if (cellVal.equals("1")) {
                return "\u540c\u610f";
            }
        }
        return "\u9a73\u56de";
    }

    private static void createFields() {
        Field[] fields;
        for (Field field : fields = object.getDeclaredFields()) {
            Excel excel = field.getDeclaredAnnotation(Excel.class);
            if (excel == null || !StrUtil.containsAnyIgnoreCase((CharSequence)excel.type(), (CharSequence[])new CharSequence[]{"\u5bfc\u51fa", "\u5bfc\u5165"})) continue;
            field.setAccessible(true);
            fieldList.add(new Object[]{field, excel});
        }
    }

    private static void writeFile(String path) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(path);
            workbook.write((OutputStream)fileOutputStream);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void download(String fileName) {
        try {
            resp.addHeader("Content-disposition", String.format("attachment;filename=%s.xls", new String(fileName.getBytes("gbk"), "iso8859-1")));
            resp.setContentType("octets/stream;rset=UTF-8");
            ServletOutputStream out = resp.getOutputStream();
            workbook.write((OutputStream)out);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        importCellNum = 2;
        resp = ExcelUtil.getResp();
    }
}

