/*
 * Decompiled with CFR 0.152.
 */
package work.socialhub.kbsky.auth;

import dev.whyoleg.cryptography.CryptographyAlgorithmId;
import dev.whyoleg.cryptography.CryptographyProvider;
import dev.whyoleg.cryptography.algorithms.EC;
import dev.whyoleg.cryptography.algorithms.ECDSA;
import dev.whyoleg.cryptography.algorithms.SHA256;
import dev.whyoleg.cryptography.materials.key.KeyDecoder;
import dev.whyoleg.cryptography.materials.key.KeyFormat;
import io.ktor.http.URLUtilsKt;
import io.ktor.http.Url;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.encoding.Base64;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import work.socialhub.kbsky.auth.AuthProvider;
import work.socialhub.kbsky.auth.OAuthProvider$Jwt$;
import work.socialhub.kbsky.auth.OAuthSession;
import work.socialhub.kbsky.auth.helper.OAuthHelper;
import work.socialhub.kbsky.internal.share._InternalUtility;
import work.socialhub.khttpclient.HttpRequest;
import work.socialhub.khttpclient.HttpResponse;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001&B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\n\u0010\u001f\u001a\u00020\u0003*\u00020\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\nR\u0014\u0010\u0010\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\nR\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R \u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030!X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u0006'"}, d2={"Lwork/socialhub/kbsky/auth/OAuthProvider;", "Lwork/socialhub/kbsky/auth/AuthProvider;", "accessTokenJwt", "", "refreshTokenJwt", "session", "Lwork/socialhub/kbsky/auth/OAuthSession;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lwork/socialhub/kbsky/auth/OAuthSession;)V", "getAccessTokenJwt", "()Ljava/lang/String;", "getRefreshTokenJwt", "getSession", "()Lwork/socialhub/kbsky/auth/OAuthSession;", "did", "getDid", "pdsDid", "getPdsDid", "jwt", "Lwork/socialhub/kbsky/auth/OAuthProvider$Jwt;", "getJwt", "()Lwork/socialhub/kbsky/auth/OAuthProvider$Jwt;", "beforeRequestHook", "", "method", "request", "Lwork/socialhub/khttpclient/HttpRequest;", "afterRequestHook", "", "response", "Lwork/socialhub/khttpclient/HttpResponse;", "getUrl", "acceptLabelers", "", "getAcceptLabelers", "()Ljava/util/List;", "setAcceptLabelers", "(Ljava/util/List;)V", "Jwt", "auth"})
@SourceDebugExtension(value={"SMAP\nOAuthProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OAuthProvider.kt\nwork/socialhub/kbsky/auth/OAuthProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _InternalUtility.kt\nwork/socialhub/kbsky/internal/share/_InternalUtility\n+ 5 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,119:1\n739#2,9:120\n37#3:129\n36#3,3:130\n38#4:133\n222#5:134\n*S KotlinDebug\n*F\n+ 1 OAuthProvider.kt\nwork/socialhub/kbsky/auth/OAuthProvider\n*L\n34#1:120,9\n35#1:129\n35#1:130,3\n39#1:133\n39#1:134\n*E\n"})
public final class OAuthProvider
implements AuthProvider {
    @NotNull
    private final String accessTokenJwt;
    @Nullable
    private final String refreshTokenJwt;
    @NotNull
    private final OAuthSession session;
    @NotNull
    private List<String> acceptLabelers;

    public OAuthProvider(@NotNull String accessTokenJwt, @Nullable String refreshTokenJwt, @NotNull OAuthSession session) {
        Intrinsics.checkNotNullParameter((Object)accessTokenJwt, (String)"accessTokenJwt");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.accessTokenJwt = accessTokenJwt;
        this.refreshTokenJwt = refreshTokenJwt;
        this.session = session;
        this.acceptLabelers = CollectionsKt.emptyList();
    }

    public /* synthetic */ OAuthProvider(String string, String string2, OAuthSession oAuthSession, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        this(string, string2, oAuthSession);
    }

    @NotNull
    public final String getAccessTokenJwt() {
        return this.accessTokenJwt;
    }

    @Nullable
    public final String getRefreshTokenJwt() {
        return this.refreshTokenJwt;
    }

    @NotNull
    public final OAuthSession getSession() {
        return this.session;
    }

    @NotNull
    public String getDid() {
        return this.getJwt().getSub();
    }

    @NotNull
    public String getPdsDid() {
        return this.getJwt().getAud();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Jwt getJwt() {
        void this_$iv;
        List list;
        CharSequence charSequence = this.accessTokenJwt;
        Regex regex = new Regex("\\.");
        int n = 0;
        List $this$dropLastWhile$iv = regex.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray22 = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String encodedJson = thisCollection$iv.toArray(new String[0])[1];
        byte[] decodedJson = Base64.decode$default((Base64)Base64.Default.withPadding(Base64.PaddingOption.PRESENT_OPTIONAL), (CharSequence)encodedJson, (int)0, (int)0, (int)6, null);
        _InternalUtility $i$f$toTypedArray22 = _InternalUtility.INSTANCE;
        String obj$iv = StringsKt.decodeToString((byte[])decodedJson);
        boolean $i$f$fromJson = false;
        Json this_$iv$iv = this_$iv.getJson();
        boolean $i$f$decodeFromString = false;
        this_$iv$iv.getSerializersModule();
        return (Jwt)this_$iv$iv.decodeFromString((DeserializationStrategy)Jwt.Companion.serializer(), obj$iv);
    }

    public void beforeRequestHook(@NotNull String method, @NotNull HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Base64 base64 = (Base64)Base64.Default;
        String string = this.session.getPublicKey();
        Intrinsics.checkNotNull((Object)string);
        Pair<byte[], byte[]> publicKeyXY = OAuthHelper.INSTANCE.extractXYFromPublicKey(Base64.decode$default((Base64)base64, (CharSequence)string, (int)0, (int)0, (int)6, null));
        String string2 = this.session.getClientId();
        Intrinsics.checkNotNull((Object)string2);
        String string3 = this.getUrl(request);
        String string4 = this.session.getDPoPNonce();
        Intrinsics.checkNotNull((Object)string4);
        String dPoPHeader = OAuthHelper.INSTANCE.makeDPoPHeader(string2, string3, method, string4, this.accessTokenJwt, this.getJwt().getIss(), (byte[])publicKeyXY.getFirst(), (byte[])publicKeyXY.getSecond(), (Function1<? super String, byte[]>)((Function1)arg_0 -> OAuthProvider.beforeRequestHook$lambda$1(this, arg_0)));
        request.header("Authorization", "DPoP " + this.accessTokenJwt);
        request.header("DPoP", dPoPHeader);
    }

    public boolean afterRequestHook(@NotNull String method, @NotNull HttpRequest request, @NotNull HttpResponse response) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        OAuthHelper.INSTANCE.extractDPoPNonce(response, this.session);
        return response.getStatus() == 401 && StringsKt.contains$default((CharSequence)response.getStringBody(), (CharSequence)"use_dpop_nonce", (boolean)false, (int)2, null);
    }

    @NotNull
    public final String getUrl(@NotNull HttpRequest $this$getUrl) {
        Object object;
        block3: {
            Object p;
            block4: {
                String it;
                block2: {
                    Intrinsics.checkNotNullParameter((Object)$this$getUrl, (String)"<this>");
                    object = $this$getUrl.getUrl();
                    if (object == null) break block2;
                    it = object;
                    boolean bl = false;
                    Url u = URLUtilsKt.Url((String)it);
                    boolean bl2 = false;
                    String string = u.getProtocol().getName() + "://" + u.getHost() + ":" + u.getPort() + u.getEncodedPath();
                    object = string;
                    if (string != null) break block3;
                }
                it = $this$getUrl;
                boolean bl = false;
                String string = $this$getUrl.getPath();
                Intrinsics.checkNotNull((Object)string);
                p = StringsKt.startsWith$default((String)string, (String)"/", (boolean)false, (int)2, null) ? $this$getUrl.getPath() : "/" + $this$getUrl.getPath();
                object = $this$getUrl.getPort();
                if (object == null) break block4;
                int it2 = ((Number)object).intValue();
                boolean bl3 = false;
                String string2 = $this$getUrl.getSchema() + "://" + $this$getUrl.getHost() + ":" + $this$getUrl.getPort() + (String)p;
                object = string2;
                if (string2 != null) break block3;
            }
            HttpRequest it = $this$getUrl;
            boolean bl = false;
            object = $this$getUrl.getSchema() + "://" + $this$getUrl.getHost() + (String)p;
        }
        return object;
    }

    @NotNull
    public List<String> getAcceptLabelers() {
        return this.acceptLabelers;
    }

    public void setAcceptLabelers(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.acceptLabelers = list;
    }

    private static final byte[] beforeRequestHook$lambda$1(OAuthProvider this$0, String jwtMessage) {
        Intrinsics.checkNotNullParameter((Object)jwtMessage, (String)"jwtMessage");
        CryptographyProvider provider = CryptographyProvider.Companion.getDefault();
        KeyDecoder keyDecoder = ((ECDSA)provider.get((CryptographyAlgorithmId)ECDSA.Companion)).privateKeyDecoder-yfdS0HE(EC.Curve.Companion.getP256-pVITJAk());
        KeyFormat keyFormat = (KeyFormat)EC.PrivateKey.Format.DER.Generic;
        Base64 base64 = (Base64)Base64.Default;
        String string = this$0.session.getPrivateKey();
        Intrinsics.checkNotNull((Object)string);
        ECDSA.PrivateKey privateKey = (ECDSA.PrivateKey)keyDecoder.decodeFromByteArrayBlocking(keyFormat, Base64.decode$default((Base64)base64, (CharSequence)string, (int)0, (int)0, (int)6, null));
        return privateKey.signatureGenerator((CryptographyAlgorithmId)SHA256.INSTANCE, ECDSA.SignatureFormat.RAW).generateSignatureBlocking(StringsKt.encodeToByteArray((String)jwtMessage));
    }

    @Serializable
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 )2\u00020\u0001:\u0002()B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003BS\b\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u0002\u0010\u000fJ%\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0001\u00a2\u0006\u0002\b'R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\b\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0011\"\u0004\b\u0015\u0010\u0013R\u001a\u0010\t\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0011\"\u0004\b\u0017\u0010\u0013R\u001a\u0010\n\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0011\"\u0004\b\u0019\u0010\u0013R\u001a\u0010\u000b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001b\"\u0004\b\u001f\u0010\u001d\u00a8\u0006*"}, d2={"Lwork/socialhub/kbsky/auth/OAuthProvider$Jwt;", "", "<init>", "()V", "seen0", "", "scope", "", "sub", "aud", "iss", "iat", "exp", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;IILkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getScope", "()Ljava/lang/String;", "setScope", "(Ljava/lang/String;)V", "getSub", "setSub", "getAud", "setAud", "getIss", "setIss", "getIat", "()I", "setIat", "(I)V", "getExp", "setExp", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$auth", "$serializer", "Companion", "auth"})
    public static final class Jwt {
        @NotNull
        public static final Companion Companion = new Companion(null);
        public String scope;
        public String sub;
        public String aud;
        public String iss;
        private int iat;
        private int exp;

        public Jwt() {
            this.iat = -1;
            this.exp = -1;
        }

        @NotNull
        public final String getScope() {
            String string = this.scope;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"scope");
            return null;
        }

        public final void setScope(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.scope = string;
        }

        @NotNull
        public final String getSub() {
            String string = this.sub;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"sub");
            return null;
        }

        public final void setSub(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.sub = string;
        }

        @NotNull
        public final String getAud() {
            String string = this.aud;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"aud");
            return null;
        }

        public final void setAud(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.aud = string;
        }

        @NotNull
        public final String getIss() {
            String string = this.iss;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"iss");
            return null;
        }

        public final void setIss(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.iss = string;
        }

        public final int getIat() {
            return this.iat;
        }

        public final void setIat(int n) {
            this.iat = n;
        }

        public final int getExp() {
            return this.exp;
        }

        public final void setExp(int n) {
            this.exp = n;
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$auth(Jwt self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeStringElement(serialDesc, 0, self.getScope());
            output.encodeStringElement(serialDesc, 1, self.getSub());
            output.encodeStringElement(serialDesc, 2, self.getAud());
            output.encodeStringElement(serialDesc, 3, self.getIss());
            if (output.shouldEncodeElementDefault(serialDesc, 4) ? true : self.iat != -1) {
                output.encodeIntElement(serialDesc, 4, self.iat);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 5) ? true : self.exp != -1) {
                output.encodeIntElement(serialDesc, 5, self.exp);
            }
        }

        public /* synthetic */ Jwt(int seen0, String scope, String sub, String aud, String iss, int iat, int exp, SerializationConstructorMarker serializationConstructorMarker) {
            if (15 != (0xF & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)15, (SerialDescriptor)Jwt$$serializer.INSTANCE.getDescriptor());
            }
            this.scope = scope;
            this.sub = sub;
            this.aud = aud;
            this.iss = iss;
            this.iat = (seen0 & 0x10) == 0 ? -1 : iat;
            this.exp = (seen0 & 0x20) == 0 ? -1 : exp;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lwork/socialhub/kbsky/auth/OAuthProvider$Jwt$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lwork/socialhub/kbsky/auth/OAuthProvider$Jwt;", "auth"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Jwt> serializer() {
                return (KSerializer)Jwt$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

