/*
 * Decompiled with CFR 0.152.
 */
package work.socialhub.kbsky.auth.helper;

import dev.whyoleg.cryptography.CryptographyAlgorithmId;
import dev.whyoleg.cryptography.CryptographyProvider;
import dev.whyoleg.cryptography.algorithms.Digest;
import dev.whyoleg.cryptography.algorithms.SHA256;
import dev.whyoleg.cryptography.operations.Hasher;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.encoding.Base64;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.datetime.Clock;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementBuildersKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import work.socialhub.kbsky.auth.OAuthSession;
import work.socialhub.khttpclient.HttpResponse;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0006J^\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\u0013J2\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\u0013J\b\u0010\u0016\u001a\u00020\tH\u0002J\u0012\u0010\u0017\u001a\u00020\u0018*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\tJ\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u0006H\u0002\u00a8\u0006\u001f"}, d2={"Lwork/socialhub/kbsky/auth/helper/OAuthHelper;", "", "<init>", "()V", "extractXYFromPublicKey", "Lkotlin/Pair;", "", "publicKeyBytes", "makeDPoPHeader", "", "clientId", "endpoint", "method", "dPoPNonce", "accessToken", "authorizationServer", "publicKeyWAffineX", "publicKeyWAffineY", "sign", "Lkotlin/Function1;", "makeClientAssertion", "keyId", "generateRandomValue", "extractDPoPNonce", "Lwork/socialhub/khttpclient/HttpResponse;", "session", "Lwork/socialhub/kbsky/auth/OAuthSession;", "hashS256", "str", "base64Encode", "ary", "auth"})
@SourceDebugExtension(value={"SMAP\nOAuthHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OAuthHelper.kt\nwork/socialhub/kbsky/auth/helper/OAuthHelper\n+ 2 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n*L\n1#1,159:1\n29#2,2:160\n29#2,3:162\n31#2:165\n29#2,3:166\n29#2,3:169\n29#2,3:172\n*S KotlinDebug\n*F\n+ 1 OAuthHelper.kt\nwork/socialhub/kbsky/auth/helper/OAuthHelper\n*L\n49#1:160,2\n52#1:162,3\n49#1:165\n63#1:166,3\n101#1:169,3\n110#1:172,3\n*E\n"})
public final class OAuthHelper {
    @NotNull
    public static final OAuthHelper INSTANCE = new OAuthHelper();

    private OAuthHelper() {
    }

    @NotNull
    public final Pair<byte[], byte[]> extractXYFromPublicKey(@NotNull byte[] publicKeyBytes) {
        Intrinsics.checkNotNullParameter((Object)publicKeyBytes, (String)"publicKeyBytes");
        int xStartIndex = 27;
        int yStartIndex = xStartIndex + 32;
        byte[] x = ArraysKt.sliceArray((byte[])publicKeyBytes, (IntRange)RangesKt.until((int)xStartIndex, (int)(xStartIndex + 32)));
        byte[] y = ArraysKt.sliceArray((byte[])publicKeyBytes, (IntRange)RangesKt.until((int)yStartIndex, (int)(yStartIndex + 32)));
        byte[] byArray = new byte[]{0};
        byte[] byArray2 = ArraysKt.plus((byte[])byArray, (byte[])x);
        byArray = new byte[]{0};
        return new Pair((Object)byArray2, (Object)ArraysKt.plus((byte[])byArray, (byte[])y));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String makeDPoPHeader(@NotNull String clientId, @NotNull String endpoint, @NotNull String method, @NotNull String dPoPNonce, @Nullable String accessToken, @Nullable String authorizationServer, @NotNull byte[] publicKeyWAffineX, @NotNull byte[] publicKeyWAffineY, @NotNull Function1<? super String, byte[]> sign) {
        JsonElement jsonElement;
        JsonObjectBuilder builder$iv;
        void $this$makeDPoPHeader_u24lambda_u241_u24lambda_u240;
        JsonObjectBuilder builder$iv2;
        JsonObjectBuilder builder$iv3;
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)dPoPNonce, (String)"dPoPNonce");
        Intrinsics.checkNotNullParameter((Object)publicKeyWAffineX, (String)"publicKeyWAffineX");
        Intrinsics.checkNotNullParameter((Object)publicKeyWAffineY, (String)"publicKeyWAffineY");
        Intrinsics.checkNotNullParameter(sign, (String)"sign");
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$makeDPoPHeader_u24lambda_u241 = builder$iv3 = new JsonObjectBuilder();
        boolean bl = false;
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$makeDPoPHeader_u24lambda_u241, (String)"alg", (String)"ES256");
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$makeDPoPHeader_u24lambda_u241, (String)"typ", (String)"dpop+jwt");
        boolean $i$f$buildJsonObject2 = false;
        JsonObjectBuilder jsonObjectBuilder = builder$iv2 = new JsonObjectBuilder();
        String string = "jwk";
        JsonObjectBuilder jsonObjectBuilder2 = $this$makeDPoPHeader_u24lambda_u241;
        boolean bl2 = false;
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$makeDPoPHeader_u24lambda_u241_u24lambda_u240, (String)"kty", (String)"EC");
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$makeDPoPHeader_u24lambda_u241_u24lambda_u240, (String)"crv", (String)"P-256");
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$makeDPoPHeader_u24lambda_u241_u24lambda_u240, (String)"x", (String)Base64.encode$default((Base64)((Base64)Base64.Default), (byte[])publicKeyWAffineX, (int)0, (int)0, (int)6, null));
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$makeDPoPHeader_u24lambda_u241_u24lambda_u240, (String)"y", (String)Base64.encode$default((Base64)((Base64)Base64.Default), (byte[])publicKeyWAffineY, (int)0, (int)0, (int)6, null));
        Unit unit = Unit.INSTANCE;
        jsonObjectBuilder2.put(string, (JsonElement)builder$iv2.build());
        JsonObject headerJson = builder$iv3.build();
        long epoch = Clock.System.INSTANCE.now().getEpochSeconds();
        boolean $i$f$buildJsonObject3 = false;
        JsonObjectBuilder $this$makeDPoPHeader_u24lambda_u242 = builder$iv = new JsonObjectBuilder();
        boolean bl3 = false;
        if (authorizationServer != null && accessToken != null) {
            JsonElementBuildersKt.put((JsonObjectBuilder)$this$makeDPoPHeader_u24lambda_u242, (String)"iss", (String)authorizationServer);
            jsonElement = JsonElementBuildersKt.put((JsonObjectBuilder)$this$makeDPoPHeader_u24lambda_u242, (String)"ath", (String)INSTANCE.hashS256(accessToken));
        } else {
            jsonElement = JsonElementBuildersKt.put((JsonObjectBuilder)$this$makeDPoPHeader_u24lambda_u242, (String)"iss", (String)clientId);
        }
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$makeDPoPHeader_u24lambda_u242, (String)"sub", (String)clientId);
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$makeDPoPHeader_u24lambda_u242, (String)"htu", (String)endpoint);
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$makeDPoPHeader_u24lambda_u242, (String)"htm", (String)method);
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$makeDPoPHeader_u24lambda_u242, (String)"exp", (Number)(epoch + (long)60));
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$makeDPoPHeader_u24lambda_u242, (String)"jti", (String)INSTANCE.generateRandomValue());
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$makeDPoPHeader_u24lambda_u242, (String)"iat", (Number)(epoch - (long)10));
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$makeDPoPHeader_u24lambda_u242, (String)"nonce", (String)dPoPNonce);
        JsonObject payloadJson = builder$iv.build();
        String headerBase64 = this.base64Encode(io.ktor.utils.io.core.StringsKt.toByteArray$default((String)headerJson.toString(), null, (int)1, null));
        String payloadBase64 = this.base64Encode(io.ktor.utils.io.core.StringsKt.toByteArray$default((String)payloadJson.toString(), null, (int)1, null));
        String jwtMessage = headerBase64 + "." + payloadBase64;
        String jwtSignature = this.base64Encode((byte[])sign.invoke((Object)jwtMessage));
        return headerBase64 + "." + payloadBase64 + "." + jwtSignature;
    }

    @NotNull
    public final String makeClientAssertion(@NotNull String keyId, @NotNull String clientId, @NotNull String authorizationServer, @NotNull Function1<? super String, byte[]> sign) {
        JsonObjectBuilder builder$iv;
        JsonObjectBuilder builder$iv2;
        Intrinsics.checkNotNullParameter((Object)keyId, (String)"keyId");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)authorizationServer, (String)"authorizationServer");
        Intrinsics.checkNotNullParameter(sign, (String)"sign");
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$makeClientAssertion_u24lambda_u243 = builder$iv2 = new JsonObjectBuilder();
        boolean bl = false;
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$makeClientAssertion_u24lambda_u243, (String)"typ", (String)"JWT");
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$makeClientAssertion_u24lambda_u243, (String)"alg", (String)"ES256");
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$makeClientAssertion_u24lambda_u243, (String)"kid", (String)keyId);
        JsonObject headerJson = builder$iv2.build();
        long epoch = Clock.System.INSTANCE.now().getEpochSeconds();
        boolean $i$f$buildJsonObject2 = false;
        JsonObjectBuilder $this$makeClientAssertion_u24lambda_u244 = builder$iv = new JsonObjectBuilder();
        boolean bl2 = false;
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$makeClientAssertion_u24lambda_u244, (String)"iss", (String)clientId);
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$makeClientAssertion_u24lambda_u244, (String)"sub", (String)clientId);
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$makeClientAssertion_u24lambda_u244, (String)"aud", (String)authorizationServer);
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$makeClientAssertion_u24lambda_u244, (String)"jti", (String)INSTANCE.generateRandomValue());
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$makeClientAssertion_u24lambda_u244, (String)"iat", (Number)(epoch - (long)10));
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$makeClientAssertion_u24lambda_u244, (String)"exp", (Number)(epoch + (long)300));
        JsonObject payloadJson = builder$iv.build();
        String headerBase64 = this.base64Encode(io.ktor.utils.io.core.StringsKt.toByteArray$default((String)headerJson.toString(), null, (int)1, null));
        String payloadBase64 = this.base64Encode(io.ktor.utils.io.core.StringsKt.toByteArray$default((String)payloadJson.toString(), null, (int)1, null));
        String jwtMessage = headerBase64 + "." + payloadBase64;
        String jwtSignature = this.base64Encode((byte[])sign.invoke((Object)jwtMessage));
        return headerBase64 + "." + payloadBase64 + "." + jwtSignature;
    }

    private final String generateRandomValue() {
        byte[] randomValueBytes = new byte[32];
        Random.Default.nextBytes(randomValueBytes);
        return Base64.encode$default((Base64)((Base64)Base64.Default), (byte[])randomValueBytes, (int)0, (int)0, (int)6, null);
    }

    @NotNull
    public final HttpResponse extractDPoPNonce(@NotNull HttpResponse $this$extractDPoPNonce, @NotNull OAuthSession session) {
        HttpResponse httpResponse;
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$extractDPoPNonce, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            HttpResponse it = httpResponse = $this$extractDPoPNonce;
            boolean bl = false;
            List list = (List)$this$extractDPoPNonce.getHeaders().get("dpop-nonce");
            if (list == null) break block0;
            List it2 = list;
            boolean bl2 = false;
            session.setDPoPNonce((String)it2.get(0));
        }
        return httpResponse;
    }

    @NotNull
    public final String hashS256(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        Hasher s256 = ((Digest)CryptographyProvider.Companion.getDefault().get((CryptographyAlgorithmId)SHA256.INSTANCE)).hasher();
        byte[] seed = StringsKt.encodeToByteArray((String)str);
        return StringsKt.replace$default((String)Base64.encode$default((Base64)Base64.Default.getUrlSafe(), (byte[])s256.hashBlocking(seed), (int)0, (int)0, (int)6, null), (String)"=", (String)"", (boolean)false, (int)4, null);
    }

    private final String base64Encode(byte[] ary) {
        return StringsKt.replace$default((String)Base64.encode$default((Base64)Base64.Default.getUrlSafe(), (byte[])ary, (int)0, (int)0, (int)6, null), (String)"=", (String)"", (boolean)false, (int)4, null);
    }
}

