package work.wangjw.aop;

import work.wangjw.util.IPUtil;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @author wjw
 * @since 2021/5/21 10:33
 **/
@Aspect
@Slf4j
public class GlobalAspect {
    @Pointcut("@annotation(org.springframework.web.bind.annotation.GetMapping)")
    public void executionServiceByGet() {

    }

    @Pointcut("@annotation(org.springframework.web.bind.annotation.PostMapping)")
    public void executionServiceByPost() {

    }

    @Pointcut("executionServiceByGet() || executionServiceByPost()")
    public void executionService() {

    }


    @Around(value = "executionService()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        log.info("========================================== Start ==========================================");
        HttpServletRequest request = ((ServletRequestAttributes) Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
        String reqUrl = request.getRequestURL().toString();
        String queryString = request.getQueryString();
        if (queryString != null && queryString.length() != 0) {
            queryString = URLDecoder.decode(queryString, "UTF-8");
            reqUrl = reqUrl + "?" + queryString;
        }
        log.info("URL            : {}", reqUrl);
        // 打印 Http method
        log.info("HTTP Method    : {}", request.getMethod());
        // 打印调用 controller 的全路径以及执行方法
        log.info("Class Method   : {}.{}", joinPoint.getSignature().getDeclaringTypeName(), joinPoint.getSignature().getName());
        // 打印请求的 IP
        log.info("IP             : {}", IPUtil.getIpAddr());
        // 打印请求入参
        Object[] args = joinPoint.getArgs();
        List<Object> paramList = new ArrayList<>();
        if (null != args && args.length > 0) {
            for (Object obj : args) {
                //JsonUtils.toJson时HttpServletRequest，HttpServletResponse，MultipartFile这些参数会报错，所以要排除掉
                if (!(obj instanceof HttpServletRequest) && !(obj instanceof HttpServletResponse) && !(obj instanceof MultipartFile)) {
                    paramList.add(obj);
                }
            }
        }
        log.info("Request Args   : {}", paramList);
        Date startTime = new Date();
        Object proceed = joinPoint.proceed();
        Date endTime = new Date();
        log.info("Time-Consuming : {} ms", endTime.getTime() - startTime.getTime());
        log.info("========================================== end ============================================");
        return proceed;
    }
}
