package work.wangjw.aop;

import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import work.wangjw.annotation.valid.*;
import work.wangjw.exception.WjwException;
import work.wangjw.util.ObjUtil;
import work.wangjw.util.StrUtil;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.regex.Pattern;

@Aspect
@Slf4j
public class ValidAspect {

    @Pointcut("@annotation(org.springframework.web.bind.annotation.GetMapping)")
    public void executionServiceByGet() {

    }

    @Pointcut("@annotation(org.springframework.web.bind.annotation.PostMapping)")
    public void executionServiceByPost() {

    }

    @Pointcut("executionServiceByGet() || executionServiceByPost()")
    public void executionService() {

    }


    @Around(value = "executionService()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] args = joinPoint.getArgs();
        boolean isError = false;
        StringBuilder message = new StringBuilder();
        for (Object obj : args) {
            if (ObjUtil.isNull(obj)) {
                continue;
            }
            Valid valid = obj.getClass().getAnnotation(Valid.class);
            if (valid != null) {
                for (Field field : obj.getClass().getDeclaredFields()) {
                    char[] chars = field.getName().toCharArray();
                    chars[0] -= 32;
                    String methodName = "get" + String.valueOf(chars);
                    Method method = obj.getClass().getMethod(methodName);
                    Object value = method.invoke(obj);
                    NotNull notNull = field.getAnnotation(NotNull.class);
                    if (Objects.nonNull(notNull) && Objects.isNull(value)) {
                        message.append(isError ? "," : "").append(StrUtil.isEmpty(notNull.message()) ? field.getName() + "不能为null" : notNull.message());
                        isError = true;
                    }
                    Digits digits = field.getAnnotation(Digits.class);
                    if (Objects.nonNull(digits)) {
                        if (Objects.isNull(value)) {
                            throw new WjwException(field.getName() + "不能为null");
                        }
                        if (!(value instanceof Number)) {
                            throw new RuntimeException("注解Digits只能放在数字(Number子类)类型字段上");
                        }
                        Number number = (Number) value;
                        if (digits.max() < number.doubleValue()) {
                            message.append(isError ? "," : "").append(StrUtil.isEmpty(digits.message()) ? field.getName() + "不能大于" + digits.max() : digits.message());
                            isError = true;
                        }
                        if (digits.min() > number.doubleValue()) {
                            message.append(isError ? "," : "").append(StrUtil.isEmpty(digits.message()) ? field.getName() + "不能小于" + digits.min() : digits.message());
                            isError = true;
                        }
                    }
                    Size size = field.getAnnotation(Size.class);
                    if (Objects.nonNull(size)) {
                        if (Objects.isNull(value)) {
                            throw new WjwException(field.getName() + "不能为null");
                        }
                        if (!(value instanceof String)) {
                            throw new RuntimeException("注解Size只能放在String类型字段上");
                        }
                        String string = (String) value;
                        if (size.max() < string.length()) {
                            message.append(isError ? "," : "").append(StrUtil.isEmpty(size.message()) ? field.getName() + "长度不能大于" + size.max() : size.message());
                            isError = true;
                        }
                        if (size.min() > string.length()) {
                            message.append(isError ? "," : "").append(StrUtil.isEmpty(size.message()) ? field.getName() + "长度不能小于" + size.min() : size.message());
                            isError = true;
                        }
                    }
                    Email email = field.getAnnotation(Email.class);
                    if (Objects.nonNull(email)) {
                        if (Objects.isNull(value)) {
                            throw new WjwException(field.getName() + "不能为null");
                        }
                        if (!(value instanceof String)) {
                            throw new RuntimeException("注解Email只能放在String类型字段上");
                        }
                        String string = (String) value;
                        boolean matches = Pattern.matches("^[a-zA-Z0-9_-]+@[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)+$", string);
                        if (!matches) {
                            message.append(isError ? "," : "").append(StrUtil.isEmpty(email.message()) ? field.getName() + "不是邮箱格式" : email.message());
                            isError = true;
                        }
                    }
                    Phone phone = field.getAnnotation(Phone.class);
                    if (Objects.nonNull(phone)) {
                        if (Objects.isNull(value)) {
                            throw new WjwException(field.getName() + "不能为null");
                        }
                        String string = value.toString();
                        boolean matches = Pattern.matches("^1[34578]\\d{9}$", string);
                        if (!matches) {
                            message.append(isError ? "," : "").append(StrUtil.isEmpty(phone.message()) ? field.getName() + "不是手机号格式" : phone.message());
                            isError = true;
                        }
                    }
                    Regular regular = field.getAnnotation(Regular.class);
                    if (Objects.nonNull(regular)) {
                        if (!(value instanceof String)) {
                            throw new RuntimeException("注解Regular只能放在String类型字段上");
                        }
                        String string = (String) value;
                        boolean matches = Pattern.matches(regular.value(), string);
                        if (!matches) {
                            message.append(isError ? "," : "").append(StrUtil.isEmpty(regular.message()) ? field.getName() + "不符合正则表达式" : regular.message());
                            isError = true;
                        }
                    }
                }
            }
        }
        if (isError) {
            throw new WjwException(message.toString());
        }
        return joinPoint.proceed();
    }
}
