package work.wangjw.bean;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author wjw
 * @since 2021/5/21 17:18
 **/
@Data
@AllArgsConstructor
@NoArgsConstructor
public class R<T> {
    private int status;
    private T data;
    private String message;

    public static R<Void> ok() {
        return new R<>(200, null, null);
    }

    public static <T> R<T> ok(T data) {
        return new R<>(200, data, null);
    }

    public static R<Void> ok(String message) {
        return new R<>(200, null, message);
    }


    public static <T> R<T> ok(T data, String message) {
        return new R<>(200, data, message);
    }

    public static R<Void> fail(Integer status) {
        return new R<>(status, null, null);
    }

    public static <T> R<T> fail(Integer status, T data) {
        return new R<>(status, data, null);
    }

    public static R<Void> fail(Integer status, String message) {
        return new R<>(status, null, message);
    }

    public static <T> R<T> fail(Integer status, T data, String message) {
        return new R<>(status, data, message);
    }
}
