package work.wangjw.exception;

import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import work.wangjw.bean.R;

/**
 * @author wjw
 * @since 2021/4/6 10:51
 */
@RestControllerAdvice
public class WjwExceptionHandler {

    private static final Integer FAIL = 500;

    @ExceptionHandler(WjwException.class)
    public R<Void> wjwException(WjwException e) {
        return R.fail(FAIL, e.getMessage());
    }
}
