package work.wangjw.interceptor;

import lombok.extern.slf4j.Slf4j;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import work.wangjw.annotation.LimitRate;
import work.wangjw.exception.WjwException;
import work.wangjw.util.IPUtil;
import work.wangjw.util.RedisUtil;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Objects;

/**
 * @author gavin
 */
@Slf4j
public class LimitRateInterceptor implements HandlerInterceptor {
    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod) handler;
        LimitRate limitRate = handlerMethod.getMethodAnnotation(LimitRate.class);
        if (Objects.isNull(limitRate)) {
            limitRate = handlerMethod.getBeanType().getAnnotation(LimitRate.class);
        }
        if (Objects.nonNull(limitRate)) {
            String ip = IPUtil.getIpAddr();
            log.info("ip为:{}", ip);
            if (Objects.nonNull(RedisUtil.get(ip + handlerMethod.getMethod().getName()))) {
                throw new WjwException(limitRate.message());
            }
            RedisUtil.set(ip + handlerMethod.getMethod().getName(), 1, limitRate.value());
        }
        return true;
    }
}
