package work.wangjw.util;

import com.alibaba.fastjson.JSON;
import com.ejlchina.okhttps.HTTP;
import lombok.SneakyThrows;
import org.springframework.web.multipart.MultipartFile;
import work.wangjw.component.FileProperties;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * @author gavin
 * @since 2021/12/28
 */
public class FileUtil {
    private static FileProperties fileProperties;
    private static HTTP http;

    @Resource
    public void setFileProperties(FileProperties fileProperties) {
        FileUtil.fileProperties = fileProperties;
        http = HTTP.builder().baseUrl(fileProperties.getHost()).build();
    }


    @SneakyThrows
    public static String upload(MultipartFile file, String dir) {
        String filename = file.getOriginalFilename();
        String suffix = Objects.requireNonNull(filename).substring(filename.lastIndexOf(".") + 1);
        return http.sync("/upload")
                .addFilePara("file", suffix, file.getBytes())
                .addBodyPara("path", dir)
                .post().getBody().toString();
    }

    @SneakyThrows
    public static Boolean remove(String url) {
        String path = http.sync("/delete").addBodyPara("path", url.substring(fileProperties.getHost().length())).post().getBody().toString();
        return "ok".equals(JSON.parseObject(path).get("status"));
    }
}
