package work.wangjw.util;

import work.wangjw.util.bean.SnowFlake;

import java.util.UUID;

/**
 * @author Gavin
 * @since 2021/8/5 16:50
 */
public class IdUtil {
    /**
     * 生成UUID
     *
     * @return UUID
     */
    public static String UUID() {
        return UUID.randomUUID().toString();
    }

    /**
     * 生成去掉“-”的UUID
     *
     * @return simpleUUID
     */
    public static String simpleUUID() {
        return UUID().replace("-", "");
    }

    private volatile static SnowFlake snowFlake;

    /**
     * 获取单例SnowFlake对象
     *
     */
    public static SnowFlake getSnowFlake() {
        if (snowFlake == null) {
            synchronized (IdUtil.class) {
                if (snowFlake == null) {
                    snowFlake = new SnowFlake(1);
                }
            }
        }
        return snowFlake;
    }

    /**
     * 创建新SnowFlake对象
     *
     * @return 结果
     */
    public static SnowFlake createSnowFlake(long workerId) {
        return new SnowFlake(workerId);
    }
}
